/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import generic.stl.Pair;
import ghidra.app.plugin.match.MatchedData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.search.trie.ByteTrie;
import ghidra.util.search.trie.ByteTrieIfc;
import ghidra.util.search.trie.ByteTrieNodeIfc;
import ghidra.util.search.trie.SearchResult;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MatchData {
    private MatchData() {
    }

    public static List<MatchedData> matchData(Program aProgram, AddressSetView setA, Program bProgram, AddressSetView setB, int minimumDataSize, int maximumDataSize, int alignment, boolean skipHomogenousData, boolean includeOneToOne, boolean includeNonOneToOne, TaskMonitor monitor) throws CancelledException {
        if (alignment < 1) {
            alignment = 1;
        }
        setA = MatchData.removeUninitializedBlocks(aProgram, setA);
        setB = MatchData.removeUninitializedBlocks(bProgram, setB);
        ArrayList<MatchedData> result = new ArrayList<MatchedData>();
        ByteTrieIfc<Pair<Set<Address>, Set<Address>>> sourceTrie = MatchData.extractSourceHashes(aProgram, setA, minimumDataSize, maximumDataSize, skipHomogenousData, monitor);
        MatchData.findDestinationMatches(aProgram, bProgram, setB, minimumDataSize, alignment, includeOneToOne, includeNonOneToOne, result, sourceTrie, monitor);
        monitor.setMessage("");
        return result;
    }

    private static ByteTrieIfc<Pair<Set<Address>, Set<Address>>> extractSourceHashes(Program aProgram, AddressSetView setA, int minimumDataSize, int maximumDataSize, boolean skipHomogenousData, TaskMonitor monitor) throws CancelledException {
        ByteTrie<Pair<Set<Address>, Set<Address>>> trie = new ByteTrie<Pair<Set<Address>, Set<Address>>>();
        int numDefinedData = (int)aProgram.getListing().getNumDefinedData();
        monitor.initialize((long)numDefinedData);
        monitor.setMessage("(1 of 4) Compiling source data");
        DataIterator aProgDataIter = aProgram.getListing().getDefinedData(setA, true);
        while (aProgDataIter.hasNext()) {
            ByteTrieNodeIfc node;
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            Data aData = aProgDataIter.next();
            int length = aData.getLength();
            if (length < minimumDataSize || length > maximumDataSize) continue;
            boolean doHash = true;
            byte[] bytes = null;
            if (skipHomogenousData) {
                boolean different = false;
                try {
                    bytes = aData.getBytes();
                }
                catch (MemoryAccessException e) {
                    throw new RuntimeException(e);
                }
                byte first = bytes[0];
                for (int ii = 1; ii < bytes.length; ++ii) {
                    if (bytes[ii] == first) continue;
                    different = true;
                    break;
                }
                doHash = different;
            }
            if (!doHash) continue;
            if (bytes == null) {
                try {
                    bytes = aData.getBytes();
                }
                catch (MemoryAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if ((node = trie.find(bytes)) == null || !node.isTerminal()) {
                HashSet<Address> set = new HashSet<Address>();
                set.add(aData.getAddress());
                trie.add(bytes, (Pair<Set<Address>, Set<Address>>)new Pair(set, new HashSet()));
                continue;
            }
            ((Set)((Pair)node.getItem()).first).add(aData.getAddress());
        }
        return trie;
    }

    private static void findDestinationMatches(Program aProgram, Program bProgram, AddressSetView setB, int minimumDataSize, int alignment, boolean includeOneToOne, boolean includeNonOneToOne, List<MatchedData> result, ByteTrieIfc<Pair<Set<Address>, Set<Address>>> sourceTrie, TaskMonitor monitor) throws CancelledException {
        List<SearchResult<Address, Pair<Set<Address>, Set<Address>>>> searchResults;
        try {
            monitor.setMessage("(2 of 4) Search destination bytes");
            searchResults = sourceTrie.search(bProgram.getMemory(), setB, monitor);
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException(e);
        }
        Listing bListing = bProgram.getListing();
        AddressSet dataExtents = new AddressSet();
        AddressSet dataStarts = new AddressSet();
        DataIterator definedData = bListing.getDefinedData(true);
        while (definedData.hasNext()) {
            Data data = definedData.next();
            dataExtents.add(data.getMinAddress(), data.getMaxAddress());
            dataStarts.add(data.getMinAddress());
        }
        monitor.initialize((long)searchResults.size());
        monitor.setMessage("(3 of 4) Post-process search results");
        for (SearchResult<Address, Pair<Set<Address>, Set<Address>>> searchResult : searchResults) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            Address bLocation = searchResult.getPosition();
            if (bLocation.getOffset() % (long)alignment != 0L || !dataStarts.contains(bLocation) && dataExtents.contains(bLocation)) continue;
            Pair<Set<Address>, Set<Address>> item = searchResult.getItem();
            Set bLocations = (Set)item.second;
            bLocations.add(bLocation);
        }
        MatchData.generateMatches(result, aProgram, bProgram, searchResults, alignment, includeOneToOne, includeNonOneToOne, monitor);
    }

    private static void generateMatches(List<MatchedData> result, Program aProgram, Program bProgram, List<SearchResult<Address, Pair<Set<Address>, Set<Address>>>> searchResults, int alignment, boolean includeOneToOne, boolean includeNonOneToOne, TaskMonitor monitor) throws CancelledException {
        HashSet<ByteTrieNodeIfc<Pair<Set<Address>, Set<Address>>>> done = new HashSet<ByteTrieNodeIfc<Pair<Set<Address>, Set<Address>>>>();
        Listing aListing = aProgram.getListing();
        Listing bListing = bProgram.getListing();
        monitor.initialize((long)searchResults.size());
        monitor.setMessage("(4 of 4) Create match objects");
        for (SearchResult<Address, Pair<Set<Address>, Set<Address>>> searchResult : searchResults) {
            boolean processResult;
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            ByteTrieNodeIfc<Pair<Set<Address>, Set<Address>>> node = searchResult.getNode();
            if (done.contains(node)) continue;
            Pair<Set<Address>, Set<Address>> pair = searchResult.getItem();
            Set aLocations = (Set)pair.first;
            Set bLocations = (Set)pair.second;
            int aSize = aLocations.size();
            int bSize = bLocations.size();
            boolean bl = processResult = includeOneToOne && aSize == 1 && bSize == 1 || includeNonOneToOne && (aSize > 1 || bSize > 1);
            if (processResult) {
                for (Address aLocation : aLocations) {
                    for (Address bLocation : bLocations) {
                        Data aDatum = aListing.getDataAt(aLocation);
                        Data bDatum = bListing.getDataAt(bLocation);
                        MatchedData matchedData = new MatchedData(aProgram, bProgram, aLocation, bLocation, aDatum, bDatum, aSize, bSize, null);
                        result.add(matchedData);
                    }
                }
            }
            done.add(node);
        }
    }

    private static AddressSetView removeUninitializedBlocks(Program program, AddressSetView addrSet) {
        return addrSet.intersect(program.getMemory().getLoadedAndInitializedAddressSet());
    }
}

