/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4;

public class DWARFRange
implements Comparable<DWARFRange> {
    public static final DWARFRange EMPTY = new DWARFRange(0L, 1L);
    private final long start;
    private final long end;

    public DWARFRange(long start, long end) {
        if (end < start) {
            throw new IllegalArgumentException("Range max (" + end + ") cannot be less than min (" + start + ").");
        }
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return "(" + this.start + "," + this.end + ")";
    }

    @Override
    public int compareTo(DWARFRange other) {
        int tmp = Long.compare(this.start, other.start);
        if (tmp == 0) {
            tmp = Long.compare(this.end, other.end);
        }
        return tmp;
    }

    public long getFrom() {
        return this.start;
    }

    public long getTo() {
        return this.end;
    }
}

