/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VersionMinCommand
extends LoadCommand {
    private int version;
    private int sdk;

    VersionMinCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.version = reader.readNextInt();
        this.sdk = reader.readNextInt();
    }

    @Override
    public String getCommandName() {
        return "version_min_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(addr, this.toDataType());
                api.setPlateComment(addr, LoadCommandTypes.getLoadCommandName(this.getCommandType()));
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "sdk", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSdk() {
        return this.sdk;
    }
}

