/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexMethodDefOrRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableMethodImpl
extends CliAbstractTable {
    public CliTableMethodImpl(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliMethodImplRow(this.readTableIndex(reader, CliTypeTable.TypeDef), CliIndexMethodDefOrRef.readCodedIndex(reader, stream), CliIndexMethodDefOrRef.readCodedIndex(reader, stream)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MethodImpl Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "Class", "index into TypeDef");
        rowDt.add(CliIndexMethodDefOrRef.toDataType(this.metadataStream), "MethodBody", "MethodDefOrRef coded index");
        rowDt.add(CliIndexMethodDefOrRef.toDataType(this.metadataStream), "MethodDeclaration", "MethodDefOrRef coded index");
        return rowDt;
    }

    public class CliMethodImplRow
    extends CliAbstractTableRow {
        public int classIndex;
        public int methodBodyIndex;
        public int methodDeclarationIndex;

        public CliMethodImplRow(int classIndex, int methodBodyIndex, int methodDeclarationIndex) {
            this.classIndex = classIndex;
            this.methodBodyIndex = methodBodyIndex;
            this.methodDeclarationIndex = methodDeclarationIndex;
        }

        @Override
        public String getRepresentation() {
            String methodDeclarationRep;
            String methodBodyRep;
            try {
                methodBodyRep = CliTableMethodImpl.this.getRowRepresentationSafe(CliIndexMethodDefOrRef.getTableName(this.methodBodyIndex), CliIndexMethodDefOrRef.getRowIndex(this.methodBodyIndex));
            }
            catch (InvalidInputException e) {
                methodBodyRep = Integer.toHexString(this.methodBodyIndex);
            }
            try {
                methodDeclarationRep = CliTableMethodImpl.this.getRowRepresentationSafe(CliIndexMethodDefOrRef.getTableName(this.methodDeclarationIndex), CliIndexMethodDefOrRef.getRowIndex(this.methodDeclarationIndex));
            }
            catch (InvalidInputException e) {
                methodDeclarationRep = Integer.toHexString(this.methodDeclarationIndex);
            }
            return String.format("Class %s MethodBody %s MethodDeclaration %s", CliTableMethodImpl.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.classIndex), methodBodyRep, methodDeclarationRep);
        }
    }
}

