/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.plugin.core.analysis.ReferenceAddressPair;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import utility.function.TerminatingConsumer;

public class ProgramMemoryUtil {
    public static void copyBytesInRanges(Program toProgram, Program fromProgram, Address minAddr, Address maxAddr) throws MemoryAccessException {
        Memory toMem = toProgram.getMemory();
        Memory fromMem = fromProgram.getMemory();
        AddressRangeImpl range = new AddressRangeImpl(minAddr, maxAddr);
        ProgramMemoryUtil.copyByteRange(toMem, fromMem, (AddressRange)range);
    }

    public static void copyBytesInRanges(Program toProgram, Program fromProgram, AddressSetView addrSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory toMem = toProgram.getMemory();
        Memory fromMem = fromProgram.getMemory();
        AddressRangeIterator iter = addrSet.getAddressRanges();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            AddressRange range = (AddressRange)iter.next();
            ProgramMemoryUtil.copyByteRange(toMem, fromMem, range);
        }
    }

    private static void copyByteRange(Memory toMem, Memory fromMem, AddressRange range) throws MemoryAccessException {
        int length = 0;
        Address writeAddress = range.getMinAddress();
        for (long len = range.getLength(); len > 0L; len -= (long)length) {
            length = (int)Math.min(len, Integer.MAX_VALUE);
            byte[] bytes = new byte[length];
            fromMem.getBytes(writeAddress, bytes);
            toMem.setBytes(writeAddress, bytes);
            if (len <= (long)length) continue;
            writeAddress = writeAddress.add((long)length);
        }
    }

    public static MemoryBlock[] getMemBlocks(Program program, boolean withBytes) {
        Memory mem = program.getMemory();
        MemoryBlock[] blocks = mem.getBlocks();
        MemoryBlock[] tmpBlocks = new MemoryBlock[blocks.length];
        int j = 0;
        for (MemoryBlock block : blocks) {
            if ((!block.isInitialized() || !withBytes) && (block.isInitialized() || withBytes)) continue;
            tmpBlocks[j++] = block;
        }
        MemoryBlock[] typeBlocks = new MemoryBlock[j];
        System.arraycopy(tmpBlocks, 0, typeBlocks, 0, j);
        return typeBlocks;
    }

    public static AddressSetView getAddressSet(Program program) {
        MemoryBlock[] memBlocks = program.getMemory().getBlocks();
        AddressSet addrSet = new AddressSet();
        for (MemoryBlock block : memBlocks) {
            addrSet.add(block.getStart(), block.getEnd());
        }
        return addrSet;
    }

    public static AddressSet getAddressSet(Program program, boolean blocksWithBytes) {
        MemoryBlock[] memBlocks = ProgramMemoryUtil.getMemBlocks(program, blocksWithBytes);
        AddressSet addrSet = new AddressSet();
        for (MemoryBlock block : memBlocks) {
            addrSet.add(block.getStart(), block.getEnd());
        }
        return addrSet;
    }

    public static AddressSet getOverlayAddresses(Program program) {
        MemoryBlock[] memBlocks;
        AddressSet addrSet = new AddressSet();
        for (MemoryBlock memoryBlock : memBlocks = program.getMemory().getBlocks()) {
            if (!memoryBlock.isOverlay()) continue;
            AddressRangeImpl addressRange = new AddressRangeImpl(memoryBlock.getStart(), memoryBlock.getEnd());
            addrSet.add((AddressRange)addressRange);
        }
        return addrSet;
    }

    public static void loadDirectReferenceList(Program program, int alignment, Address toAddress, AddressSetView toAddressSet, List<ReferenceAddressPair> directReferenceList, TaskMonitor monitor) throws CancelledException {
        ListAccumulator accumulator = new ListAccumulator();
        ProgramMemoryUtil.loadDirectReferenceList(program, alignment, toAddress, toAddressSet, (Accumulator<ReferenceAddressPair>)accumulator, monitor);
        directReferenceList.addAll(accumulator.get());
    }

    public static void loadDirectReferenceList(Program program, int alignment, Address toAddress, AddressSetView toAddressSet, Accumulator<ReferenceAddressPair> accumulator, TaskMonitor monitor) throws CancelledException {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        Memory memory = program.getMemory();
        boolean isBigEndian = memory.isBigEndian();
        int unitSize = toAddress.getAddressSpace().getAddressableUnitSize();
        int addrSize = toAddress.getSize();
        short currentSegment = 0;
        if (toAddressSet == null || toAddressSet.getNumAddresses() == 1L) {
            Set<Address> refAddrs = ProgramMemoryUtil.findDirectReferences(program, alignment, toAddress, monitor);
            Iterator<Address> refAddrIter = refAddrs.iterator();
            while (refAddrIter.hasNext() && !monitor.isCancelled()) {
                accumulator.add((Object)new ReferenceAddressPair(refAddrIter.next(), toAddress));
            }
            return;
        }
        if (toAddress instanceof SegmentedAddress) {
            SegmentedAddress segAddr = (SegmentedAddress)toAddress;
            currentSegment = (short)segAddr.getSegment();
        }
        AddressIterator addrIt = memory.getLoadedAndInitializedAddressSet().getAddresses(true);
        monitor.initialize(memory.getNumAddresses());
        int count = 0;
        while (addrIt.hasNext()) {
            monitor.checkCancelled();
            Address a = addrIt.next();
            monitor.setProgress((long)(++count));
            if (a.getOffset() % (long)alignment != 0L) continue;
            long addrLong = 0L;
            long addrLongShifted = 0L;
            try {
                Address addr;
                if (toAddress instanceof SegmentedAddress) {
                    short offsetShort = memory.getShort(a);
                    offsetShort = (short)(offsetShort & (offsetShort & 0xFFFF));
                    addrLong = offsetShort;
                } else if (addrSize == 16) {
                    short addrShort = memory.getShort(a);
                    addrLong = (long)addrShort & 0xFFFFL;
                } else if (addrSize == 32) {
                    int addrInt = memory.getInt(a);
                    addrLong = (long)addrInt & 0xFFFFFFFFL;
                } else if (addrSize == 64) {
                    addrLong = memory.getLong(a);
                } else {
                    byte[] dest = new byte[addrSize / 8];
                    int num = memory.getBytes(a, dest);
                    if (num != dest.length) continue;
                    addrLong = 0L;
                    for (int i = 0; i < dest.length; ++i) {
                        int destIndex = isBigEndian ? i : dest.length - i - 1;
                        addrLong = addrLong << 8 | (long)(dest[destIndex] & 0xFF);
                    }
                }
                if (toAddress instanceof SegmentedAddress) {
                    SegmentedAddressSpace space = (SegmentedAddressSpace)toAddress.getAddressSpace();
                    addr = space.getAddress((int)currentSegment, (int)addrLong);
                } else {
                    addr = toAddress.getNewAddress(addrLong * (long)unitSize);
                }
                Address addrShifted = null;
                int addressShiftAmount = program.getDataTypeManager().getDataOrganization().getPointerShift();
                if (addressShiftAmount != 0) {
                    addrLongShifted = addrLong << addressShiftAmount;
                    try {
                        addrShifted = toAddress.getNewAddress(addrLongShifted * (long)unitSize);
                    }
                    catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                        // empty catch block
                    }
                }
                if (toAddressSet.contains(addr)) {
                    accumulator.add((Object)new ReferenceAddressPair(a, addr));
                }
                if (addrShifted == null || !toAddressSet.contains(addrShifted)) continue;
                accumulator.add((Object)new ReferenceAddressPair(a, addrShifted));
            }
            catch (MemoryAccessException memoryAccessException) {
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {}
        }
    }

    public static List<Address> findDirectReferencesCodeUnit(Program program, int alignment, CodeUnit codeUnit, TaskMonitor monitor) {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        AddressSet toAddressSet = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
        ArrayList<ReferenceAddressPair> directReferenceList = new ArrayList<ReferenceAddressPair>();
        ArrayList<Address> results = new ArrayList<Address>();
        try {
            ProgramMemoryUtil.loadDirectReferenceList(program, alignment, toAddressSet.getMinAddress(), (AddressSetView)toAddressSet, directReferenceList, monitor);
        }
        catch (CancelledException e) {
            return Collections.emptyList();
        }
        for (ReferenceAddressPair rap : directReferenceList) {
            if (monitor.isCancelled()) {
                return null;
            }
            Address fromAddr = rap.getSource();
            if (results.contains(fromAddr)) continue;
            results.add(fromAddr);
        }
        return results;
    }

    public static Set<Address> findDirectReferences(Program program, int alignment, Address toAddress, TaskMonitor monitor) throws CancelledException {
        return ProgramMemoryUtil.findDirectReferences(program, null, alignment, toAddress, monitor);
    }

    public static Set<Address> findDirectReferences(Program program, List<MemoryBlock> blocks, int alignment, Address toAddress, TaskMonitor monitor) throws CancelledException {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        byte[] addressBytes = ProgramMemoryUtil.getDirectAddressBytes(program, toAddress);
        byte[] shiftedAddressBytes = ProgramMemoryUtil.getShiftedDirectAddressBytes(program, toAddress);
        Memory memory = program.getMemory();
        TreeSet<Address> dirRefsAddrs = new TreeSet<Address>();
        ProgramMemoryUtil.findBytePattern(memory, blocks, addressBytes, alignment, dirRefsAddrs, monitor);
        if (shiftedAddressBytes != null) {
            ProgramMemoryUtil.findBytePattern(memory, blocks, shiftedAddressBytes, alignment, dirRefsAddrs, monitor);
        }
        return dirRefsAddrs;
    }

    public static byte[] getDirectAddressBytes(Program program, Address toAddress) {
        Memory memory = program.getMemory();
        boolean isBigEndian = memory.isBigEndian();
        int addrSize = toAddress.getSize();
        DataConverter dataConverter = DataConverter.getInstance((boolean)memory.isBigEndian());
        byte[] addressBytes = new byte[addrSize / 8];
        if (toAddress instanceof SegmentedAddress) {
            addressBytes = new byte[2];
            SegmentedAddress segAddr = (SegmentedAddress)toAddress;
            short addrShort = (short)segAddr.getSegmentOffset();
            dataConverter.getBytes(addrShort, addressBytes);
        } else if (addrSize == 64) {
            long addrLong = toAddress.getAddressableWordOffset();
            dataConverter.getBytes(addrLong, addressBytes);
        } else if (addrSize == 32) {
            int addrInt = (int)toAddress.getAddressableWordOffset();
            dataConverter.getBytes(addrInt, addressBytes);
        } else if (addrSize == 16) {
            short addrShort = (short)toAddress.getAddressableWordOffset();
            dataConverter.getBytes(addrShort, addressBytes);
        } else {
            byte[] tempBytes = new byte[8];
            long addrLong = toAddress.getAddressableWordOffset();
            dataConverter.getBytes(addrLong, tempBytes);
            System.arraycopy(tempBytes, isBigEndian ? tempBytes.length - addressBytes.length : 0, addressBytes, 0, addressBytes.length);
        }
        return addressBytes;
    }

    public static byte[] getShiftedDirectAddressBytes(Program program, Address toAddress) {
        long mask;
        long addrLong;
        byte[] addressBytes = ProgramMemoryUtil.getDirectAddressBytes(program, toAddress);
        Memory memory = program.getMemory();
        boolean isBigEndian = memory.isBigEndian();
        Object dataConverter = isBigEndian ? new BigEndianDataConverter() : new LittleEndianDataConverter();
        byte[] shiftedAddressBytes = null;
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        DataOrganization dataOrganization = dataTypeManager.getDataOrganization();
        int addressShiftAmount = dataOrganization.getPointerShift();
        if (addressShiftAmount != 0 && program.getDefaultPointerSize() == addressBytes.length && ((addrLong = toAddress.getAddressableWordOffset()) & (mask = (long)(-1 >> addressShiftAmount << addressShiftAmount))) == addrLong) {
            shiftedAddressBytes = new byte[addressBytes.length];
            byte[] tmpBytes = new byte[8];
            dataConverter.getBytes(addrLong >>= addressShiftAmount, tmpBytes);
            System.arraycopy(tmpBytes, isBigEndian ? tmpBytes.length - addressBytes.length : 0, shiftedAddressBytes, 0, shiftedAddressBytes.length);
        }
        return shiftedAddressBytes;
    }

    public static byte[] getImageBaseOffsets32Bytes(Program program, int alignment, Address toAddress) {
        Address imageBase = program.getImageBase();
        long offsetValue = toAddress.subtract(imageBase);
        int offsetSize = 4;
        byte[] bytes = new byte[offsetSize];
        for (int i = 0; i < offsetSize; ++i) {
            bytes[i] = (byte)offsetValue;
            offsetValue >>= 8;
        }
        return bytes;
    }

    public static Set<Address> findImageBaseOffsets32(Program program, int alignment, Address toAddress, TaskMonitor monitor) throws CancelledException {
        if (monitor == null) {
            monitor = TaskMonitor.DUMMY;
        }
        Memory memory = program.getMemory();
        Address imageBase = program.getImageBase();
        long offsetValue = toAddress.subtract(imageBase);
        int offsetSize = 4;
        byte[] bytes = new byte[offsetSize];
        for (int i = 0; i < offsetSize; ++i) {
            bytes[i] = (byte)offsetValue;
            offsetValue >>= 8;
        }
        TreeSet<Address> iboRefsAddrs = new TreeSet<Address>();
        ProgramMemoryUtil.findBytePattern(memory, (AddressRange)null, bytes, alignment, iboRefsAddrs, monitor);
        return iboRefsAddrs;
    }

    private static void findBytePattern(Memory memory, AddressRange memoryRange, byte[] bytePattern, int alignment, Set<Address> foundList, TaskMonitor monitor) throws CancelledException {
        MemoryBlock[] blocks;
        byte[] maskBytes = null;
        block0: for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (!block.isInitialized() || memoryRange != null && !memoryRange.intersects(block.getStart(), block.getEnd())) continue;
            Address start = block.getStart();
            Address end = block.getEnd();
            Address found = null;
            while (true) {
                monitor.checkCancelled();
                found = memory.findBytes(start, end, bytePattern, maskBytes, true, monitor);
                if (found == null) continue block0;
                start = found.add(1L);
                if (memoryRange != null && !memoryRange.contains(found) || found.getOffset() % (long)alignment != 0L) continue;
                foundList.add(found);
            }
        }
    }

    private static void findBytePattern(Memory memory, List<MemoryBlock> blocks, byte[] bytePattern, int alignment, Set<Address> foundList, TaskMonitor monitor) throws CancelledException {
        byte[] maskBytes = null;
        if (blocks == null) {
            blocks = Arrays.asList(memory.getBlocks());
        }
        block0: for (MemoryBlock memBlock : blocks) {
            if (!memBlock.isInitialized()) continue;
            Address start = memBlock.getStart();
            Address end = memBlock.getEnd();
            while (true) {
                monitor.checkCancelled();
                Address found = memory.findBytes(start, end, bytePattern, maskBytes, true, monitor);
                if (found == null) continue block0;
                start = found.add(1L);
                if (found.getOffset() % (long)alignment != 0L) continue;
                foundList.add(found);
            }
        }
    }

    public static List<Address> findString(String searchString, Program program, List<MemoryBlock> blocks, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        TerminatingConsumer collector = i -> addresses.add((Address)i);
        ProgramMemoryUtil.locateString(searchString, (TerminatingConsumer<Address>)collector, program, blocks, set, monitor);
        return addresses;
    }

    public static void locateString(String searchString, TerminatingConsumer<Address> foundLocationConsumer, Program program, List<MemoryBlock> blocks, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding \"" + searchString + "\".");
        int length = searchString.length();
        byte[] bytes = searchString.getBytes();
        Memory memory = program.getMemory();
        block2: for (MemoryBlock memoryBlock : blocks) {
            monitor.checkCancelled();
            Address startAddress = memoryBlock.getStart();
            Address endAddress = memoryBlock.getEnd();
            do {
                monitor.setMessage("Finding \"" + searchString + "\" @ " + startAddress + ".");
                Address foundAddress = memory.findBytes(startAddress, endAddress, bytes, null, true, monitor);
                if (foundAddress == null) continue block2;
                if (set.contains(foundAddress)) {
                    foundLocationConsumer.accept((Object)foundAddress);
                    if (foundLocationConsumer.terminationRequested()) {
                        return;
                    }
                }
                try {
                    startAddress = foundAddress.add((long)length);
                }
                catch (AddressOutOfBoundsException e) {
                    continue block2;
                }
            } while (startAddress.compareTo((Object)endAddress) <= 0);
        }
    }

    public static List<MemoryBlock> getMemoryBlocksStartingWithName(Program program, AddressSetView set, String name, TaskMonitor monitor) throws CancelledException {
        ArrayList<MemoryBlock> blocks = new ArrayList<MemoryBlock>();
        Memory memory = program.getMemory();
        for (MemoryBlock memoryBlock : memory.getBlocks()) {
            monitor.checkCancelled();
            AddressSet blockSet = new AddressSet(memoryBlock.getStart(), memoryBlock.getEnd());
            AddressSet intersection = blockSet.intersect(set);
            if (intersection.isEmpty() || !memoryBlock.isInitialized() || !memoryBlock.getName().startsWith(name)) continue;
            blocks.add(memoryBlock);
        }
        return blocks;
    }
}

