/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import java.io.IOException;

public class UnionFacetSymbol
extends HighSymbol {
    public static String BASENAME = "unionfacet";
    private int fieldNumber;

    public UnionFacetSymbol(long uniqueId, String nm, DataType dt, int fldNum, HighFunction func) {
        super(uniqueId, nm, dt, func);
        this.category = 2;
        this.fieldNumber = fldNum;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_FACETSYMBOL);
        this.encodeHeader(encoder);
        encoder.writeSignedInteger(AttributeId.ATTRIB_FIELD, this.fieldNumber);
        this.dtmanage.encodeTypeRef(encoder, this.type, this.getSize());
        encoder.closeElement(ElementId.ELEM_FACETSYMBOL);
    }

    public static String buildSymbolName(int fldNum, Address addr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(BASENAME).append(fldNum + 1).append('_');
        buffer.append(Long.toHexString(addr.getOffset()));
        return buffer.toString();
    }

    public static int extractFieldNumber(String nm) {
        int pos = nm.indexOf(BASENAME);
        if (pos < 0) {
            return -1;
        }
        int endpos = nm.indexOf(95, pos);
        if (endpos < 0) {
            return -1;
        }
        return Integer.decode(nm.substring(pos + BASENAME.length(), endpos)) - 1;
    }
}

