/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutFA2Repulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFA2Repulsion;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceAtlas2LayoutAlgorithm<V>
extends AbstractIterativeLayoutAlgorithm<V>
implements VertexBoundsFunctionConsumer<V>,
IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(ForceAtlas2LayoutAlgorithm.class);
    private Function<V, Point> initializer;
    private static final double ks = 0.1;
    private static final double ksMax = 10.0;
    private static final double epsilon = 1.0E-16;
    private boolean useLinLog = false;
    private boolean attractionByWeights = false;
    private double weightsDelta = 1.0;
    private boolean dissuadeHubs = false;
    private StandardFA2Repulsion.Builder repulsionContractBuilder;
    private StandardFA2Repulsion repulsionContract;
    private int maxIterations;
    private int currentIteration;
    private double kg = 5.0;
    private Function<V, Double> nodeSizes;
    private Map<V, Double> nodeMasses;
    private double globalSwg;
    private double globalTra;
    private Map<V, Double> swg;
    private Map<V, Double> trace;
    private double speed = 1.0;
    private double tolerance = 1.0;
    private Map<V, Point> frVertexData;
    private Map<V, Point> prevStepFrVertexData;
    private boolean tuneToGraphSize;

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public ForceAtlas2LayoutAlgorithm() {
        this(ForceAtlas2LayoutAlgorithm.builder());
    }

    protected ForceAtlas2LayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
        this.useLinLog = builder.useLinLog;
        this.attractionByWeights = builder.attractionByWeights;
        this.weightsDelta = builder.weightsDelta;
        this.dissuadeHubs = builder.dissuadeHubs;
        this.maxIterations = builder.maxIterations;
        this.kg = builder.kg;
        this.tolerance = builder.tolerance;
        this.initializer = builder.initializer;
        this.repulsionContractBuilder = builder.repulsionContractBuilder;
    }

    @Override
    public void setVertexBoundsFunction(Function<V, Rectangle> vertexBoundsFunction) {
        this.nodeSizes = v -> {
            Rectangle r = (Rectangle)vertexBoundsFunction.apply(v);
            return Math.max(r.width, r.height);
        };
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        if (graph.vertexSet().size() == 1) {
            Object loner = graph.vertexSet().stream().findFirst().get();
            layoutModel.set(loner, layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
            return;
        }
        if (this.nodeSizes == null) {
            this.nodeSizes = v -> 1.0;
        }
        this.nodeMasses = layoutModel.getGraph().vertexSet().stream().collect(Collectors.toMap(v -> v, v -> (double)layoutModel.getGraph().degreeOf(v) + 1.0));
        if (log.isTraceEnabled()) {
            log.trace("visiting " + layoutModel);
        }
        this.frVertexData = new ConcurrentHashMap<V, Point>(layoutModel.getGraph().vertexSet().size());
        for (Object vertex : layoutModel.getGraph().vertexSet()) {
            this.frVertexData.put((Point)vertex, Point.ORIGIN);
        }
        this.swg = new HashMap<V, Double>(layoutModel.getGraph().vertexSet().size());
        this.trace = new HashMap<V, Double>(layoutModel.getGraph().vertexSet().size());
        this.repulsionContract = ((StandardFA2Repulsion.Builder)((StandardFA2Repulsion.Builder)((StandardFA2Repulsion.Builder)((StandardFA2Repulsion.Builder)((StandardFA2Repulsion.Builder)((StandardFA2Repulsion.Builder)this.repulsionContractBuilder.layoutModel(layoutModel)).nodeData(this.frVertexData)).nodeMasses(this.nodeMasses)).nodeSizes(this.nodeSizes)).initializer(this.initializer)).random(this.random)).build();
        this.currentIteration = 0;
    }

    @Override
    public boolean done() {
        boolean done;
        if (this.cancelled) {
            return true;
        }
        boolean bl = done = this.currentIteration >= this.maxIterations;
        if (done) {
            this.runAfter();
        }
        return done;
    }

    private Point getFRData(V vertex) {
        return this.frVertexData.computeIfAbsent((Point)vertex, (Function<Point, Point>)this.initializer);
    }

    private void calcGravity(V vertex) {
        Point xy = (Point)this.layoutModel.apply(vertex);
        Point center = this.layoutModel.getCenter();
        double r = xy.distanceSquared(center);
        double gravity = -this.kg * this.nodeMasses.get(vertex) / r;
        boolean locked = this.layoutModel.isLocked(vertex);
        if (!locked) {
            Point fvd = this.getFRData(vertex);
            this.frVertexData.put((Point)vertex, fvd.add(gravity * (xy.x - center.x), gravity * (xy.y - center.y)));
        }
    }

    private void calcAttraction(Object edge) {
        Graph graph = this.layoutModel.getGraph();
        Object vertex1 = graph.getEdgeSource(edge);
        Object vertex2 = graph.getEdgeTarget(edge);
        boolean v1_locked = this.layoutModel.isLocked(vertex1);
        boolean v2_locked = this.layoutModel.isLocked(vertex2);
        if (v1_locked && v2_locked) {
            return;
        }
        Point p1 = (Point)this.layoutModel.apply(vertex1);
        Point p2 = (Point)this.layoutModel.apply(vertex2);
        if (p1 == null || p2 == null) {
            return;
        }
        double xDelta = p1.x - p2.x;
        double yDelta = p1.y - p2.y;
        double dist = Math.max(1.0E-16, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
        if ((dist -= this.nodeSizes.apply(vertex1) + this.nodeSizes.apply(vertex2)) > 0.0) {
            double force1;
            double force2;
            if (this.useLinLog) {
                force1 = force2 = Math.log(1.0 + dist);
            } else if (this.dissuadeHubs) {
                force1 = dist / this.nodeMasses.getOrDefault(vertex1, 1.0);
                force2 = dist / this.nodeMasses.getOrDefault(vertex2, 1.0);
            } else {
                force1 = this.attractionByWeights ? (force2 = Math.pow(graph.getEdgeWeight(edge), this.weightsDelta) * dist) : (force2 = dist);
            }
            if (Double.isNaN(force1) || Double.isNaN(force2)) {
                throw new IllegalArgumentException("Unexpected mathematical result in FRLayout:calcPositions");
            }
            force1 /= dist;
            force2 /= dist;
            if (!v1_locked) {
                Point fvd1 = this.getFRData(vertex1);
                this.frVertexData.put((Point)vertex1, fvd1.add(-force1 * xDelta, -force1 * yDelta));
            }
            if (!v2_locked) {
                Point fvd2 = this.getFRData(vertex2);
                this.frVertexData.put((Point)vertex2, fvd2.add(force2 * xDelta, force2 * yDelta));
            }
        }
    }

    private void calcSwinging() {
        this.globalSwg = 0.0;
        this.globalTra = 0.0;
        for (Object vertex : this.layoutModel.getGraph().vertexSet()) {
            double dFx = this.frVertexData.get(vertex).x - this.prevStepFrVertexData.get(vertex).x;
            double dFy = this.frVertexData.get(vertex).y - this.prevStepFrVertexData.get(vertex).y;
            double dFxPlus = this.frVertexData.get(vertex).x + this.prevStepFrVertexData.get(vertex).x;
            double dFyPlus = this.frVertexData.get(vertex).y + this.prevStepFrVertexData.get(vertex).y;
            this.swg.put((Double)vertex, Math.sqrt(dFx * dFx + dFy * dFy));
            this.trace.put((Double)vertex, Math.sqrt(dFxPlus * dFxPlus + dFyPlus * dFyPlus) / 2.0);
            this.globalSwg += this.nodeMasses.get(vertex) * this.swg.get(vertex);
            this.globalTra += this.nodeMasses.get(vertex) * this.trace.get(vertex);
        }
    }

    private synchronized void calcPositions(V vertex) {
        Point fvd = this.getFRData(vertex);
        if (fvd == null) {
            return;
        }
        Point xyd = (Point)this.layoutModel.apply(vertex);
        double deltaLength = Math.max(1.0E-16, fvd.length());
        double positionX = xyd.x;
        double positionY = xyd.y;
        double sn = 0.1 * this.speed / (1.0 + this.speed * Math.sqrt(this.swg.get(vertex)));
        sn = Math.max(sn, 10.0 / deltaLength);
        positionX += fvd.x * sn;
        positionY += fvd.y * sn;
        double borderWidth = (double)this.layoutModel.getWidth() / 50.0;
        if (positionX < borderWidth) {
            positionX = borderWidth + this.random.nextDouble() * borderWidth * 2.0;
        } else if (positionX > (double)this.layoutModel.getWidth() - borderWidth * 2.0) {
            positionX = (double)this.layoutModel.getWidth() - borderWidth - this.random.nextDouble() * borderWidth * 2.0;
        }
        if (positionY < borderWidth) {
            positionY = borderWidth + this.random.nextDouble() * borderWidth * 2.0;
        } else if (positionY > (double)this.layoutModel.getWidth() - borderWidth * 2.0) {
            positionY = (double)this.layoutModel.getWidth() - borderWidth - this.random.nextDouble() * borderWidth * 2.0;
        }
        this.layoutModel.set(vertex, positionX, positionY);
    }

    @Override
    public synchronized void step() {
        if (this.repulsionContract == null) {
            return;
        }
        this.repulsionContract.step();
        Graph graph = this.layoutModel.getGraph();
        ++this.currentIteration;
        this.prevStepFrVertexData = new HashMap<V, Point>(this.frVertexData.size());
        this.frVertexData.forEach((key, value) -> this.prevStepFrVertexData.put((Point)key, Point.of(value.x, value.y)));
        while (true) {
            try {
                this.repulsionContract.calculateRepulsion();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object edge : graph.edgeSet()) {
                    this.calcAttraction(edge);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                for (Object vertex : graph.vertexSet()) {
                    this.calcGravity(vertex);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        while (true) {
            try {
                this.calcSwinging();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        double newSpeed = this.tolerance * this.globalTra / (this.globalSwg + 1.0E-16);
        this.speed = Math.min(newSpeed, this.speed * 1.5);
        while (true) {
            try {
                for (Object vertex : graph.vertexSet()) {
                    if (this.layoutModel.isLocked(vertex)) continue;
                    if (this.cancelled) {
                        return;
                    }
                    this.calcPositions(vertex);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public String toString() {
        String builder = "ForceAtlas2 layout algorithm.\n" + String.format("Gravity constant: %.2f\n", this.kg) + String.format("Swinging tolerance: %.2f\n", this.tolerance);
        return builder;
    }

    public static class Builder<V, T extends ForceAtlas2LayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        private StandardFA2Repulsion.Builder repulsionContractBuilder = new BarnesHutFA2Repulsion.Builder();
        private boolean useLinLog = false;
        private boolean attractionByWeights = false;
        private double weightsDelta = 1.0;
        private boolean dissuadeHubs = false;
        private int maxIterations = 1000;
        private double kg = 5.0;
        private double tolerance = 1.0;
        private Map<V, Double> nodeSizes = null;
        private Map<V, Double> nodeMasses = null;
        private Function<V, Point> initializer = v -> Point.of(this.random.nextDouble(), this.random.nextDouble());

        public B repulsionContractBuilder(StandardFA2Repulsion.Builder repulsionContractBuilder) {
            this.repulsionContractBuilder = repulsionContractBuilder;
            return (B)((Builder)this.self());
        }

        public B initializer(Function<V, Point> initializer) {
            this.initializer = initializer;
            return (B)this;
        }

        public B linLog(boolean useLinLog) {
            this.useLinLog = useLinLog;
            return (B)this;
        }

        public B attractionByWeights(boolean attractionByWeights) {
            this.attractionByWeights = attractionByWeights;
            return (B)this;
        }

        public B delta(double weightsDelta) {
            this.weightsDelta = weightsDelta;
            return (B)this;
        }

        public B dissuadeHubs(boolean dissuadeHubs) {
            this.dissuadeHubs = dissuadeHubs;
            return (B)this;
        }

        public B maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return (B)this;
        }

        public B gravityK(double kg) {
            this.kg = kg;
            return (B)this;
        }

        public B tolerance(double tolerance) {
            this.tolerance = tolerance;
            return (B)this;
        }

        public B nodeSizes(Map<V, Double> nodeSizes) {
            this.nodeSizes = nodeSizes;
            return (B)this;
        }

        public B nodeMasses(Map<V, Double> nodeMasses) {
            this.nodeMasses = nodeMasses;
            return (B)this;
        }

        @Override
        public T build() {
            return (T)new ForceAtlas2LayoutAlgorithm(this);
        }
    }
}

