/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.List;
import java.util.stream.Collectors;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.InsertionOrderSplayTree;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Segment;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.model.Point;

class Container<V>
extends InsertionOrderSplayTree<Segment<V>>
implements LV<V> {
    double measure = -1.0;
    int pos = -1;
    int index;

    public static <V> Container<V> createSubContainer() {
        return new Container<V>();
    }

    public static <V> Container<V> createSubContainer(InsertionOrderSplayTree.Node<Segment<V>> root) {
        Container<V> tree = new Container<V>(root);
        tree.validate();
        return tree;
    }

    protected Container() {
    }

    protected Container(InsertionOrderSplayTree.Node<Segment<V>> root) {
        this.root = root;
    }

    public static <V> Pair<Container<V>> split(Container<V> tree, Segment<V> key) {
        Container<V> right = tree.split(key);
        return Pair.of(tree, right);
    }

    @Override
    public Container<V> split(Segment<V> key) {
        InsertionOrderSplayTree.Node<Segment<V>> node = this.find(key);
        if (node != null) {
            this.splay(node);
            node.size -= Container.size(node.right);
            if (node.right != null) {
                node.right.parent = null;
            }
            if (node.left != null) {
                node.left.parent = null;
            }
            this.root = node.left;
            Container<V> splitter = Container.createSubContainer(node.right);
            splitter.validate();
            this.validate();
            return splitter;
        }
        return this;
    }

    public static <V> Pair<Container<V>> split(Container<V> tree, int position) {
        InsertionOrderSplayTree right = tree.split(position);
        return Pair.of(tree, right);
    }

    @Override
    public Container<V> split(int position) {
        InsertionOrderSplayTree.Node<int> found = this.find(position);
        if (found != null) {
            this.splay(found);
            if (found.right != null) {
                found.right.parent = null;
                found.size -= found.right.size;
            }
            Container<V> splitter = Container.createSubContainer(found.right);
            found.right = null;
            splitter.validate();
            this.validate();
            if (this.find(found) == null) {
                throw new RuntimeException("Node " + found + " at position " + position + " was not still in tree");
            }
            return splitter;
        }
        return Container.createSubContainer();
    }

    @Override
    public <T extends LV<V>> T copy() {
        throw new RuntimeException("Copy of Container not implemented");
    }

    @Override
    public void setRank(int rank) {
    }

    @Override
    public int getRank() {
        return 0;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Point getPoint() {
        return null;
    }

    @Override
    public void setPoint(Point p) {
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    @Override
    public void setPos(int pos) {
        this.pos = pos;
        if (this.measure == -1.0) {
            this.measure = pos;
        }
    }

    @Override
    public double getMeasure() {
        return this.measure;
    }

    @Override
    public void setMeasure(double measure) {
        this.measure = measure;
        this.pos = (int)measure;
    }

    @Override
    public V getVertex() {
        return null;
    }

    public List<Segment<V>> segments() {
        return super.nodes().stream().map(n -> (Segment)n.key).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("Container");
        buf.append(" size:").append(this.size());
        buf.append(" index:").append(this.getIndex());
        buf.append(" pos:").append(this.getPos());
        buf.append(" measure:").append(this.getMeasure());
        buf.append(" {");
        boolean first = true;
        InsertionOrderSplayTree.Iterator iterator = new InsertionOrderSplayTree.Iterator(this.root);
        while (iterator.hasNext()) {
            Object node = iterator.next();
            if (!first) {
                buf.append(", ");
            }
            first = false;
            if (node == null) continue;
            buf.append(((Segment)((InsertionOrderSplayTree.Node)node).key).toString());
        }
        buf.append('}');
        return buf.toString();
    }
}

