/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import com.google.protobuf.ByteString;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.attributes.TargetDataType;
import ghidra.dbg.attributes.TargetObjectList;
import ghidra.dbg.attributes.TargetPrimitiveDataType;
import ghidra.dbg.attributes.TargetStringList;
import ghidra.dbg.gadp.client.GadpClientTargetObject;
import ghidra.dbg.gadp.protocol.Gadp;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.util.CollectionUtils;
import ghidra.dbg.util.PathUtils;
import ghidra.lifecycle.Unfinished;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class GadpValueUtils
extends Enum<GadpValueUtils> {
    private static final /* synthetic */ GadpValueUtils[] $VALUES;

    public static GadpValueUtils[] values() {
        return (GadpValueUtils[])$VALUES.clone();
    }

    public static GadpValueUtils valueOf(String name) {
        return Enum.valueOf(GadpValueUtils.class, name);
    }

    public static TargetObjectList<?> getObjList(DebuggerObjectModel model, Gadp.PathList list) {
        TargetObjectList.DefaultTargetObjectList result = new TargetObjectList.DefaultTargetObjectList();
        for (Gadp.Path path : list.getPathList()) {
            result.add((Object)model.getModelObject((List)path.getEList()));
        }
        return result;
    }

    public static TargetBreakpointSpecContainer.TargetBreakpointKindSet getBreakKindSet(Gadp.BreakKindsSet set) {
        return TargetBreakpointSpecContainer.TargetBreakpointKindSet.copyOf(set.getKList().stream().map(k -> GadpValueUtils.getBreakKind(k)).collect(Collectors.toSet()));
    }

    public static TargetBreakpointSpec.TargetBreakpointKind getBreakKind(Gadp.BreakKind kind) {
        switch (kind) {
            case BK_READ: {
                return TargetBreakpointSpec.TargetBreakpointKind.READ;
            }
            case BK_WRITE: {
                return TargetBreakpointSpec.TargetBreakpointKind.WRITE;
            }
            case BK_EXECUTE: {
                return TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE;
            }
            case BK_SOFTWARE: {
                return TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Gadp.BreakKindsSet makeBreakKindSet(Set<TargetBreakpointSpec.TargetBreakpointKind> set) {
        return Gadp.BreakKindsSet.newBuilder().addAllK(set.stream().map(k -> GadpValueUtils.makeBreakKind(k)).collect(Collectors.toList())).build();
    }

    public static Gadp.BreakKind makeBreakKind(TargetBreakpointSpec.TargetBreakpointKind kind) {
        switch (kind) {
            case READ: {
                return Gadp.BreakKind.BK_READ;
            }
            case WRITE: {
                return Gadp.BreakKind.BK_WRITE;
            }
            case HW_EXECUTE: {
                return Gadp.BreakKind.BK_EXECUTE;
            }
            case SW_EXECUTE: {
                return Gadp.BreakKind.BK_SOFTWARE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TargetAttacher.TargetAttachKindSet getAttachKindSet(Gadp.AttachKindSet set) {
        return TargetAttacher.TargetAttachKindSet.copyOf(set.getKList().stream().map(k -> GadpValueUtils.getAttachKind(k)).collect(Collectors.toSet()));
    }

    public static TargetAttacher.TargetAttachKind getAttachKind(Gadp.AttachKind kind) {
        switch (kind) {
            case AK_BY_OBJECT_REF: {
                return TargetAttacher.TargetAttachKind.BY_OBJECT_REF;
            }
            case AK_BY_ID: {
                return TargetAttacher.TargetAttachKind.BY_ID;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Gadp.AttachKindSet makeAttachKindSet(Set<TargetAttacher.TargetAttachKind> set) {
        return Gadp.AttachKindSet.newBuilder().addAllK(set.stream().map(k -> GadpValueUtils.makeAttachKind(k)).collect(Collectors.toList())).build();
    }

    public static Gadp.AttachKind makeAttachKind(TargetAttacher.TargetAttachKind kind) {
        switch (kind) {
            case BY_OBJECT_REF: {
                return Gadp.AttachKind.AK_BY_OBJECT_REF;
            }
            case BY_ID: {
                return Gadp.AttachKind.AK_BY_ID;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TargetSteppable.TargetStepKindSet getStepKindSet(Gadp.StepKindsSet set) {
        return TargetSteppable.TargetStepKindSet.copyOf(set.getKList().stream().map(k -> GadpValueUtils.getStepKind(k)).collect(Collectors.toSet()));
    }

    public static TargetSteppable.TargetStepKind getStepKind(Gadp.StepKind kind) {
        switch (kind) {
            case SK_FINISH: {
                return TargetSteppable.TargetStepKind.FINISH;
            }
            case SK_INTO: {
                return TargetSteppable.TargetStepKind.INTO;
            }
            case SK_LINE: {
                return TargetSteppable.TargetStepKind.LINE;
            }
            case SK_OVER: {
                return TargetSteppable.TargetStepKind.OVER;
            }
            case SK_OVER_LINE: {
                return TargetSteppable.TargetStepKind.OVER_LINE;
            }
            case SK_RETURN: {
                return TargetSteppable.TargetStepKind.RETURN;
            }
            case SK_SKIP: {
                return TargetSteppable.TargetStepKind.SKIP;
            }
            case SK_UNTIL: {
                return TargetSteppable.TargetStepKind.UNTIL;
            }
            case SK_EXTENDED: {
                return TargetSteppable.TargetStepKind.EXTENDED;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Gadp.StepKind makeStepKind(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case FINISH: {
                return Gadp.StepKind.SK_FINISH;
            }
            case INTO: {
                return Gadp.StepKind.SK_INTO;
            }
            case LINE: {
                return Gadp.StepKind.SK_LINE;
            }
            case OVER: {
                return Gadp.StepKind.SK_OVER;
            }
            case OVER_LINE: {
                return Gadp.StepKind.SK_OVER_LINE;
            }
            case RETURN: {
                return Gadp.StepKind.SK_RETURN;
            }
            case SKIP: {
                return Gadp.StepKind.SK_SKIP;
            }
            case UNTIL: {
                return Gadp.StepKind.SK_UNTIL;
            }
            case EXTENDED: {
                return Gadp.StepKind.SK_EXTENDED;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TargetExecutionStateful.TargetExecutionState getExecutionState(Gadp.ExecutionState state) {
        switch (state) {
            case ES_INACTIVE: {
                return TargetExecutionStateful.TargetExecutionState.INACTIVE;
            }
            case ES_ALIVE: {
                return TargetExecutionStateful.TargetExecutionState.ALIVE;
            }
            case ES_STOPPED: {
                return TargetExecutionStateful.TargetExecutionState.STOPPED;
            }
            case ES_RUNNING: {
                return TargetExecutionStateful.TargetExecutionState.RUNNING;
            }
            case ES_TERMINATED: {
                return TargetExecutionStateful.TargetExecutionState.TERMINATED;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Gadp.ExecutionState makeExecutionState(TargetExecutionStateful.TargetExecutionState state) {
        switch (state) {
            case INACTIVE: {
                return Gadp.ExecutionState.ES_INACTIVE;
            }
            case ALIVE: {
                return Gadp.ExecutionState.ES_ALIVE;
            }
            case STOPPED: {
                return Gadp.ExecutionState.ES_STOPPED;
            }
            case RUNNING: {
                return Gadp.ExecutionState.ES_RUNNING;
            }
            case TERMINATED: {
                return Gadp.ExecutionState.ES_TERMINATED;
            }
        }
        throw new IllegalArgumentException();
    }

    public static TargetEventScope.TargetEventType getTargetEventType(Gadp.TargetEventType type) {
        switch (type) {
            default: {
                return TargetEventScope.TargetEventType.STOPPED;
            }
            case EV_RUNNING: {
                return TargetEventScope.TargetEventType.RUNNING;
            }
            case EV_PROCESS_CREATED: {
                return TargetEventScope.TargetEventType.PROCESS_CREATED;
            }
            case EV_PROCESS_EXITED: {
                return TargetEventScope.TargetEventType.PROCESS_EXITED;
            }
            case EV_THREAD_CREATED: {
                return TargetEventScope.TargetEventType.THREAD_CREATED;
            }
            case EV_THREAD_EXITED: {
                return TargetEventScope.TargetEventType.THREAD_EXITED;
            }
            case EV_MODULE_LOADED: {
                return TargetEventScope.TargetEventType.MODULE_LOADED;
            }
            case EV_MODULE_UNLOADED: {
                return TargetEventScope.TargetEventType.MODULE_UNLOADED;
            }
            case EV_BREAKPOINT_HIT: {
                return TargetEventScope.TargetEventType.BREAKPOINT_HIT;
            }
            case EV_STEP_COMPLETED: {
                return TargetEventScope.TargetEventType.STEP_COMPLETED;
            }
            case EV_EXCEPTION: {
                return TargetEventScope.TargetEventType.EXCEPTION;
            }
            case EV_SIGNAL: 
        }
        return TargetEventScope.TargetEventType.SIGNAL;
    }

    public static Gadp.TargetEventType makeTargetEventType(TargetEventScope.TargetEventType type) {
        switch (type) {
            default: {
                return Gadp.TargetEventType.EV_STOPPED;
            }
            case RUNNING: {
                return Gadp.TargetEventType.EV_RUNNING;
            }
            case PROCESS_CREATED: {
                return Gadp.TargetEventType.EV_PROCESS_CREATED;
            }
            case PROCESS_EXITED: {
                return Gadp.TargetEventType.EV_PROCESS_EXITED;
            }
            case THREAD_CREATED: {
                return Gadp.TargetEventType.EV_THREAD_CREATED;
            }
            case THREAD_EXITED: {
                return Gadp.TargetEventType.EV_THREAD_EXITED;
            }
            case MODULE_LOADED: {
                return Gadp.TargetEventType.EV_MODULE_LOADED;
            }
            case MODULE_UNLOADED: {
                return Gadp.TargetEventType.EV_MODULE_UNLOADED;
            }
            case BREAKPOINT_HIT: {
                return Gadp.TargetEventType.EV_BREAKPOINT_HIT;
            }
            case STEP_COMPLETED: {
                return Gadp.TargetEventType.EV_STEP_COMPLETED;
            }
            case EXCEPTION: {
                return Gadp.TargetEventType.EV_EXCEPTION;
            }
            case SIGNAL: 
        }
        return Gadp.TargetEventType.EV_SIGNAL;
    }

    public static Gadp.Address makeAddress(Address address) {
        return Gadp.Address.newBuilder().setSpace(address.getAddressSpace().getName()).setOffset(address.getOffset()).build();
    }

    public static Gadp.AddressRange makeRange(AddressRange range) {
        return Gadp.AddressRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend((int)(range.getLength() - 1L)).build();
    }

    public static Gadp.ModelObjectDelta makeElementDelta(List<String> parentPath, CollectionUtils.Delta<?, ?> delta) {
        Gadp.ModelObjectDelta.Builder builder = Gadp.ModelObjectDelta.newBuilder().addAllRemoved(delta.getKeysRemoved());
        for (Map.Entry ent : delta.added.entrySet()) {
            builder.addAdded(GadpValueUtils.makeIndexedValue(parentPath, ent));
        }
        return builder.build();
    }

    public static Gadp.ModelObjectDelta makeAttributeDelta(List<String> parentPath, CollectionUtils.Delta<?, ?> delta) {
        Gadp.ModelObjectDelta.Builder builder = Gadp.ModelObjectDelta.newBuilder().addAllRemoved(delta.getKeysRemoved());
        for (Map.Entry ent : delta.added.entrySet()) {
            builder.addAdded(GadpValueUtils.makeNamedValue(parentPath, ent));
        }
        return builder.build();
    }

    public static Gadp.Path makePath(List<String> path) {
        return Gadp.Path.newBuilder().addAllE(path).build();
    }

    public static Gadp.Path makePath(TargetObject obj) {
        return GadpValueUtils.makePath(obj.getPath());
    }

    public static Gadp.PathList makePathList(TargetObjectList<?> list) {
        return Gadp.PathList.newBuilder().addAllPath(list.stream().map(p -> GadpValueUtils.makePath(p)).collect(Collectors.toList())).build();
    }

    public static Gadp.RegisterValue makeRegisterValue(Map.Entry<String, byte[]> e) {
        return Gadp.RegisterValue.newBuilder().setName(e.getKey()).setContent(ByteString.copyFrom((byte[])e.getValue())).build();
    }

    public static Collection<Gadp.RegisterValue> makeRegisterValues(Map<String, byte[]> map) {
        return map.entrySet().stream().map(GadpValueUtils::makeRegisterValue).collect(Collectors.toList());
    }

    public static Map<String, byte[]> getRegisterValueMap(Collection<Gadp.RegisterValue> values) {
        return values.stream().collect(Collectors.toMap(v -> v.getName(), v -> v.getContent().toByteArray()));
    }

    public static Gadp.StepKindsSet makeStepKindSet(Set<TargetSteppable.TargetStepKind> set) {
        return Gadp.StepKindsSet.newBuilder().addAllK(set.stream().map(k -> GadpValueUtils.makeStepKind(k)).collect(Collectors.toList())).build();
    }

    public static Gadp.StringList makeStringList(Collection<String> col) {
        return Gadp.StringList.newBuilder().addAllS(col).build();
    }

    public static TargetStringList getStringList(Gadp.StringList list) {
        return TargetStringList.copyOf((Collection)list.getSList());
    }

    public static Class<?> getValueType(Gadp.ValueType type) {
        switch (type) {
            case VT_VOID: {
                return Void.class;
            }
            case VT_BOOL: {
                return Boolean.class;
            }
            case VT_INT: {
                return Integer.class;
            }
            case VT_LONG: {
                return Long.class;
            }
            case VT_FLOAT: {
                return Float.class;
            }
            case VT_DOUBLE: {
                return Double.class;
            }
            case VT_BYTES: {
                return byte[].class;
            }
            case VT_STRING: {
                return String.class;
            }
            case VT_STRING_LIST: {
                return TargetStringList.class;
            }
            case VT_ADDRESS: {
                return Address.class;
            }
            case VT_RANGE: {
                return AddressRange.class;
            }
            case VT_BREAK_KIND_SET: {
                return TargetBreakpointSpecContainer.TargetBreakpointKindSet.class;
            }
            case VT_EXECUTION_STATE: {
                return TargetExecutionStateful.TargetExecutionState.class;
            }
            case VT_STEP_KIND_SET: {
                return TargetSteppable.TargetStepKindSet.class;
            }
            case VT_PRIMITIVE_KIND: {
                return TargetPrimitiveDataType.class;
            }
            case VT_DATA_TYPE: {
                return TargetDataType.class;
            }
            case VT_PATH: {
                return TargetObject.class;
            }
            case VT_PATH_LIST: {
                return TargetObjectList.class;
            }
            case VT_TYPE: {
                return Class.class;
            }
        }
        throw new AssertionError((Object)("Unrecgonized type: " + type));
    }

    private static <T> TargetMethod.ParameterDescription<T> getParameterDescription(Class<T> valueType, DebuggerObjectModel model, Gadp.Parameter param) {
        if (param.getChoicesCount() != 0) {
            return TargetMethod.ParameterDescription.choices(valueType, (String)param.getName(), (Collection)GadpValueUtils.getValues(model, param.getChoicesList()).stream().map(valueType::cast).collect(Collectors.toList()), (String)param.getDisplay(), (String)param.getDescription());
        }
        return TargetMethod.ParameterDescription.create(valueType, (String)param.getName(), (boolean)param.getRequired(), valueType.cast(GadpValueUtils.getValue(model, null, param.getDefaultValue())), (String)param.getDisplay(), (String)param.getDescription());
    }

    public static TargetMethod.ParameterDescription<?> getParameterDescription(DebuggerObjectModel model, Gadp.Parameter param) {
        return GadpValueUtils.getParameterDescription(GadpValueUtils.getValueType(param.getType()), model, param);
    }

    public static Map<String, TargetMethod.ParameterDescription<?>> getParameters(DebuggerObjectModel model, Gadp.ParameterList params) {
        return TargetMethod.makeParameters(params.getParameterList().stream().map(p -> GadpValueUtils.getParameterDescription(model, p)));
    }

    public static Gadp.ValueType makeValueType(Class<?> type) {
        if (type == Void.class) {
            return Gadp.ValueType.VT_VOID;
        }
        if (type == Boolean.class) {
            return Gadp.ValueType.VT_BOOL;
        }
        if (type == Integer.class) {
            return Gadp.ValueType.VT_INT;
        }
        if (type == Long.class) {
            return Gadp.ValueType.VT_LONG;
        }
        if (type == Float.class) {
            return Gadp.ValueType.VT_FLOAT;
        }
        if (type == Double.class) {
            return Gadp.ValueType.VT_DOUBLE;
        }
        if (type == byte[].class) {
            return Gadp.ValueType.VT_BYTES;
        }
        if (type == String.class) {
            return Gadp.ValueType.VT_STRING;
        }
        if (type == TargetStringList.class) {
            return Gadp.ValueType.VT_STRING_LIST;
        }
        if (type == Address.class) {
            return Gadp.ValueType.VT_ADDRESS;
        }
        if (type == AddressRange.class) {
            return Gadp.ValueType.VT_RANGE;
        }
        if (type == TargetBreakpointSpecContainer.TargetBreakpointKindSet.class) {
            return Gadp.ValueType.VT_BREAK_KIND_SET;
        }
        if (type == TargetExecutionStateful.TargetExecutionState.class) {
            return Gadp.ValueType.VT_EXECUTION_STATE;
        }
        if (type == TargetSteppable.TargetStepKindSet.class) {
            return Gadp.ValueType.VT_STEP_KIND_SET;
        }
        if (type == TargetPrimitiveDataType.class) {
            return Gadp.ValueType.VT_PRIMITIVE_KIND;
        }
        if (type == TargetDataType.class) {
            return Gadp.ValueType.VT_DATA_TYPE;
        }
        if (type == TargetObject.class) {
            return Gadp.ValueType.VT_PATH;
        }
        if (type == TargetObjectList.class) {
            return Gadp.ValueType.VT_PATH_LIST;
        }
        if (type == Class.class) {
            return Gadp.ValueType.VT_TYPE;
        }
        throw new IllegalArgumentException("Cannot encode type: " + type);
    }

    public static Gadp.Parameter makeParameter(TargetMethod.ParameterDescription<?> desc) {
        return Gadp.Parameter.newBuilder().setType(GadpValueUtils.makeValueType(desc.type)).setName(desc.name).setDefaultValue(GadpValueUtils.makeValue(null, desc.defaultValue)).setRequired(desc.required).setDisplay(desc.display).setDescription(desc.description).addAllChoices(GadpValueUtils.makeValues(desc.choices)).build();
    }

    public static Gadp.ParameterList makeParameterList(TargetMethod.TargetParameterMap map) {
        return Gadp.ParameterList.newBuilder().addAllParameter(map.values().stream().map(d -> GadpValueUtils.makeParameter(d)).collect(Collectors.toList())).build();
    }

    public static TargetObject getTargetObjectNonLink(List<String> path, Object value) {
        if (!(value instanceof TargetObject)) {
            return null;
        }
        TargetObject obj = (TargetObject)value;
        if (!Objects.equals(obj.getPath(), path)) {
            return null;
        }
        return obj;
    }

    public static Gadp.Value makeValue(List<String> path, Object value) {
        Gadp.Value.Builder b = Gadp.Value.newBuilder();
        if (value == null) {
            b.clearSpec();
        } else if (value instanceof Boolean) {
            b.setBoolValue((Boolean)value);
        } else if (value instanceof Integer) {
            b.setIntValue((Integer)value);
        } else if (value instanceof Long) {
            b.setLongValue((Long)value);
        } else if (value instanceof Float) {
            b.setFloatValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            b.setDoubleValue((Double)value);
        } else if (value instanceof byte[]) {
            b.setBytesValue(ByteString.copyFrom((byte[])((byte[])value)));
        } else if (value instanceof String) {
            b.setStringValue((String)value);
        } else if (value instanceof TargetStringList) {
            b.setStringListValue(GadpValueUtils.makeStringList((Collection<String>)((TargetStringList)value)));
        } else if (value instanceof Address) {
            b.setAddressValue(GadpValueUtils.makeAddress((Address)value));
        } else if (value instanceof AddressRange) {
            b.setRangeValue(GadpValueUtils.makeRange((AddressRange)value));
        } else if (value instanceof TargetAttacher.TargetAttachKindSet) {
            b.setAttachKindsValue(GadpValueUtils.makeAttachKindSet((Set<TargetAttacher.TargetAttachKind>)((TargetAttacher.TargetAttachKindSet)value)));
        } else if (value instanceof TargetBreakpointSpecContainer.TargetBreakpointKindSet) {
            b.setBreakKindsValue(GadpValueUtils.makeBreakKindSet((Set<TargetBreakpointSpec.TargetBreakpointKind>)((TargetBreakpointSpecContainer.TargetBreakpointKindSet)value)));
        } else if (value instanceof TargetExecutionStateful.TargetExecutionState) {
            b.setExecStateValue(GadpValueUtils.makeExecutionState((TargetExecutionStateful.TargetExecutionState)value));
        } else if (value instanceof TargetSteppable.TargetStepKindSet) {
            b.setStepKindsValue(GadpValueUtils.makeStepKindSet((Set<TargetSteppable.TargetStepKind>)((TargetSteppable.TargetStepKindSet)value)));
        } else if (value instanceof TargetMethod.TargetParameterMap) {
            b.setParametersValue(GadpValueUtils.makeParameterList((TargetMethod.TargetParameterMap)value));
        } else if (path != null && GadpValueUtils.getTargetObjectNonLink(path, value) != null) {
            b.setObjectStub(Gadp.ModelObjectStub.getDefaultInstance());
        } else if (value instanceof TargetObject) {
            b.setPathValue(GadpValueUtils.makePath((TargetObject)value));
        } else if (value instanceof TargetObjectList) {
            b.setPathListValue(GadpValueUtils.makePathList((TargetObjectList)value));
        } else if (value instanceof Class) {
            b.setTypeValue(GadpValueUtils.makeValueType((Class)value));
        } else {
            throw new IllegalArgumentException("Cannot encode value: " + value + " (of type " + value.getClass() + ")");
        }
        return b.build();
    }

    public static Gadp.NamedValue makeNamedValue(Map.Entry<String, ?> ent) {
        return GadpValueUtils.makeNamedValue(null, ent);
    }

    public static Gadp.NamedValue makeNamedValue(List<String> parentPath, Map.Entry<String, ?> ent) {
        List path = parentPath == null ? null : PathUtils.extend(parentPath, (String)ent.getKey());
        return Gadp.NamedValue.newBuilder().setName(ent.getKey()).setValue(GadpValueUtils.makeValue(path, ent.getValue())).build();
    }

    public static Gadp.NamedValue makeIndexedValue(List<String> parentPath, Map.Entry<String, ?> ent) {
        List path = parentPath == null ? null : PathUtils.index(parentPath, (String)ent.getKey());
        return Gadp.NamedValue.newBuilder().setName(ent.getKey()).setValue(GadpValueUtils.makeValue(path, ent.getValue())).build();
    }

    public static Address getAddress(DebuggerObjectModel model, Gadp.Address addr) {
        return model.getAddress(addr.getSpace(), addr.getOffset());
    }

    public static AddressRange getAddressRange(DebuggerObjectModel model, Gadp.AddressRange range) {
        Address min = model.getAddress(range.getSpace(), range.getOffset());
        return new AddressRangeImpl(min, min.add(Integer.toUnsignedLong(range.getExtend())));
    }

    public static Object getValue(DebuggerObjectModel model, List<String> path, Gadp.Value value) {
        switch (value.getSpecCase()) {
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case INT_VALUE: {
                return value.getIntValue();
            }
            case LONG_VALUE: {
                return value.getLongValue();
            }
            case FLOAT_VALUE: {
                return Float.valueOf(value.getFloatValue());
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case BYTES_VALUE: {
                return value.getBytesValue().toByteArray();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case STRING_LIST_VALUE: {
                return GadpValueUtils.getStringList(value.getStringListValue());
            }
            case ADDRESS_VALUE: {
                return GadpValueUtils.getAddress(model, value.getAddressValue());
            }
            case RANGE_VALUE: {
                return GadpValueUtils.getAddressRange(model, value.getRangeValue());
            }
            case ATTACH_KINDS_VALUE: {
                return GadpValueUtils.getAttachKindSet(value.getAttachKindsValue());
            }
            case BREAK_KINDS_VALUE: {
                return GadpValueUtils.getBreakKindSet(value.getBreakKindsValue());
            }
            case EXEC_STATE_VALUE: {
                return GadpValueUtils.getExecutionState(value.getExecStateValue());
            }
            case STEP_KINDS_VALUE: {
                return GadpValueUtils.getStepKindSet(value.getStepKindsValue());
            }
            case PRIMITIVE_KIND_VALUE: {
                return Unfinished.TODO((String)"Marhsalling types over GADP", (Object[])new Object[]{value.getPrimitiveKindValue()});
            }
            case DATA_TYPE_VALUE: {
                return Unfinished.TODO((String)"Marshalling types over GADP", (Object[])new Object[]{value.getDataTypeValue()});
            }
            case PARAMETERS_VALUE: {
                return GadpValueUtils.getParameters(model, value.getParametersValue());
            }
            case PATH_VALUE: {
                return model.getModelObject((List)value.getPathValue().getEList());
            }
            case PATH_LIST_VALUE: {
                return GadpValueUtils.getObjList(model, value.getPathListValue());
            }
            case OBJECT_STUB: {
                return model.getModelObject(path);
            }
            case TYPE_VALUE: {
                return GadpValueUtils.getValueType(value.getTypeValue());
            }
            case SPEC_NOT_SET: {
                return null;
            }
        }
        Msg.error(GadpValueUtils.class, (Object)("Got unknown value type: " + value));
        return null;
    }

    public static Object getAttributeValue(TargetObject object, Gadp.NamedValue attr) {
        return GadpValueUtils.getValue(object.getModel(), PathUtils.extend((List)object.getPath(), (String)attr.getName()), attr.getValue());
    }

    public static GadpClientTargetObject getElementValue(TargetObject object, Gadp.NamedValue elem) {
        Object value = GadpValueUtils.getValue(object.getModel(), PathUtils.index((List)object.getPath(), (String)elem.getName()), elem.getValue());
        if (!(value instanceof GadpClientTargetObject)) {
            Msg.error(GadpValueUtils.class, (Object)("Received non-object-valued element: " + elem));
            return null;
        }
        return (GadpClientTargetObject)value;
    }

    public static Map<String, Object> getAttributeMap(GadpClientTargetObject object, List<Gadp.NamedValue> list) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Gadp.NamedValue attr : list) {
            Object val = GadpValueUtils.getAttributeValue((TargetObject)object, attr);
            if (result.put(attr.getName(), val) == null) continue;
            Msg.warn(GadpValueUtils.class, (Object)("Received duplicate attribute: " + attr));
        }
        return result;
    }

    public static List<Object> getValues(DebuggerObjectModel model, List<Gadp.Value> values) {
        return values.stream().map(v -> GadpValueUtils.getValue(model, null, v)).collect(Collectors.toList());
    }

    public static List<Gadp.Value> makeValues(Collection<?> values) {
        return values.stream().map(v -> GadpValueUtils.makeValue(null, v)).collect(Collectors.toList());
    }

    public static List<Gadp.NamedValue> makeArguments(Map<String, ?> arguments) {
        return arguments.entrySet().stream().map(ent -> GadpValueUtils.makeNamedValue(ent)).collect(Collectors.toList());
    }

    public static Map<String, GadpClientTargetObject> getElementMap(GadpClientTargetObject parent, List<Gadp.NamedValue> list) {
        LinkedHashMap<String, GadpClientTargetObject> result = new LinkedHashMap<String, GadpClientTargetObject>();
        for (Gadp.NamedValue elem : list) {
            GadpClientTargetObject val = GadpValueUtils.getElementValue((TargetObject)parent, elem);
            if (val == null || result.put(elem.getName(), val) == null) continue;
            Msg.warn(GadpValueUtils.class, (Object)("Received duplicate element: " + elem));
        }
        return result;
    }

    public static Map<String, ?> getArguments(DebuggerObjectModel model, List<Gadp.NamedValue> arguments) {
        return arguments.stream().collect(Collectors.toMap(a -> a.getName(), a -> GadpValueUtils.getValue(model, null, a.getValue())));
    }

    private static /* synthetic */ GadpValueUtils[] $values() {
        return new GadpValueUtils[0];
    }

    static {
        $VALUES = GadpValueUtils.$values();
    }
}

