/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb;

import ghidra.dbg.util.ShellUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GdbCompatibility {
    INSTANCE;

    private final Map<String, Boolean> cache = new HashMap<String, Boolean>();

    public static boolean checkGdbPresent(String path) {
        try {
            ProcessBuilder builder = new ProcessBuilder(path, "--version");
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            Process gdb = builder.start();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isCompatible(String gdbCmd) {
        List args = ShellUtils.parseArgs((String)gdbCmd);
        if (args.isEmpty()) {
            return false;
        }
        return this.cache.computeIfAbsent(gdbCmd, p -> GdbCompatibility.checkGdbPresent((String)args.get(0)));
    }
}

