/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.gadp;

import agent.gdb.GdbCompatibility;
import agent.gdb.gadp.GdbGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.dbg.util.ShellUtils;
import ghidra.program.model.listing.Program;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="gdb via GADP", htmlDetails="Connect to gdb.\nThis is best for most Linux and Unix userspace targets, and many embedded targets.\nThis will protect Ghidra's JVM by using a subprocess to access the native API.\nIf you are using <b>gdbserver</b>, you must connect to gdb first (consider the non-GADP\nconnector), then use <code>target remote ...</code> to connect to your target.")
public class GdbGadpDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    private String gdbCmd = "/usr/bin/gdb";
    @ConfigurableFactory.FactoryOption(value="GDB launch command")
    public final ConfigurableFactory.Property<String> gdbCommandOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getGdbCommand, this::setGdbCommand);
    private boolean existing = false;
    @ConfigurableFactory.FactoryOption(value="Use existing session via new-ui")
    public final ConfigurableFactory.Property<Boolean> useExistingOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isUseExisting, this::setUseExisting);

    public int getPriority(Program program) {
        String exe;
        if (!GdbCompatibility.INSTANCE.isCompatible(this.gdbCmd)) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 60;
    }

    public String getGdbCommand() {
        return this.gdbCmd;
    }

    public void setGdbCommand(String gdbCmd) {
        this.gdbCmd = gdbCmd;
    }

    public boolean isUseExisting() {
        return this.existing;
    }

    public void setUseExisting(boolean existing) {
        this.existing = existing;
        this.gdbCommandOption.setEnabled(!existing);
    }

    protected String getThreadName() {
        return "Local gdb Agent stdout";
    }

    protected void completeCommandLine(List<String> cmd) {
        List gdbCmdLine = ShellUtils.parseArgs((String)this.gdbCmd);
        cmd.add(GdbGadpServer.class.getCanonicalName());
        if (!this.existing && gdbCmdLine.size() >= 2) {
            cmd.addAll(gdbCmdLine.subList(1, gdbCmdLine.size()));
        }
        cmd.add("--agent-args");
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
        if (!this.existing && gdbCmdLine.size() >= 1) {
            cmd.add("-g");
            cmd.add((String)gdbCmdLine.get(0));
        } else {
            cmd.add("-x");
        }
    }
}

