/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;

public class TaskMonitorAdapter
implements TaskMonitor {
    private WeakSet<CancelledListener> listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private boolean cancelEnabled = false;
    private volatile boolean cancelled;
    @Deprecated
    public static final TaskMonitor DUMMY_MONITOR = TaskMonitor.DUMMY;

    public TaskMonitorAdapter() {
    }

    public TaskMonitorAdapter(boolean cancelEnabled) {
        this.cancelEnabled = cancelEnabled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void checkCanceled() throws CancelledException {
        if (this.cancelled) {
            throw new CancelledException();
        }
    }

    public void setMessage(String message) {
    }

    public String getMessage() {
        return null;
    }

    public void setProgress(long value) {
    }

    public int getMinimum() {
        return 0;
    }

    public void setMinimum(int min) {
    }

    public long getMaximum() {
        return 0L;
    }

    public void initialize(long max) {
    }

    public void setMaximum(long max) {
    }

    public void setShowProgressValue(boolean showProgressValue) {
    }

    public void setIndeterminate(boolean indeterminate) {
    }

    public boolean isIndeterminate() {
        return false;
    }

    public synchronized void setCancelEnabled(boolean enable) {
        this.cancelEnabled = enable;
    }

    public synchronized boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskMonitorAdapter taskMonitorAdapter = this;
        synchronized (taskMonitorAdapter) {
            if (this.cancelled || !this.cancelEnabled) {
                return;
            }
            this.cancelled = true;
        }
        this.notifyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCanceled() {
        TaskMonitorAdapter taskMonitorAdapter = this;
        synchronized (taskMonitorAdapter) {
            if (!this.cancelled) {
                return;
            }
            this.cancelled = false;
        }
        this.notifyChangeListeners();
    }

    public void incrementProgress(long incrementAmount) {
    }

    public long getProgress() {
        return -1L;
    }

    protected synchronized void notifyChangeListeners() {
        for (CancelledListener listener : this.listeners) {
            listener.cancelled();
        }
    }

    public synchronized void addCancelledListener(CancelledListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeCancelledListener(CancelledListener listener) {
        this.listeners.remove(listener);
    }
}

