/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng;

import agent.dbgeng.model.impl.DbgModelImpl;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@ConfigurableFactory.FactoryDescription(brief="MS dbgeng.dll (WinDbg)", htmlDetails="Connect to the Microsoft Debug Engine.\nThis is the same engine that powers WinDbg.\nThis is best for most Windows userspace and kernel targets.\nKernel debugging is still experimental.\nThis will access the native API, which may put Ghidra's JVM at risk.")
public class DbgEngInJvmDebuggerModelFactory
implements DebuggerModelFactory {
    protected String remote = "none";
    @ConfigurableFactory.FactoryOption(value="DebugConnect options (.server)")
    public final ConfigurableFactory.Property<String> agentRemoteOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentRemote, this::setAgentRemote);
    protected String transport = "none";
    @ConfigurableFactory.FactoryOption(value="Remote process server options (untested)")
    public final ConfigurableFactory.Property<String> agentTransportOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentTransport, this::setAgentTransport);

    public CompletableFuture<? extends DebuggerObjectModel> build() {
        DbgModelImpl model = new DbgModelImpl();
        ArrayList<String> cmds = new ArrayList<String>();
        this.completeCommandLine(cmds);
        return model.startDbgEng(cmds.toArray(new String[cmds.size()])).thenApply(__ -> model);
    }

    public int getPriority(Program program) {
        String exe;
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 80;
    }

    public String getAgentTransport() {
        return this.transport;
    }

    public void setAgentTransport(String transport) {
        this.transport = transport;
    }

    public String getAgentRemote() {
        return this.remote;
    }

    public void setAgentRemote(String remote) {
        this.remote = remote;
    }

    protected void completeCommandLine(List<String> cmd) {
        if (!this.remote.equals("none") && !this.remote.equals("")) {
            cmd.addAll(List.of(this.remote));
        }
        if (!this.transport.equals("none") && !this.transport.equals("")) {
            cmd.addAll(List.of(this.transport));
        }
    }
}

