/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgStateListener;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DbgModelTargetObjectImpl
extends DefaultTargetObject<TargetObject, TargetObject>
implements DbgModelTargetObject {
    protected boolean accessible = true;
    protected final DbgStateListener accessListener = this::checkExited;
    private boolean modified;

    public DbgModelTargetObjectImpl(AbstractDbgModel impl, TargetObject parent, String name, String typeHint) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint);
        this.getManager().addStateListener(this.accessListener);
    }

    public DbgModelTargetObjectImpl(AbstractDbgModel impl, TargetObject parent, String name, String typeHint, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)impl, parent, name, typeHint, schema);
        this.getManager().addStateListener(this.accessListener);
    }

    public void setAttribute(String key, String value) {
        this.changeAttributes(List.of(), List.of(), Map.of(key, value), "Initialized");
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        super.doInvalidate(branch, reason);
        this.getManager().removeStateListener(this.accessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessible(boolean accessible) {
        Map map = this.attributes;
        synchronized (map) {
            if (this.accessible == accessible) {
                return;
            }
            this.accessible = accessible;
        }
        if (this instanceof DbgModelTargetAccessConditioned) {
            this.changeAttributes(List.of(), List.of(), Map.of("_accessible", accessible), "Accessibility changed");
        }
    }

    @Override
    public AbstractDbgModel getModel() {
        return (AbstractDbgModel)this.model;
    }

    public void onRunning() {
        this.setAccessible(false);
    }

    public void onStopped() {
        this.setAccessible(true);
    }

    public void onExit() {
        this.setAccessible(true);
    }

    protected void checkExited(DbgState state, DbgCause cause) {
        TargetExecutionStateful.TargetExecutionState exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
        switch (state) {
            case NOT_STARTED: {
                exec = TargetExecutionStateful.TargetExecutionState.INACTIVE;
                break;
            }
            case STARTING: {
                exec = TargetExecutionStateful.TargetExecutionState.ALIVE;
                break;
            }
            case RUNNING: {
                exec = TargetExecutionStateful.TargetExecutionState.RUNNING;
                this.resetModified();
                this.onRunning();
                break;
            }
            case STOPPED: {
                exec = TargetExecutionStateful.TargetExecutionState.STOPPED;
                this.onStopped();
                break;
            }
            case EXIT: {
                exec = TargetExecutionStateful.TargetExecutionState.TERMINATED;
                if (this.getParentProcess() != null || this instanceof TargetProcess) {
                    this.getManager().removeStateListener(this.accessListener);
                }
                this.onExit();
                break;
            }
            case SESSION_EXIT: {
                this.getModel().close();
                return;
            }
        }
        SpiTargetObject spiTargetObject = this.proxy;
        if (spiTargetObject instanceof DbgModelTargetExecutionStateful) {
            DbgModelTargetExecutionStateful stateful = (DbgModelTargetExecutionStateful)spiTargetObject;
            if (this.proxy instanceof DbgModelTargetSession) {
                if (state != DbgState.EXIT) {
                    stateful.setExecutionState(exec, "Refreshed");
                }
            } else {
                TargetExecutionStateful.TargetExecutionState previous = stateful.getExecutionState();
                if (!previous.equals((Object)TargetExecutionStateful.TargetExecutionState.INACTIVE)) {
                    stateful.setExecutionState(exec, "Refreshed");
                }
            }
        }
    }

    @Override
    public CompletableFuture<? extends Map<String, ?>> requestNativeAttributes() {
        throw new AssertionError();
    }

    @Override
    public CompletableFuture<List<TargetObject>> requestNativeElements() {
        throw new AssertionError();
    }

    @Override
    public DbgModelTargetSession getParentSession() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test instanceof DbgModelTargetSession); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetSession)test;
    }

    @Override
    public DbgModelTargetProcess getParentProcess() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test instanceof TargetProcess); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetProcess)test;
    }

    @Override
    public DbgModelTargetThread getParentThread() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test instanceof TargetThread); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetThread)test;
    }

    @Override
    public void setModified(Map<String, Object> map, boolean b) {
        if (this.modified) {
            map.put("_modified", this.modified);
        }
    }

    @Override
    public void setModified(boolean modified) {
        if (modified) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", modified), "Refreshed");
        }
    }

    @Override
    public void resetModified() {
        this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
    }

    public TargetObject searchForSuitable(Class<? extends TargetObject> type) {
        List pathToClass = this.model.getRootSchema().searchForSuitable(type, this.path);
        return this.model.getModelObject(pathToClass);
    }
}

