/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.log;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.rzo.yajsw.log.MyFileHandler;
import org.rzo.yajsw.log.PatternFormatter;

public class DateFileHandler
extends Handler {
    volatile MyFileHandler _handler;
    volatile long _endDate;
    volatile String _pattern;
    volatile int _limit;
    volatile int _count;
    volatile boolean _append;
    final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    volatile boolean _init = false;
    volatile boolean _rollDate = false;
    volatile long _startDate = System.currentTimeMillis();
    volatile LinkedList<String> _previousDates = new LinkedList();
    volatile String _currentDate = null;
    volatile int _maxDays = -1;
    volatile boolean _desc = false;
    volatile int _umask = -1;
    volatile boolean _compress;

    public DateFileHandler(String pattern, int limit, int count, boolean append, boolean rollDate, PatternFormatter fileFormatter, Level logLevel, String encoding, int maxDays, boolean desc, int umask, boolean compress) {
        this._umask = umask;
        this._desc = desc;
        this._pattern = pattern;
        this._limit = limit;
        this._count = count;
        this._append = append;
        this._rollDate = rollDate;
        this._maxDays = maxDays;
        this._compress = compress;
        this._init = true;
        if (encoding != null) {
            try {
                this.setEncoding(encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setFormatter(fileFormatter);
        this.setLevel(logLevel);
        this.findPreviousDates();
        this.rotateDate();
    }

    @Override
    public void close() throws SecurityException {
        this._handler.close();
    }

    @Override
    public void flush() {
        this._handler.flush();
    }

    @Override
    public void publish(LogRecord record) {
        if (this._rollDate) {
            if (this._endDate < record.getMillis()) {
                this.rotateDate();
            }
            if (System.currentTimeMillis() - this._startDate > 90000000L) {
                String msg = record.getMessage();
                record.setMessage("missed file rolling at: " + new Date(this._endDate) + "\n" + msg);
            }
        }
        this._handler.publish(record);
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        super.setFormatter(newFormatter);
        if (this._handler != null) {
            this._handler.setFormatter(newFormatter);
        }
    }

    private void rotateDate() {
        this._startDate = System.currentTimeMillis();
        if (this._handler != null) {
            this._handler.close();
        }
        if (this._currentDate != null) {
            this._previousDates.addLast(this._currentDate);
        }
        this.cleanupDates();
        this._currentDate = this.format.format(new Date());
        String pattern = this._pattern.replace("%d", this._currentDate);
        try {
            File dd = new File(MyFileHandler.parseFileName(pattern, 0, 0, this._count, false));
            if (!dd.getParentFile().exists()) {
                dd.getParentFile().mkdirs();
            }
        }
        catch (Exception dd) {
            // empty catch block
        }
        Calendar next = Calendar.getInstance();
        next.set(11, 0);
        next.set(12, 0);
        next.set(13, 0);
        next.set(14, 0);
        next.add(5, 1);
        this._endDate = next.getTimeInMillis();
        try {
            this._handler = new MyFileHandler(pattern, this._limit, this._count, this._append, this._desc, this._umask, this._compress);
            if (this._init) {
                this._handler.setEncoding(this.getEncoding());
                this._handler.setErrorManager(this.getErrorManager());
                this._handler.setFilter(this.getFilter());
                this._handler.setFormatter(this.getFormatter());
                this._handler.setLevel(this.getLevel());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void cleanupDates() {
        if (this._maxDays >= 0) {
            while (this._previousDates.size() > this._maxDays) {
                String toCleanup = this._previousDates.removeFirst();
                this.cleanupDate(toCleanup);
            }
        }
    }

    private void cleanupDate(String date) {
        File f;
        String pattern = this._pattern.replace("%d", date);
        block6: for (int unique = 0; unique < this._count; ++unique) {
            try {
                f = new File(MyFileHandler.parseFileName(pattern, 0, unique, this._count, false));
                if (!f.exists()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int generation = 0; generation < this._count; ++generation) {
                try {
                    f = new File(MyFileHandler.parseFileName(pattern, generation, unique, this._count, false));
                    if (!f.exists()) continue block6;
                    f.delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            f = new File(MyFileHandler.parseFileName(pattern + ".lck", 0, 0, this._count, false));
            f.delete();
            f = new File(MyFileHandler.parseFileName(pattern, 0, 0, this._count, false));
            while (!f.getName().contains(date)) {
                f = f.getParentFile();
            }
            if (f.isDirectory()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void findPreviousDates() {
        if (this._maxDays < 0) {
            return;
        }
        Calendar date = Calendar.getInstance();
        int scanDays = Math.max(365, this._maxDays);
        for (int i = 0; i < scanDays; ++i) {
            date.add(5, -1);
            String cDate = this.format.format(date.getTime());
            String pattern = this._pattern.replace("%d", cDate);
            boolean dateFound = false;
            try {
                File f = new File(MyFileHandler.parseFileName(pattern, 0, 0, this._count, false));
                if (f.exists()) {
                    dateFound = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!dateFound) continue;
            this._previousDates.addFirst(cDate);
        }
    }
}

