/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import generic.theme.GThemeDefaults;
import generic.util.image.ImageUtils;
import ghidra.graph.visualization.GraphRenderer;
import ghidra.graph.visualization.GroupVertex;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.DefaultGraphDisplayOptions;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphLabelPosition;
import ghidra.service.graph.VertexShape;
import ghidra.util.HTMLUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.decorators.EllipseShapeFunction;
import org.jungrapht.visualization.decorators.IconShapeFunction;
import org.jungrapht.visualization.layout.algorithms.util.InitialDimensionFunction;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.renderers.BiModalRenderer;
import org.jungrapht.visualization.renderers.JLabelVertexLabelRenderer;
import org.jungrapht.visualization.renderers.LightweightVertexRenderer;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.renderers.VertexLabelRenderer;
import org.jungrapht.visualization.util.RectangleUtils;

public class DefaultGraphRenderer
implements GraphRenderer {
    private static final double ARROW_WIDTH_TO_LENGTH_RATIO = 1.3;
    private static final int DEFAULT_MARGIN_BORDER_SIZE = 4;
    private static final int DEFAULT_STROKE_THICKNESS = 6;
    private static final int ICON_ZOOM = 2;
    private static final int MAX_WIDTH = 500;
    private static final int MAX_HEIGHT = 500;
    private int labelBorderSize = 4;
    private int strokeThickness = 6;
    private JLabel label;
    private GraphDisplayOptions options;
    private final Map<AttributedVertex, Icon> iconCache = new ConcurrentHashMap<AttributedVertex, Icon>();
    private final Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    private Stroke edgeStroke = new BasicStroke(4.0f);

    public DefaultGraphRenderer() {
        this((GraphDisplayOptions)new DefaultGraphDisplayOptions());
    }

    public DefaultGraphRenderer(GraphDisplayOptions options) {
        this.options = options;
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.label = new JLabel();
        this.label.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        this.label.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.label.setOpaque(false);
        Border marginBorder = BorderFactory.createEmptyBorder(this.labelBorderSize, 2 * this.labelBorderSize, this.labelBorderSize, 2 * this.labelBorderSize);
        this.label.setBorder(marginBorder);
    }

    @Override
    public void setGraphTypeDisplayOptions(GraphDisplayOptions options) {
        this.options = options;
        this.clearCache();
    }

    @Override
    public GraphDisplayOptions getGraphDisplayOptions() {
        return this.options;
    }

    @Override
    public void clearCache() {
        this.iconCache.clear();
    }

    private String getVertexRenderedLabel(AttributedVertex v) {
        return HTMLUtilities.toLiteralHTML((String)v.toString(), (int)80);
    }

    @Override
    public void initializeViewer(VisualizationViewer<AttributedVertex, AttributedEdge> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        Function<Shape, Rectangle> toRectangle = s -> RectangleUtils.convert((Rectangle2D)s.getBounds2D());
        if (this.options.usesIcons()) {
            IconShapeFunction nodeShaper = new IconShapeFunction((Function)new EllipseShapeFunction());
            nodeShaper.setIconFunction(this::getIcon);
            renderContext.setVertexShapeFunction((Function)nodeShaper);
            renderContext.setVertexIconFunction(this::getIcon);
            int arrowLength = this.options.getArrowLength() * 2;
            int arrowWidth = (int)((double)arrowLength * 1.3);
            renderContext.setEdgeArrowWidth(arrowWidth);
            renderContext.setEdgeArrowLength(arrowLength);
            renderContext.setVertexLabelFunction(v -> "");
            viewer.setInitialDimensionFunction((Function)InitialDimensionFunction.builder((Function)nodeShaper.andThen(toRectangle)).build());
        } else {
            int arrowLength = this.options.getArrowLength();
            int arrowWidth = (int)((double)arrowLength * 1.3);
            renderContext.setEdgeArrowWidth(arrowWidth);
            renderContext.setEdgeArrowLength(arrowLength);
            renderContext.setVertexIconFunction(null);
            renderContext.setVertexShapeFunction(this::getVertexShape);
            viewer.setInitialDimensionFunction((Function)InitialDimensionFunction.builder(renderContext.getVertexShapeFunction().andThen(toRectangle)).build());
            renderContext.setVertexLabelFunction(this::getVertexRenderedLabel);
            GraphLabelPosition labelPosition = this.options.getLabelPosition();
            renderContext.setVertexLabelPosition(this.getJungraphTPosition(labelPosition));
        }
        ModalRenderer modalRenderer = viewer.getRenderer();
        Renderer.Vertex lightWeightRenderer = modalRenderer.getVertexRenderer(BiModalRenderer.LIGHTWEIGHT);
        if (lightWeightRenderer instanceof LightweightVertexRenderer) {
            LightweightVertexRenderer lightweightVertexRenderer = (LightweightVertexRenderer)lightWeightRenderer;
            Function vertexShapeFunction = renderContext.getVertexShapeFunction();
            lightweightVertexRenderer.setVertexShapeFunction(vertexShapeFunction);
        }
        renderContext.setVertexFontFunction(this::getFont);
        renderContext.setVertexLabelRenderer((VertexLabelRenderer)new JLabelVertexLabelRenderer((Color)GThemeDefaults.Colors.FOREGROUND));
        renderContext.setVertexDrawPaintFunction(this::getVertexColor);
        renderContext.setVertexFillPaintFunction(this::getVertexColor);
        renderContext.setVertexStrokeFunction(n -> new BasicStroke(3.0f));
        renderContext.setEdgeStrokeFunction(this::getEdgeStroke);
        renderContext.setEdgeDrawPaintFunction(this::getEdgeColor);
        renderContext.setArrowDrawPaintFunction(this::getEdgeColor);
        renderContext.setArrowFillPaintFunction(this::getEdgeColor);
        renderContext.setEdgeShapeFunction((BiFunction)EdgeShape.line());
    }

    private Shape getVertexShape(AttributedVertex vertex) {
        if (vertex instanceof GroupVertex) {
            return VertexShape.STAR.getShape();
        }
        VertexShape vertexShape = this.options.getVertexShape(vertex);
        return vertexShape != null ? vertexShape.getShape() : VertexShape.RECTANGLE.getShape();
    }

    private Renderer.VertexLabel.Position getJungraphTPosition(GraphLabelPosition labelPosition) {
        switch (labelPosition) {
            case CENTER: {
                return Renderer.VertexLabel.Position.CNTR;
            }
            case EAST: {
                return Renderer.VertexLabel.Position.E;
            }
            case NORTH: {
                return Renderer.VertexLabel.Position.N;
            }
            case NORTHEAST: {
                return Renderer.VertexLabel.Position.NE;
            }
            case NORTHWEST: {
                return Renderer.VertexLabel.Position.NW;
            }
            case SOUTH: {
                return Renderer.VertexLabel.Position.S;
            }
            case SOUTHEAST: {
                return Renderer.VertexLabel.Position.SE;
            }
            case SOUTHWEST: {
                return Renderer.VertexLabel.Position.SW;
            }
            case WEST: {
                return Renderer.VertexLabel.Position.W;
            }
        }
        return Renderer.VertexLabel.Position.AUTO;
    }

    private Color getVertexColor(AttributedVertex vertex) {
        return this.options.getVertexColor(vertex);
    }

    private Color getEdgeColor(AttributedEdge edge) {
        return this.options.getEdgeColor(edge);
    }

    private Icon getIcon(AttributedVertex vertex) {
        Icon icon = this.iconCache.get(vertex);
        if (icon == null) {
            icon = this.createIcon(vertex);
            this.iconCache.put(vertex, icon);
        }
        return icon;
    }

    private Icon createIcon(AttributedVertex vertex) {
        VertexShape vertexShape = this.options.getVertexShape(vertex);
        Color vertexColor = this.options.getVertexColor(vertex);
        String labelText = this.options.getVertexLabel(vertex);
        return this.createImage(vertexShape, labelText, vertexColor);
    }

    @Override
    public void vertexChanged(AttributedVertex vertex) {
        this.iconCache.remove(vertex);
    }

    private ImageIcon createImage(VertexShape vertexShape, String vertexName, Color vertexColor) {
        this.prepareLabel(vertexName, vertexColor);
        Shape unitShape = vertexShape.getShape();
        java.awt.Rectangle bounds = unitShape.getBounds();
        int maxWidthToHeightRatio = vertexShape.getMaxWidthToHeightRatio();
        double sizeFactor = vertexShape.getShapeToLabelRatio();
        int labelWidth = this.label.getWidth();
        int labelHeight = this.label.getHeight();
        labelHeight = Math.max(labelHeight, labelWidth / maxWidthToHeightRatio);
        int shapeWidth = (int)((double)labelWidth * sizeFactor);
        int shapeHeight = (int)((double)labelHeight * sizeFactor);
        double scalex = (double)shapeWidth / bounds.getWidth();
        double scaley = (double)shapeHeight / bounds.getHeight();
        Shape scaledShape = AffineTransform.getScaleInstance(scalex, scaley).createTransformedShape(unitShape);
        double labelOffsetRatio = vertexShape.getLabelPosition();
        bounds = scaledShape.getBounds();
        int iconWidth = bounds.width + 2 * this.strokeThickness;
        int iconHeight = bounds.height + 2 * this.strokeThickness;
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight, 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setRenderingHints(this.renderingHints);
        AffineTransform graphicsTransform = graphics.getTransform();
        graphics.translate(-bounds.x + this.strokeThickness, -bounds.y + this.strokeThickness);
        graphics.setPaint((Paint)GThemeDefaults.Colors.BACKGROUND);
        graphics.fill(scaledShape);
        graphics.setPaint(vertexColor);
        graphics.setStroke(new BasicStroke(this.strokeThickness));
        graphics.draw(scaledShape);
        graphics.setTransform(graphicsTransform);
        int xOffset = (iconWidth - this.label.getWidth()) / 2;
        int yOffset = (int)((double)(iconHeight - this.label.getHeight()) * labelOffsetRatio);
        graphics.translate(xOffset, yOffset);
        graphics.setPaint((Paint)GThemeDefaults.Colors.FOREGROUND);
        this.label.paint(graphics);
        graphics.setTransform(graphicsTransform);
        graphics.dispose();
        Image scaledImage = ImageUtils.createScaledImage((Image)bufferedImage, (int)(iconWidth * 2), (int)(iconHeight * 2), (int)2);
        ImageIcon imageIcon = new ImageIcon(scaledImage);
        return imageIcon;
    }

    private void prepareLabel(String vertexName, Color vertexColor) {
        Font font = this.options.getFont();
        this.label.setFont(font);
        String escapedText = HTMLUtilities.toLiteralHTML((String)vertexName, (int)80);
        this.label.setText(escapedText);
        Dimension labelSize = this.label.getPreferredSize();
        int width = Math.min(labelSize.width, 500);
        int height = Math.min(labelSize.height, 500);
        this.label.setSize(width, height);
    }

    @Override
    public String getFavoredEdgeType() {
        return this.options.getFavoredEdgeType();
    }

    @Override
    public Integer getEdgePriority(String edgeType) {
        return this.options.getEdgePriority(edgeType);
    }

    private Stroke getEdgeStroke(AttributedEdge edge) {
        return this.edgeStroke;
    }

    @Override
    public Color getVertexSelectionColor() {
        return this.options.getVertexSelectionColor();
    }

    @Override
    public Color getEdgeSelectionColor() {
        return this.options.getEdgeSelectionColor();
    }

    private Font getFont(AttributedVertex attributedvertex1) {
        return this.options.getFont();
    }
}

