/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Value;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetValue;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="TargetValueContainer", elements={@TargetElementType(type=JdiModelTargetValue.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetValueContainer
extends JdiModelTargetObjectImpl {
    private List<Value> values;
    protected final Map<String, JdiModelTargetValue> valuesByName = new HashMap<String, JdiModelTargetValue>();

    public JdiModelTargetValueContainer(JdiModelTargetObject parent, String name, List<Value> vals) {
        super(parent, name);
        this.values = vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingValues(Map<String, Value> byName) {
        List vals;
        JdiModelTargetValueContainer jdiModelTargetValueContainer = this;
        synchronized (jdiModelTargetValueContainer) {
            vals = byName.values().stream().map(this::getTargetValue).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetValue val : vals) {
            fence.include(val.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), vals, Map.of(), "Refreshed"));
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        try {
            for (Value val : this.values) {
                map.put(val.toString(), val);
            }
            this.valuesByName.keySet().retainAll(map.keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateUsingValues(map);
    }

    protected synchronized JdiModelTargetValue getTargetValue(Value val) {
        return this.valuesByName.computeIfAbsent(val.toString(), n -> new JdiModelTargetValue(this, val, true));
    }

    public synchronized JdiModelTargetValue getTargetValueIfPresent(String name) {
        return this.valuesByName.get(name);
    }
}

