/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr.match;

import ghidra.app.plugin.assembler.sleigh.expr.match.ExpressionMatcher;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.EndInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.Next2InstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.StartInstructionValue;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.expression.UnaryExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExpressionMatcher<T extends PatternExpression>
implements ExpressionMatcher<T> {
    protected final Set<Class<? extends T>> ops;

    public AbstractExpressionMatcher(Set<Class<? extends T>> ops) {
        this.ops = Set.copyOf(ops);
    }

    public AbstractExpressionMatcher(Class<? extends T> cls) {
        this.ops = Set.of(cls);
    }

    protected T opMatches(PatternExpression expression) {
        return (T)((PatternExpression)this.ops.stream().filter(op -> op.isInstance(expression)).map(op -> (PatternExpression)op.cast(expression)).findAny().orElse(null));
    }

    protected abstract boolean matchDetails(T var1, Map<ExpressionMatcher<?>, PatternExpression> var2);

    @Override
    public boolean match(PatternExpression expression, Map<ExpressionMatcher<?>, PatternExpression> result) {
        T t = this.opMatches(expression);
        if (t == null) {
            return false;
        }
        if (!this.matchDetails(t, result)) {
            return false;
        }
        return this.recordResult((PatternExpression)t, result);
    }

    protected boolean recordResult(PatternExpression expression, Map<ExpressionMatcher<?>, PatternExpression> result) {
        PatternExpression already = result.put(this, expression);
        if (already == null) {
            return true;
        }
        return AbstractExpressionMatcher.expressionsIdenticallyDefined(already, expression);
    }

    protected static boolean expressionsIdenticallyDefined(PatternExpression a, PatternExpression b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof EndInstructionValue) {
            return true;
        }
        if (a instanceof Next2InstructionValue) {
            return true;
        }
        if (a instanceof StartInstructionValue) {
            return true;
        }
        if (a instanceof ConstantValue) {
            ConstantValue ca = (ConstantValue)a;
            ConstantValue cb = (ConstantValue)b;
            return ca.getValue() == cb.getValue();
        }
        if (a instanceof UnaryExpression) {
            UnaryExpression ua = (UnaryExpression)a;
            UnaryExpression ub = (UnaryExpression)b;
            return AbstractExpressionMatcher.expressionsIdenticallyDefined(ua.getUnary(), ub.getUnary());
        }
        if (a instanceof BinaryExpression) {
            BinaryExpression ba = (BinaryExpression)a;
            BinaryExpression bb = (BinaryExpression)b;
            return AbstractExpressionMatcher.expressionsIdenticallyDefined(ba.getLeft(), bb.getLeft()) && AbstractExpressionMatcher.expressionsIdenticallyDefined(ba.getRight(), bb.getRight());
        }
        if (a instanceof TokenField) {
            TokenField ta = (TokenField)a;
            TokenField tb = (TokenField)b;
            return ta.getBitStart() == tb.getBitStart() && ta.getBitEnd() == tb.getBitEnd() && ta.hasSignbit() == tb.hasSignbit();
        }
        if (a instanceof ContextField) {
            ContextField ca = (ContextField)a;
            ContextField cb = (ContextField)b;
            return ca.getStartBit() == cb.getStartBit() && ca.getEndBit() == cb.getEndBit() && ca.hasSignbit() == cb.hasSignbit();
        }
        if (a instanceof OperandValue) {
            OperandValue va = (OperandValue)a;
            OperandValue vb = (OperandValue)b;
            return va.getConstructor() == vb.getConstructor() && va.getIndex() == vb.getIndex();
        }
        throw new AssertionError();
    }
}

