/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyState;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class AssemblyOperandState
extends AbstractAssemblyState {
    protected final AssemblyTerminal terminal;
    protected final long value;
    protected final OperandSymbol opSym;

    public AssemblyOperandState(AssemblyTreeResolver resolver, List<AssemblyConstructorSemantic> path, int shift, AssemblyTerminal terminal, long value, OperandSymbol opSym) {
        super(resolver, path, shift, opSym.getMinimumLength());
        this.terminal = terminal;
        this.value = value;
        this.opSym = opSym;
    }

    @Override
    public int computeHash() {
        return Objects.hash(this.getClass(), this.shift, this.value, this.opSym);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssemblyOperandState)) {
            return false;
        }
        AssemblyOperandState that = (AssemblyOperandState)obj;
        if (this.resolver != that.resolver) {
            return false;
        }
        if (this.shift != that.shift) {
            return false;
        }
        if (this.value != that.value) {
            return false;
        }
        return Objects.equals(this.opSym, that.opSym);
    }

    public String toString() {
        return this.terminal + "=" + this.value + "(0x" + Long.toHexString(this.value) + ")";
    }

    protected int computeBitsize() {
        if (!(this.terminal instanceof AssemblyNumericTerminal)) {
            return 0;
        }
        AssemblyNumericTerminal numeric = (AssemblyNumericTerminal)this.terminal;
        return numeric.getBitSize();
    }

    protected AssemblyResolution solveNumeric() {
        int bitsize = this.computeBitsize();
        PatternExpression symExp = this.opSym.getDefiningExpression();
        if (symExp == null) {
            symExp = this.opSym.getDefiningSymbol().getPatternExpression();
        }
        DBG.println("Equation: " + symExp + " = " + Long.toHexString(this.value));
        String desc = "Solution to " + this.opSym + " in " + Long.toHexString(this.value) + " = " + symExp;
        AssemblyResolution sol = AssemblyTreeResolver.solveOrBackfill(symExp, this.value, bitsize, this.resolver.vals, null, desc);
        DBG.println("Solution: " + sol);
        AssemblyResolution shifted = sol.shift(this.shift);
        DBG.println("Shifted: " + shifted);
        return shifted;
    }

    @Override
    protected Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors) {
        try (DbgTimer.DbgCtx dc = DBG.start("Resolving " + this.terminal);){
            AssemblyResolution sol = this.solveNumeric();
            if (sol.isError()) {
                errors.add((AssemblyResolvedError)sol);
                Stream<AssemblyResolvedPatterns> stream = Stream.of(new AssemblyResolvedPatterns[0]);
                return stream;
            }
            if (sol.isBackfill()) {
                AssemblyResolvedPatterns combined = fromRight.combine((AssemblyResolvedBackfill)sol);
                Stream<AssemblyResolvedPatterns> stream = Stream.of(combined.withRight(fromRight));
                return stream;
            }
            AssemblyResolvedPatterns combined = fromRight.combine((AssemblyResolvedPatterns)sol);
            if (combined == null) {
                errors.add(AssemblyResolution.error("Pattern/operand conflict", "Resolving " + this.terminal));
                Stream<AssemblyResolvedPatterns> stream = Stream.of(new AssemblyResolvedPatterns[0]);
                return stream;
            }
            AssemblyResolvedPatterns pats = combined;
            Stream<AssemblyResolvedPatterns> stream = Stream.of(pats.withRight(fromRight).withConstructor(null));
            return stream;
        }
    }
}

