/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HandleTpl {
    private ConstTpl space;
    private ConstTpl size;
    private ConstTpl ptrspace;
    private ConstTpl ptroffset;
    private ConstTpl ptrsize;
    private ConstTpl temp_space;
    private ConstTpl temp_offset;

    protected HandleTpl() {
    }

    public HandleTpl(ConstTpl spc, ConstTpl sz, ConstTpl ptrspc, ConstTpl ptroff, ConstTpl ptrsz, ConstTpl tmpspc, ConstTpl tmpoff) {
        this.space = spc;
        this.size = sz;
        this.ptrspace = ptrspc;
        this.ptroffset = ptroff;
        this.ptrsize = ptrsz;
        this.temp_space = tmpspc;
        this.temp_offset = tmpoff;
    }

    public void fix(FixedHandle hand, ParserWalker walker) {
        if (this.ptrspace.getType() == 0) {
            this.space.fillinSpace(hand, walker);
            hand.size = (int)this.size.fix(walker);
            this.ptroffset.fillinOffset(hand, walker);
        } else {
            hand.space = this.space.fixSpace(walker);
            hand.size = (int)this.size.fix(walker);
            hand.offset_offset = this.ptroffset.fix(walker);
            hand.offset_space = this.ptrspace.fixSpace(walker);
            if (hand.offset_space.getType() == 0) {
                hand.offset_space = null;
                hand.offset_offset *= (long)hand.space.getAddressableUnitSize();
                hand.offset_offset = hand.space.truncateOffset(hand.offset_offset);
            } else {
                hand.offset_size = (int)this.ptrsize.fix(walker);
                hand.temp_space = this.temp_space.fixSpace(walker);
                hand.temp_offset = this.temp_offset.fix(walker);
            }
        }
    }

    public void fixPrintPiece(FixedHandle hand, ParserWalker walker, int handleIndex) {
        if (!hand.fixable) {
            return;
        }
        if (hand.space.getType() != 0) {
            hand.fixable = false;
            return;
        }
        if (this.space.getType() == 7 && this.space.isUniqueSpace()) {
            hand.fixable = false;
            return;
        }
        if (this.ptroffset.getType() == 1 && this.ptroffset.getHandleIndex() == handleIndex) {
            hand.space = this.space.fixSpace(walker);
            hand.offset_offset = (long)hand.space.getAddressableUnitSize() * hand.offset_offset;
            hand.size = (int)this.size.fix(walker);
        } else {
            hand.fixable = false;
        }
    }

    public void restoreXml(XmlPullParser parser, AddressFactory factory) {
        XmlElement el = parser.start(new String[]{"handle_tpl"});
        this.space = new ConstTpl();
        this.space.restoreXml(parser, factory);
        this.size = new ConstTpl();
        this.size.restoreXml(parser, factory);
        this.ptrspace = new ConstTpl();
        this.ptrspace.restoreXml(parser, factory);
        this.ptroffset = new ConstTpl();
        this.ptroffset.restoreXml(parser, factory);
        this.ptrsize = new ConstTpl();
        this.ptrsize.restoreXml(parser, factory);
        this.temp_space = new ConstTpl();
        this.temp_space.restoreXml(parser, factory);
        this.temp_offset = new ConstTpl();
        this.temp_offset.restoreXml(parser, factory);
        parser.end(el);
    }

    public int getOffsetOperandIndex() {
        return this.ptroffset.getHandleIndex();
    }

    public int getSize() {
        if (this.space.isConstSpace()) {
            return (int)this.size.getReal() * 8;
        }
        if (this.space.getSpaceId() == null) {
            return 0;
        }
        return this.space.getSpaceId().getSize();
    }

    public AddressSpace getAddressSpace() {
        return this.space.getSpaceId();
    }
}

