/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.OperandValue;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class ContextOp
extends ContextChange {
    public final Location location;
    private PatternExpression patexp;
    private int num;
    private int mask;
    private int shift;

    public ContextOp(Location location) {
        this.location = location;
    }

    @Override
    public void dispose() {
        PatternExpression.release(this.patexp);
    }

    public ContextOp(Location location, int startbit, int endbit, PatternExpression pe) {
        this.location = location;
        MutableInt n = new MutableInt();
        MutableInt s = new MutableInt();
        MutableInt m = new MutableInt();
        Utils.calc_maskword(location, startbit, endbit, n, s, m);
        this.num = n.get();
        this.shift = s.get();
        this.mask = m.get();
        this.patexp = pe;
        this.patexp.layClaim();
    }

    @Override
    public void validate() {
        VectorSTL values = new VectorSTL();
        this.patexp.listValues((VectorSTL<PatternValue>)values);
        for (int i = 0; i < values.size(); ++i) {
            OperandValue val;
            if (!(values.get(i) instanceof OperandValue) || (val = (OperandValue)values.get(i)).isConstructorRelative()) continue;
            throw new SleighError(val.getName() + ": cannot be used in context expression", val.location);
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<context_op");
        s.append(" i=\"");
        s.print(this.num);
        s.append("\"");
        s.append(" shift=\"");
        s.print(this.shift);
        s.append("\"");
        s.append(" mask=\"0x");
        s.append(Utils.toUnsignedIntHex(this.mask));
        s.append("\" >\n");
        this.patexp.saveXml(s);
        s.append("</context_op>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.num = XmlUtils.decodeUnknownInt(el.getAttributeValue("i"));
        this.shift = XmlUtils.decodeUnknownInt(el.getAttributeValue("shift"));
        this.mask = XmlUtils.decodeUnknownInt(el.getAttributeValue("mask"));
        Element child = (Element)el.getChildren().get(0);
        this.patexp = PatternExpression.restoreExpression(child, trans);
        this.patexp.layClaim();
    }
}

