/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.DuplicateNameException;

public class ProgramAddressFactory
extends DefaultAddressFactory {
    private AddressFactory originalFactory;
    private AddressSpace stackSpace;

    public ProgramAddressFactory(Language language, CompilerSpec compilerSpec) {
        super(language.getAddressFactory().getAllAddressSpaces(), language.getAddressFactory().getDefaultAddressSpace());
        this.originalFactory = language.getAddressFactory();
        this.initOtherSpace(language);
        this.initExternalSpace(language);
        this.initStackSpace(language, compilerSpec);
        this.initHashSpace(language);
        this.initJoinSpace(language);
    }

    private void initOtherSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.OTHER_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'OTHER' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initExternalSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.EXTERNAL_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'EXTERNAL' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initStackSpace(Language language, CompilerSpec compilerSpec) {
        this.stackSpace = compilerSpec.getStackSpace();
        try {
            this.addAddressSpace(this.stackSpace);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'STACK' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initHashSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.HASH_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'HASH' space: " + language.getLanguageID().getIdAsString());
        }
    }

    private void initJoinSpace(Language language) {
        try {
            this.addAddressSpace(AddressSpace.VARIABLE_SPACE);
        }
        catch (DuplicateNameException e) {
            throw new IllegalStateException("Language must not define 'JOIN' space: " + language.getLanguageID().getIdAsString());
        }
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.stackSpace;
    }

    AddressFactory getOriginalAddressFactory() {
        return this.originalFactory;
    }

    protected void addOverlayAddressSpace(OverlayAddressSpace ovSpace) throws DuplicateNameException {
        this.addAddressSpace(ovSpace);
    }

    protected boolean validateOriginalSpace(AddressSpace originalSpace) {
        return originalSpace.isMemorySpace() && !originalSpace.isOverlaySpace();
    }

    protected OverlayAddressSpace addOverlayAddressSpace(String name, boolean preserveName, AddressSpace originalSpace, long minOffset, long maxOffset) {
        if (!this.validateOriginalSpace(originalSpace)) {
            throw new IllegalArgumentException("Invalid address space for overlay: " + originalSpace.getName());
        }
        AddressSpace space = this.getAddressSpace(originalSpace.getName());
        if (space != originalSpace) {
            throw new IllegalArgumentException("Unknown memory address space instance");
        }
        String spaceName = name;
        if (!preserveName) {
            spaceName = this.fixupOverlaySpaceName(name);
            spaceName = this.getUniqueOverlayName(spaceName);
        } else if (this.getAddressSpace(name) != null) {
            throw new IllegalArgumentException("Space named " + name + " already exists!");
        }
        int unique = 0;
        if (originalSpace.getType() == 1 || originalSpace.getType() == 7) {
            unique = this.getNextUniqueID();
        }
        OverlayAddressSpace ovSpace = new OverlayAddressSpace(spaceName, originalSpace, unique, minOffset, maxOffset);
        try {
            this.addAddressSpace(ovSpace);
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException(e);
        }
        return ovSpace;
    }

    private String getUniqueOverlayName(String baseOverlayName) {
        String revisedName;
        if (this.getAddressSpace(baseOverlayName) == null) {
            return baseOverlayName;
        }
        int index = 1;
        while (this.getAddressSpace(revisedName = baseOverlayName + "." + index++) != null) {
        }
        return revisedName;
    }

    private String getBaseOverlayName(String overlayName) {
        int value;
        int index = overlayName.lastIndexOf(46);
        if (index < 1) {
            return overlayName;
        }
        try {
            value = Integer.parseInt(overlayName.substring(index + 1));
        }
        catch (NumberFormatException e) {
            return overlayName;
        }
        if (value < 1) {
            return overlayName;
        }
        String baseName = overlayName.substring(0, index);
        return overlayName.equals(baseName + "." + value) ? baseName : overlayName;
    }

    private String fixupOverlaySpaceName(String blockName) {
        int len = blockName.length();
        StringBuffer buf = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = blockName.charAt(i);
            if (c == ':' || c <= ' ') {
                buf.append('_');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public Address getAddress(int spaceID, long offset) {
        Address addr = super.getAddress(spaceID, offset);
        if (addr == null && spaceID == this.stackSpace.getSpaceID()) {
            return this.stackSpace.getAddress(offset);
        }
        return addr;
    }

    @Override
    public Address getAddress(String addrString) {
        Address addr = null;
        if (addrString.startsWith("Stack[") && addrString.endsWith("]")) {
            try {
                long stackOffset = NumericUtilities.parseHexLong((String)addrString.substring(6, addrString.length() - 1));
                addr = this.stackSpace.getAddress(stackOffset);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            addr = super.getAddress(addrString);
        }
        return addr;
    }

    protected void removeOverlaySpace(String name) {
        this.removeAddressSpace(name);
    }

    @Override
    protected String renameOverlaySpace(String oldOverlaySpaceName, String newName) {
        try {
            String revisedName = this.fixupOverlaySpaceName(newName);
            if (revisedName.equals(this.getBaseOverlayName(oldOverlaySpaceName))) {
                return oldOverlaySpaceName;
            }
            revisedName = this.getUniqueOverlayName(revisedName);
            return super.renameOverlaySpace(oldOverlaySpaceName, revisedName);
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextUniqueID() {
        AddressSpace[] spaces;
        int maxID = 0;
        for (AddressSpace space : spaces = this.getAllAddressSpaces()) {
            maxID = Math.max(maxID, space.getUnique());
        }
        return maxID + 1;
    }
}

