/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.Transaction;
import db.util.ErrorHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.store.LockException;
import ghidra.program.database.DataTypeArchiveDB;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.ProjectArchiveBasedDataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;
import javax.help.UnsupportedOperationException;

public class ProjectDataTypeManager
extends StandAloneDataTypeManager
implements ProjectArchiveBasedDataTypeManager {
    private final DataTypeArchiveDB dataTypeArchive;

    ProjectDataTypeManager(DataTypeArchiveDB dataTypeArchive, DBHandle handle, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, openMode, errHandler, lock, monitor);
        this.dataTypeArchive = dataTypeArchive;
        this.reportWarning();
    }

    @Override
    public String getName() {
        return this.dataTypeArchive.getDomainFile().getName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.dataTypeArchive.setName(name);
        this.categoryRenamed(CategoryPath.ROOT, null);
    }

    @Override
    public void clearProgramArchitecture(TaskMonitor monitor) throws CancelledException, IOException, LockException {
        this.dataTypeArchive.checkExclusiveAccess();
        super.clearProgramArchitecture(monitor);
    }

    @Override
    public void setProgramArchitecture(Language language, CompilerSpecID compilerSpecId, StandAloneDataTypeManager.LanguageUpdateOption updateOption, TaskMonitor monitor) throws CompilerSpecNotFoundException, LanguageNotFoundException, IOException, LockException, UnsupportedOperationException, IncompatibleLanguageException, CancelledException {
        this.dataTypeArchive.checkExclusiveAccess();
        super.setProgramArchitecture(language, compilerSpecId, updateOption, monitor);
    }

    @Override
    public void dataTypeChanged(DataType dt, boolean isAutoChange) {
        super.dataTypeChanged(dt, isAutoChange);
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 108, isAutoChange, null, dt);
    }

    @Override
    protected void dataTypeAdded(DataType newDt, DataType originalDataType) {
        super.dataTypeAdded(newDt, originalDataType);
        this.dataTypeArchive.dataTypeAdded(this.getID(newDt), 104, null, newDt);
    }

    @Override
    protected void dataTypeReplaced(long existingDtID, DataTypePath existingPath, DataType replacementDt) {
        super.dataTypeReplaced(existingDtID, existingPath, replacementDt);
        this.dataTypeArchive.dataTypeChanged(existingDtID, 110, false, existingPath, replacementDt);
    }

    @Override
    protected void dataTypeDeleted(long deletedID, DataTypePath deletedDataTypePath) {
        super.dataTypeDeleted(deletedID, deletedDataTypePath);
        this.dataTypeArchive.dataTypeChanged(deletedID, 105, false, deletedDataTypePath, null);
    }

    @Override
    protected void dataTypeMoved(DataType dt, DataTypePath oldPath, DataTypePath newPath) {
        super.dataTypeMoved(dt, oldPath, newPath);
        Category category = this.getCategory(oldPath.getCategoryPath());
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 107, false, category, dt);
    }

    @Override
    protected void dataTypeNameChanged(DataType dt, String oldName) {
        super.dataTypeNameChanged(dt, oldName);
        this.dataTypeArchive.dataTypeChanged(this.getID(dt), 106, false, oldName, dt);
    }

    @Override
    protected void categoryCreated(Category newCategory) {
        super.categoryCreated(newCategory);
        this.dataTypeArchive.categoryAdded(newCategory.getID(), 100, newCategory.getParent(), newCategory);
    }

    @Override
    protected void categoryRenamed(CategoryPath oldPath, Category category) {
        super.categoryRenamed(oldPath, category);
        this.dataTypeArchive.categoryChanged(category.getID(), 102, oldPath.getName(), category);
    }

    @Override
    protected void categoryRemoved(Category parent, String name, long categoryID) {
        super.categoryRemoved(parent, name, categoryID);
        this.dataTypeArchive.categoryChanged(categoryID, 101, parent, name);
    }

    @Override
    protected void categoryMoved(CategoryPath oldPath, Category category) {
        super.categoryMoved(oldPath, category);
        this.dataTypeArchive.categoryChanged(category.getID(), 103, oldPath.getParent(), category);
    }

    @Override
    protected void favoritesChanged(DataType dataType, boolean isFavorite) {
        super.favoritesChanged(dataType, isFavorite);
    }

    @Override
    protected void replaceDataTypeIDs(long oldDataTypeID, long newDataTypeID) {
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) {
    }

    @Override
    public Transaction openTransaction(String description) throws IllegalStateException {
        return this.dataTypeArchive.openTransaction(description);
    }

    @Override
    public int startTransaction(String description) {
        return this.dataTypeArchive.startTransaction(description);
    }

    @Override
    public void flushEvents() {
        this.dataTypeArchive.flushEvents();
    }

    @Override
    public void endTransaction(int transactionID, boolean commit) {
        this.dataTypeArchive.endTransaction(transactionID, commit);
    }

    @Override
    public DomainFile getDomainFile() {
        return this.dataTypeArchive.getDomainFile();
    }

    @Override
    public String getDomainFileID() {
        DomainFile domainFile = this.getDomainFile();
        return domainFile != null ? domainFile.getFileID() : null;
    }

    @Override
    public String getPath() {
        DomainFile domainFile = this.getDomainFile();
        return domainFile != null ? domainFile.getPathname() : null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.PROJECT;
    }

    public void archiveReady(int openMode, TaskMonitor monitor) throws IOException, CancelledException {
        if (openMode == 3) {
            this.doSourceArchiveUpdates(monitor);
            this.migrateOldFlexArrayComponentsIfRequired(monitor);
        }
    }

    @Override
    public void close() {
    }
}

