/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.CompositeDBAdapterV0;
import ghidra.program.database.data.CompositeDBAdapterV1;
import ghidra.program.database.data.CompositeDBAdapterV2V4;
import ghidra.program.database.data.CompositeDBAdapterV5V6;
import ghidra.program.database.util.DBRecordAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class CompositeDBAdapter
implements DBRecordAdapter {
    static final String COMPOSITE_TABLE_NAME = "Composite Data Types";
    static final Schema COMPOSITE_SCHEMA = CompositeDBAdapterV5V6.V5V6_COMPOSITE_SCHEMA;
    static final int COMPOSITE_NAME_COL = 0;
    static final int COMPOSITE_COMMENT_COL = 1;
    static final int COMPOSITE_IS_UNION_COL = 2;
    static final int COMPOSITE_CAT_COL = 3;
    static final int COMPOSITE_LENGTH_COL = 4;
    static final int COMPOSITE_ALIGNMENT_COL = 5;
    static final int COMPOSITE_NUM_COMPONENTS_COL = 6;
    static final int COMPOSITE_SOURCE_ARCHIVE_ID_COL = 7;
    static final int COMPOSITE_UNIVERSAL_DT_ID = 8;
    static final int COMPOSITE_SOURCE_SYNC_TIME_COL = 9;
    static final int COMPOSITE_LAST_CHANGE_TIME_COL = 10;
    static final int COMPOSITE_PACKING_COL = 11;
    static final int COMPOSITE_MIN_ALIGN_COL = 12;
    static final int FLEX_ARRAY_ELIMINATION_SCHEMA_VERSION = 6;
    private boolean flexArrayMigrationRequired = false;

    CompositeDBAdapter() {
    }

    final boolean isFlexArrayMigrationRequired() {
        return this.flexArrayMigrationRequired;
    }

    static CompositeDBAdapter getAdapter(DBHandle handle, int openMode, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        try {
            return new CompositeDBAdapterV5V6(handle, openMode, tablePrefix);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            CompositeDBAdapter adapter = CompositeDBAdapter.findReadOnlyAdapter(handle, tablePrefix);
            if (openMode == 3) {
                return CompositeDBAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            }
            return adapter;
        }
    }

    private static CompositeDBAdapter findReadOnlyAdapter(DBHandle handle, String tablePrefix) throws VersionException, IOException {
        try {
            return new CompositeDBAdapterV5V6(handle, 2, tablePrefix);
        }
        catch (VersionException versionException) {
            try {
                return new CompositeDBAdapterV2V4(handle);
            }
            catch (VersionException versionException2) {
                try {
                    return new CompositeDBAdapterV1(handle);
                }
                catch (VersionException versionException3) {
                    return new CompositeDBAdapterV0(handle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompositeDBAdapter upgrade(DBHandle handle, CompositeDBAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        CompositeDBAdapterV5V6 tmpAdapter = null;
        try {
            tmpAdapter = new CompositeDBAdapterV5V6(tmpHandle, 0, tablePrefix);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((CompositeDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            CompositeDBAdapterV5V6 newAdapter = new CompositeDBAdapterV5V6(handle, 0, tablePrefix);
            if (oldAdapter.getVersion() < 6) {
                newAdapter.flexArrayMigrationRequired = true;
            }
            it = ((CompositeDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((CompositeDBAdapter)newAdapter).updateRecord(rec, false);
            }
            CompositeDBAdapterV5V6 compositeDBAdapterV5V6 = newAdapter;
            return compositeDBAdapterV5V6;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract int getVersion();

    abstract DBRecord createRecord(String var1, String var2, boolean var3, long var4, int var6, int var7, long var8, long var10, long var12, int var14, int var15) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    @Override
    public abstract RecordIterator getRecords() throws IOException;

    abstract void updateRecord(DBRecord var1, boolean var2) throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    abstract Field[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract DBRecord getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;

    @Override
    public abstract int getRecordCount();
}

