/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.jar.ResourceFile;
import ghidra.framework.store.db.PackedDBHandle;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.FileArchiveBasedDataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class FileDataTypeManager
extends StandAloneDataTypeManager
implements FileArchiveBasedDataTypeManager {
    public static final String EXTENSION = "gdt";
    public static final GhidraFileFilter GDT_FILEFILTER = ExtensionFileFilter.forExtensions((String)"Ghidra Data Type Files", (String[])new String[]{"gdt"});
    public static final String SUFFIX = ".gdt";
    static final String OLD_EXTENSION = "dtf";
    static final String OLD_SUFFIX = ".dtf";
    private ResourceFile file;
    private PackedDatabase packedDB;

    private FileDataTypeManager(ResourceFile packedDbfile, int openMode) throws IOException {
        super(FileDataTypeManager.validateFilename(packedDbfile), openMode);
        this.file = packedDbfile;
        this.name = this.getRootName(this.file.getName());
        this.packedDB = ((PackedDBHandle)this.dbHandle).getPackedDatabase();
        this.reportWarning();
    }

    private static ResourceFile validateFilename(ResourceFile packedDbfile) {
        if (!packedDbfile.getName().endsWith(SUFFIX)) {
            throw new IllegalArgumentException("Archive files must end with .gdt");
        }
        return packedDbfile;
    }

    public static FileDataTypeManager createFileArchive(File packedDbfile) throws IOException {
        return new FileDataTypeManager(new ResourceFile(packedDbfile), 0);
    }

    public static FileDataTypeManager openFileArchive(File packedDbfile, boolean openForUpdate) throws IOException {
        return FileDataTypeManager.openFileArchive(new ResourceFile(packedDbfile), openForUpdate);
    }

    public static FileDataTypeManager openFileArchive(ResourceFile packedDbfile, boolean openForUpdate) throws IOException {
        int mode = openForUpdate ? 1 : 2;
        return new FileDataTypeManager(packedDbfile, mode);
    }

    public void saveAs(File saveFile, UniversalID newUniversalId) throws DuplicateFileException, IOException {
        ResourceFile resourceSaveFile = new ResourceFile(saveFile);
        FileDataTypeManager.validateFilename(resourceSaveFile);
        try {
            this.universalID = newUniversalId;
            this.packedDB = ((PackedDBHandle)this.dbHandle).saveAs("DTArchive", saveFile.getParentFile(), saveFile.getName(), Long.valueOf(newUniversalId.getValue()), TaskMonitor.DUMMY);
            this.file = resourceSaveFile;
            this.updateRootCategoryName(resourceSaveFile, this.getRootCategory());
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public void saveAs(File saveFile) throws DuplicateFileException, IOException {
        ResourceFile resourceSaveFile = new ResourceFile(saveFile);
        FileDataTypeManager.validateFilename(resourceSaveFile);
        try {
            this.packedDB = ((PackedDBHandle)this.dbHandle).saveAs("DTArchive", saveFile.getParentFile(), saveFile.getName(), TaskMonitor.DUMMY);
            this.file = resourceSaveFile;
            this.updateRootCategoryName(resourceSaveFile, this.getRootCategory());
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        if (this.file == null) {
            throw new IllegalStateException("Output File was not specified: call saveAs(String)");
        }
        try {
            ((PackedDBHandle)this.dbHandle).save(TaskMonitor.DUMMY);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public String getFilename() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }

    public static File convertFilename(File file) {
        Object fname = file.getName();
        if (file.getName().endsWith(SUFFIX)) {
            return file;
        }
        int pos = ((String)fname).indexOf(OLD_SUFFIX);
        if (pos > 0) {
            fname = ((String)fname).substring(0, pos);
        }
        fname = (String)fname + SUFFIX;
        return new File(file.getParentFile(), (String)fname);
    }

    private void updateRootCategoryName(ResourceFile newFile, Category root) {
        String newName = this.getRootName(newFile.getName());
        if (root.getName().equals(newName)) {
            return;
        }
        try {
            root.setName(newName);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    private String getRootName(String newName) {
        int pos = newName.lastIndexOf(SUFFIX);
        if (pos > 0) {
            newName = newName.substring(0, pos);
        }
        return newName;
    }

    public void delete() throws IOException {
        super.close();
        if (this.packedDB != null) {
            this.packedDB.delete();
            this.packedDB = null;
        }
    }

    @Override
    public void close() {
        if (this.packedDB != null) {
            this.packedDB.dispose();
            this.packedDB = null;
        }
        super.close();
    }

    public boolean isClosed() {
        return this.packedDB == null;
    }

    @Override
    public void finalize() {
        this.close();
    }

    public static void delete(File packedDbfile) throws IOException {
        if (packedDbfile == null) {
            return;
        }
        String filename = packedDbfile.getAbsolutePath();
        if (filename.endsWith(OLD_SUFFIX)) {
            packedDbfile.delete();
        } else {
            PackedDatabase.delete((File)packedDbfile);
        }
    }

    @Override
    public String getPath() {
        return this.file != null ? this.file.getAbsolutePath() : null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.FILE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.getName();
    }
}

