/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import java.io.IOException;
import java.util.ArrayList;

public class AddressXML {
    public static int MAX_PIECES = 64;
    private AddressSpace space;
    private long offset;
    private long size;
    private Varnode[] joinRecord;

    private AddressXML() {
        this.space = null;
        this.joinRecord = null;
    }

    public AddressXML(AddressSpace spc, long off, int sz) {
        this.space = spc;
        this.offset = off;
        this.size = sz;
        this.joinRecord = null;
    }

    public AddressXML(AddressSpace spc, long off, int sz, Varnode[] pieces) {
        if (spc.getType() != 6) {
            throw new IllegalArgumentException("JOIN address space required to represent an Address with pieces");
        }
        this.space = spc;
        this.offset = off;
        this.size = sz;
        this.joinRecord = pieces;
    }

    private void readJoinXML(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        String attrName;
        String attrVal;
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        int sizesum = 0;
        int pos = 0;
        while ((attrVal = el.getAttribute(attrName = "piece" + Integer.toString(pos + 1))) != null) {
            Varnode newvn;
            int offpos = attrVal.indexOf(58);
            if (offpos == -1) {
                Register register = cspec.getLanguage().getRegister(attrVal);
                if (register == null) {
                    throw new XmlParseException("Unknown pentry register: " + attrVal);
                }
                newvn = new Varnode(register.getAddress(), register.getBitLength() / 8);
            } else {
                int szpos = attrVal.indexOf(58, offpos + 1);
                if (szpos == -1) {
                    throw new XmlParseException("join address piece attribute is malformed");
                }
                String spcname = attrVal.substring(0, offpos);
                AddressSpace spc = cspec.getAddressSpace(spcname);
                long off = SpecXmlUtils.decodeLong((String)attrVal.substring(offpos + 1, szpos));
                long sz = SpecXmlUtils.decodeLong((String)attrVal.substring(szpos + 1));
                newvn = new Varnode(spc.getAddress(off), (int)sz);
            }
            pieces.add(newvn);
            sizesum += newvn.getSize();
            ++pos;
        }
        this.offset = 0L;
        this.size = sizesum;
        this.joinRecord = new Varnode[pieces.size()];
        pieces.toArray(this.joinRecord);
    }

    public void encode(Encoder encoder) throws IOException {
        if (this.joinRecord != null) {
            long logicalSize = this.size;
            long sizeSum = 0L;
            for (Varnode vn : this.joinRecord) {
                sizeSum += (long)vn.getSize();
            }
            if (sizeSum == this.size) {
                logicalSize = 0L;
            }
            AddressXML.encode(encoder, this.joinRecord, logicalSize);
            return;
        }
        encoder.openElement(ElementId.ELEM_ADDR);
        if (this.space != null) {
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, this.space);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, this.offset);
            if (this.size != 0L) {
                encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, this.size);
            }
        }
        encoder.closeElement(ElementId.ELEM_ADDR);
    }

    public static AddressXML restoreXml(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        AddressXML result;
        if (el.getName().equals("register")) {
            String regName = el.getAttribute("name");
            if (regName == null) {
                throw new XmlParseException("Missing pentry register name");
            }
            Register register = cspec.getLanguage().getRegister(regName);
            if (register == null) {
                throw new XmlParseException("Unknown pentry register: " + regName);
            }
            result = new AddressXML(register.getAddressSpace(), register.getOffset(), register.getMinimumByteSize());
        } else {
            result = new AddressXML();
            result.size = 0L;
            String spaceName = el.getAttribute("space");
            result.space = cspec.getAddressSpace(spaceName);
            if (result.space == null) {
                throw new XmlParseException("Unknown address space: " + spaceName);
            }
            if (result.space.getType() == 6) {
                result.readJoinXML(el, cspec);
            } else {
                result.offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
            }
            String sizeString = el.getAttribute("size");
            if (sizeString != null) {
                result.size = SpecXmlUtils.decodeInt((String)sizeString);
            }
        }
        return result;
    }

    public static AddressXML restoreXml(XmlElement el, Language language) throws XmlParseException {
        AddressXML result;
        if (el.getName().equals("register")) {
            String regName = el.getAttribute("name");
            if (regName == null) {
                throw new XmlParseException("Missing register name");
            }
            Register register = language.getRegister(regName);
            if (register == null) {
                throw new XmlParseException("Unknown register: " + regName);
            }
            result = new AddressXML(register.getAddressSpace(), register.getOffset(), register.getMinimumByteSize());
        } else {
            result = new AddressXML();
            result.size = 0L;
            String spaceName = el.getAttribute("space");
            result.space = language.getAddressFactory().getAddressSpace(spaceName);
            if (result.space == null) {
                throw new XmlParseException("Unknown address space: " + spaceName);
            }
            result.offset = SpecXmlUtils.decodeLong((String)el.getAttribute("offset"));
            String sizeString = el.getAttribute("size");
            if (sizeString != null) {
                result.size = SpecXmlUtils.decodeInt((String)sizeString);
            }
        }
        return result;
    }

    public static AddressXML restoreRangeXml(XmlElement el, CompilerSpec cspec) throws XmlParseException {
        AddressXML result = new AddressXML();
        result.offset = 0L;
        long last = -1L;
        boolean seenLast = false;
        String attrvalue = el.getAttribute("space");
        if (attrvalue != null) {
            result.space = cspec.getAddressSpace(attrvalue);
            if (result.space == null) {
                throw new XmlParseException("Undefined space: " + attrvalue);
            }
        }
        if ((attrvalue = el.getAttribute("first")) != null) {
            result.offset = SpecXmlUtils.decodeLong((String)attrvalue);
        }
        if ((attrvalue = el.getAttribute("last")) != null) {
            last = SpecXmlUtils.decodeLong((String)attrvalue);
            seenLast = true;
        }
        if ((attrvalue = el.getAttribute("name")) != null) {
            Register register = cspec.getLanguage().getRegister(attrvalue);
            result.space = register.getAddressSpace();
            result.offset = register.getOffset();
            last = result.offset - 1L + (long)register.getMinimumByteSize();
            seenLast = true;
        }
        if (result.space == null) {
            throw new XmlParseException("No address space indicated in range tag");
        }
        if (!seenLast) {
            last = result.space.getMaxAddress().getOffset();
        }
        result.size = last - result.offset + 1L;
        return result;
    }

    public final AddressSpace getAddressSpace() {
        return this.space;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final long getSize() {
        return this.size;
    }

    public final Varnode[] getJoinRecord() {
        return this.joinRecord;
    }

    public Varnode getVarnode() {
        Address addr = this.space.getAddress(this.offset);
        return new Varnode(addr, (int)this.size);
    }

    public Address getFirstAddress() {
        return this.space.getAddress(this.offset);
    }

    public Address getLastAddress() {
        return this.space.getAddress(this.offset + this.size - 1L);
    }

    public static Address decodeFromAttributes(Decoder decoder) throws DecoderException {
        int attribId;
        AddressSpace spc = null;
        long offset = -1L;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_SPACE.id()) {
                spc = decoder.readSpace();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_OFFSET.id()) continue;
            offset = decoder.readUnsignedInteger();
        }
        if (spc == null) {
            return Address.NO_ADDRESS;
        }
        return spc.getAddress(offset);
    }

    public static VariableStorage decodeStorageFromAttributes(int size, Decoder decoder, PcodeFactory pcodeFactory) throws DecoderException {
        VariableStorage storage;
        try {
            Address varAddr = AddressXML.decodeFromAttributes(decoder);
            AddressSpace spc = varAddr.getAddressSpace();
            if (spc == null || varAddr == Address.NO_ADDRESS) {
                storage = VariableStorage.VOID_STORAGE;
            } else if (spc.getType() != 11) {
                if (size <= 0) {
                    size = (int)decoder.readSignedInteger(AttributeId.ATTRIB_SIZE);
                }
                Program program = pcodeFactory.getDataTypeManager().getProgram();
                storage = new VariableStorage((ProgramArchitecture)program, varAddr, size);
            } else {
                decoder.rewindAttributes();
                Varnode[] pieces = Varnode.decodePieces(decoder);
                storage = pcodeFactory.getJoinStorage(pieces);
            }
        }
        catch (InvalidInputException e) {
            throw new DecoderException("Invalid storage: " + e.getMessage());
        }
        return storage;
    }

    public static Address decode(Decoder decoder) throws DecoderException {
        int attribId;
        int el = decoder.openElement();
        if (el == ElementId.ELEM_SPACEID.id()) {
            AddressSpace spc = decoder.readSpace(AttributeId.ATTRIB_NAME);
            decoder.closeElement(el);
            int spaceid = spc.getSpaceID();
            spc = decoder.getAddressFactory().getConstantSpace();
            return spc.getAddress(spaceid);
        }
        if (el == ElementId.ELEM_IOP.id()) {
            int ref = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_VALUE);
            decoder.closeElement(el);
            AddressSpace spc = decoder.getAddressFactory().getConstantSpace();
            return spc.getAddress(ref);
        }
        AddressSpace spc = null;
        long offset = -1L;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_SPACE.id()) {
                spc = decoder.readSpace();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_OFFSET.id()) continue;
            offset = decoder.readUnsignedInteger();
        }
        decoder.closeElement(el);
        if (spc == null) {
            return Address.NO_ADDRESS;
        }
        return spc.getAddress(offset);
    }

    public static void encodeAttributes(Encoder encoder, Address addr) throws IOException {
        AddressSpace space = addr.getAddressSpace();
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, addr.getUnsignedOffset());
    }

    public static void encodeAttributes(Encoder encoder, Address addr, int size) throws IOException {
        AddressSpace space = addr.getAddressSpace();
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, addr.getUnsignedOffset());
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
    }

    public static void encodeAttributes(Encoder encoder, Address startAddr, Address endAddr) throws IOException {
        AddressSpace space = startAddr.getAddressSpace();
        long offset = startAddr.getOffset();
        long size = endAddr.getOffset() - offset + 1L;
        if (space != endAddr.getAddressSpace()) {
            throw new IllegalArgumentException("Range boundaries are not in the same address space");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Start of range comes after end of range");
        }
        long last = offset + size - 1L;
        boolean useFirst = offset != 0L;
        boolean useLast = last != -1L;
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, space);
        if (useFirst) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, offset);
        }
        if (useLast) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, last);
        }
    }

    public static void encode(Encoder encoder, Address addr) throws IOException {
        encoder.openElement(ElementId.ELEM_ADDR);
        if (addr == null || addr == Address.NO_ADDRESS) {
            encoder.closeElement(ElementId.ELEM_ADDR);
            return;
        }
        AddressXML.encodeAttributes(encoder, addr);
        encoder.closeElement(ElementId.ELEM_ADDR);
    }

    public static void encode(Encoder encoder, Address addr, int size) throws IOException {
        encoder.openElement(ElementId.ELEM_ADDR);
        AddressXML.encodeAttributes(encoder, addr, size);
        encoder.closeElement(ElementId.ELEM_ADDR);
    }

    public static void encode(Encoder encoder, Varnode[] varnodes, long logicalsize) throws IOException {
        if (varnodes == null) {
            encoder.openElement(ElementId.ELEM_ADDR);
            encoder.closeElement(ElementId.ELEM_ADDR);
            return;
        }
        if (varnodes.length == 1 && logicalsize == 0L) {
            AddressXML.encode(encoder, varnodes[0].getAddress(), varnodes[0].getSize());
            return;
        }
        if (varnodes.length > MAX_PIECES) {
            throw new IOException("Exceeded maximum pieces in one join address");
        }
        encoder.openElement(ElementId.ELEM_ADDR);
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, AddressSpace.VARIABLE_SPACE);
        for (int i = 0; i < varnodes.length; ++i) {
            encoder.writeStringIndexed(AttributeId.ATTRIB_PIECE, i, varnodes[i].encodePiece());
        }
        if (logicalsize != 0L) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_LOGICALSIZE, logicalsize);
        }
        encoder.closeElement(ElementId.ELEM_ADDR);
    }
}

