/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import java.io.IOException;

public class MappedEntry
extends SymbolEntry {
    protected VariableStorage storage;

    public MappedEntry(HighSymbol sym) {
        super(sym);
    }

    public MappedEntry(HighSymbol sym, VariableStorage store, Address addr) {
        super(sym);
        this.storage = store;
        this.pcaddr = addr;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int sz = this.symbol.type.getLength();
        if (sz == 0) {
            throw new DecoderException("Invalid symbol 0-sized data-type: " + this.symbol.type.getName());
        }
        int addrel = decoder.openElement(ElementId.ELEM_ADDR);
        this.storage = AddressXML.decodeStorageFromAttributes(sz, decoder, this.symbol.function);
        decoder.closeElement(addrel);
        this.decodeRangeList(decoder);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        int logicalsize = 0;
        int typeLength = this.symbol.type.getLength();
        if (typeLength != this.storage.size() && this.symbol.type instanceof AbstractFloatDataType) {
            logicalsize = typeLength;
        }
        AddressXML.encode(encoder, this.storage.getVarnodes(), (long)logicalsize);
        this.encodeRangelist(encoder);
    }

    @Override
    public VariableStorage getStorage() {
        return this.storage;
    }

    @Override
    public int getSize() {
        return this.storage.size();
    }

    @Override
    public boolean isReadOnly() {
        Address addr = this.storage.getMinAddress();
        if (addr == null) {
            return false;
        }
        boolean readonly = false;
        Program program = this.symbol.getProgram();
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block != null) {
            boolean bl = readonly = !block.isWrite();
            if (readonly) {
                ReferenceIterator refIter = program.getReferenceManager().getReferencesTo(addr);
                for (int count = 0; refIter.hasNext() && count < 100; ++count) {
                    Reference ref = refIter.next();
                    if (ref.getReferenceType().isWrite()) {
                        readonly = false;
                        break;
                    }
                    if (!ref.getReferenceType().isRead()) continue;
                }
            }
        }
        return readonly;
    }

    @Override
    public boolean isVolatile() {
        Address addr = this.storage.getMinAddress();
        if (addr == null) {
            return false;
        }
        Program program = this.symbol.getProgram();
        if (program.getLanguage().isVolatile(addr)) {
            return true;
        }
        MemoryBlock block = program.getMemory().getBlock(addr);
        return block != null && block.isVolatile();
    }
}

