/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CommentFieldLocation;

public class AutomaticCommentFieldLocation
extends CommentFieldLocation {
    private int currentCommentRow;

    public AutomaticCommentFieldLocation(Program program, Address addr, int[] componentPath, String[] comment, int row, int charOffset, int currentCommentRow) {
        super(program, addr, componentPath, comment, 0, row, charOffset);
        this.currentCommentRow = currentCommentRow;
    }

    public AutomaticCommentFieldLocation() {
    }

    public int getCurrentCommentRow() {
        return this.currentCommentRow;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.currentCommentRow;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutomaticCommentFieldLocation other = (AutomaticCommentFieldLocation)obj;
        return this.currentCommentRow == other.currentCommentRow;
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putInt("_COMMENT_ROW", this.currentCommentRow);
    }

    @Override
    public void restoreState(Program p, SaveState obj) {
        super.restoreState(p, obj);
        this.currentCommentRow = obj.getInt("_COMMENT_ROW", this.currentCommentRow);
    }

    @Override
    public String toString() {
        return super.toString() + ", Comment Row = " + this.currentCommentRow;
    }
}

