/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.AnnotationSetItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MethodAnnotationsItem
implements StructConverter {
    private int methodIndex;
    private int annotationsOffset;
    private AnnotationSetItem _annotationSetItem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodAnnotationsItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        this.methodIndex = reader.readNextInt();
        this.annotationsOffset = reader.readNextInt();
        if (this.annotationsOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(DexUtil.adjustOffset(this.annotationsOffset, dexHeader));
                this._annotationSetItem = new AnnotationSetItem(reader, dexHeader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getMethodIndex() {
        return this.methodIndex;
    }

    public int getAnnotationsOffset() {
        return this.annotationsOffset;
    }

    public AnnotationSetItem getAnnotationSetItem() {
        return this._annotationSetItem;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(MethodAnnotationsItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

