/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.fbpk.FBPK;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.file.formats.android.fbpk.v2.FBPKv2_Partition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FBPKv2
implements FBPK {
    private int magic;
    private int version;
    private int unknown1;
    private int unknown2;
    private String string1;
    private String string2;
    private int unknown3;
    private int partitionCount;
    private int size;
    private List<FBPK_Partition> partitions = new ArrayList<FBPK_Partition>();

    public FBPKv2(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.version = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.string1 = reader.readNextAsciiString(16);
        this.string2 = reader.readNextAsciiString(68);
        this.unknown3 = reader.readNextInt();
        this.partitionCount = reader.readNextInt();
        this.size = reader.readNextInt();
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions.add(new FBPKv2_Partition(reader));
        }
    }

    @Override
    public int getMagic() {
        return this.magic;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public List<FBPK_Partition> getPartitions() {
        return new ArrayList<FBPK_Partition>(this.partitions);
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public int getUnknown3() {
        return this.unknown3;
    }

    public String getString1() {
        return this.string1;
    }

    public String getString2() {
        return this.string2;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPKv2.class.getSimpleName(), 0);
        struct.add(STRING, "FBPK".length(), "magic", null);
        struct.add(DWORD, "version", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "unknown2", null);
        struct.add(STRING, 16, "string1", null);
        struct.add(STRING, 68, "string2", null);
        struct.add(DWORD, "unknown3", null);
        struct.add(DWORD, "partitionCount", null);
        struct.add(DWORD, "size", null);
        return struct;
    }
}

