/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Ext4DirEntry
implements StructConverter {
    protected static final int SIZEOF_FIXEDFIELDS = 8;
    protected int inode;
    protected short rec_len;
    protected short name_len;
    protected String name;
    protected byte[] extra;

    public static Ext4DirEntry read(BinaryReader reader) throws IOException {
        if (reader.getPointerIndex() + 8L >= reader.length()) {
            return null;
        }
        Ext4DirEntry result = new Ext4DirEntry();
        result.inode = reader.readNextInt();
        result.rec_len = reader.readNextShort();
        result.name_len = reader.readNextShort();
        result.name = new String(reader.readNextByteArray((int)result.name_len), StandardCharsets.UTF_8);
        int extraSize = Short.toUnsignedInt(result.rec_len) - (8 + result.name_len);
        if (extraSize > 0) {
            result.extra = reader.readNextByteArray(extraSize);
        }
        return result;
    }

    protected Ext4DirEntry() {
    }

    public int getInode() {
        return this.inode;
    }

    public short getRec_len() {
        return this.rec_len;
    }

    public short getName_len() {
        return this.name_len;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public boolean isUnused() {
        return this.inode == 0;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_dir_entry", 0);
        structure.add(DWORD, "inode", null);
        structure.add(WORD, "rec_len", null);
        structure.add(WORD, "name_len", null);
        structure.add(STRING, (int)this.name_len, "name", null);
        if (this.extra != null) {
            structure.add((DataType)new ArrayDataType(BYTE, this.extra.length, BYTE.getLength()), "extra", null);
        }
        return structure;
    }
}

