/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import ghidra.graph.viewer.layout.Row;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.map.LazyMap;

public class GridLocationMap<V, E> {
    private Factory<Point> rowColFactory = () -> new Point();
    private Map<V, Point> vertexPoints = LazyMap.lazyMap(new HashMap(), this.rowColFactory);
    private Map<E, List<Point>> edgePoints = new HashMap<E, List<Point>>();

    Set<V> vertices() {
        return this.vertexPoints.keySet();
    }

    Set<E> edges() {
        return this.edgePoints.keySet();
    }

    public void setArticulations(E edge, List<Point> articulations) {
        this.edgePoints.put(edge, articulations);
    }

    public List<Point> getArticulations(E edge) {
        List<Point> list = this.edgePoints.get(edge);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void row(V vertex, int row) {
        this.vertexPoints.get(vertex).y = row;
    }

    public void col(V vertex, int col) {
        this.vertexPoints.get(vertex).x = col;
    }

    public void set(V v, int row, int col) {
        Point p = this.vertexPoints.get(v);
        p.x = col;
        p.y = row;
    }

    public int row(V vertex) {
        return this.vertexPoints.get(vertex).y;
    }

    public int col(V vertex) {
        return this.vertexPoints.get(vertex).x;
    }

    public List<Row<V>> rows() {
        HashMap<Integer, Row<V>> rowsByIndex = new HashMap<Integer, Row<V>>();
        Set<Map.Entry<V, Point>> entrySet = this.vertexPoints.entrySet();
        for (Map.Entry<V, Point> entry : entrySet) {
            V v = entry.getKey();
            Point gridPoint = entry.getValue();
            int rowIndex = gridPoint.y;
            Row<V> row = this.getRow(rowsByIndex, rowIndex);
            row.index = rowIndex;
            row.setColumn(v, gridPoint.x);
        }
        ArrayList<Row<V>> rows = new ArrayList<Row<V>>(rowsByIndex.values());
        rows.sort((r1, r2) -> r1.index - r2.index);
        return rows;
    }

    private Row<V> getRow(Map<Integer, Row<V>> rows, int rowIndex) {
        Row<V> row = rows.get(rowIndex);
        if (row == null) {
            row = new Row(rowIndex);
            rows.put(rowIndex, row);
        }
        return row;
    }

    public void centerRows() {
        List<Row<V>> rows = this.rows();
        int maxCol = this.columnCount(rows);
        for (Row<V> row : rows) {
            int rowColumnCount = (row = this.zeroRowColumns(row)).getColumnCount();
            if (rowColumnCount == maxCol) continue;
            int delta = maxCol - rowColumnCount;
            int offset = delta / 2;
            List<V> vertices = row.getVertices();
            for (V v : vertices) {
                if (v == null) continue;
                int oldCol = this.col(v);
                this.set(v, row.index, oldCol + offset);
            }
            row.dispose();
        }
    }

    private int maxColumnIndex(List<Row<V>> rows) {
        int maxCol = 0;
        for (Row<V> row : rows) {
            maxCol = Math.max(maxCol, row.getEndColumn());
        }
        return maxCol;
    }

    private int maxRowIndex(List<Row<V>> rows) {
        int maxRow = 0;
        for (Row<V> row : rows) {
            maxRow = Math.max(maxRow, row.index);
        }
        return maxRow;
    }

    private int columnCount(List<Row<V>> rows) {
        int maxCount = 0;
        for (Row<V> row : rows) {
            maxCount = Math.max(maxCount, row.getColumnCount());
        }
        return maxCount;
    }

    private Row<V> zeroRowColumns(Row<V> row) {
        int start = row.getStartColumn();
        int offset = -start;
        Row<V> updatedRow = new Row<V>();
        updatedRow.index = row.index;
        for (V v : row.getVertices()) {
            int oldCol = this.col(v);
            int newCol = oldCol + offset;
            this.set(v, row.index, newCol);
            updatedRow.setColumn(v, newCol);
        }
        row.dispose();
        return updatedRow;
    }

    GridLocationMap<V, E> copy() {
        GridLocationMap<V, E> map = new GridLocationMap<V, E>();
        map.vertexPoints = new HashMap<V, Point>();
        Set<Map.Entry<V, Point>> entries = this.vertexPoints.entrySet();
        for (Map.Entry<V, Point> entry : entries) {
            map.vertexPoints.put((Point)entry.getKey(), (Point)entry.getValue().clone());
        }
        map.edgePoints = new HashMap<E, List<Point>>();
        Set<Map.Entry<E, List<Point>>> edgeEntries = this.edgePoints.entrySet();
        for (Map.Entry<E, List<Point>> entry : edgeEntries) {
            List<Point> points = entry.getValue();
            ArrayList<Point> clonedPoints = new ArrayList<Point>(points.size());
            for (Point p : points) {
                clonedPoints.add((Point)p.clone());
            }
            map.edgePoints.put(entry.getKey(), clonedPoints);
        }
        return map;
    }

    public void dispose() {
        this.vertexPoints.clear();
        this.edgePoints.clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\n\tvertex points=" + this.vertexPoints + "\n\tedge points=" + this.edgePoints + "]";
    }

    public String toStringGrid() {
        GridLocationMap<V, E> copy = this.copy();
        GridLocationMap.zeroAlignGrid(copy);
        List<Row<V>> rows = copy.rows();
        int columnCount = copy.maxColumnIndex(rows) + 1;
        int rowCount = copy.maxRowIndex(rows) + 1;
        Object[][] vGrid = new Object[rowCount][columnCount];
        for (Row<V> row : rows) {
            List<V> vertices = row.getVertices();
            for (V v : vertices) {
                vGrid[row.index][row.getColumn(v)] = v;
            }
        }
        StringBuilder buffy = new StringBuilder("\n");
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                Object o = vGrid[row][col];
                buffy.append(' ');
                if (o == null) {
                    buffy.append('-');
                } else {
                    buffy.append('v');
                }
                buffy.append(' ');
            }
            buffy.append('\n');
        }
        return buffy.toString();
    }

    private static <V, E> void zeroAlignGrid(GridLocationMap<V, E> grid) {
        int smallestColumnIndex = 0;
        int smallestRowIndex = 0;
        List<Row<V>> rows = grid.rows();
        for (Row<V> row : rows) {
            smallestRowIndex = Math.min(smallestRowIndex, row.index);
            smallestColumnIndex = Math.min(smallestColumnIndex, row.getStartColumn());
        }
        int globalColumnOffset = -smallestColumnIndex;
        int globalRowOffset = -smallestRowIndex;
        for (Row<V> row : rows) {
            List<V> vertices = row.getVertices();
            for (V v : vertices) {
                int oldCol = grid.col(v);
                int oldRow = grid.row(v);
                int newCol = globalColumnOffset + oldCol;
                int newRow = globalRowOffset + oldRow;
                grid.set(v, newRow, newCol);
            }
        }
    }
}

