/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramConflictException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BookmarkMerger
extends AbstractListingMerger {
    static final String BOOKMARKS_PHASE = "Bookmarks";
    private VerticalChoicesPanel conflictPanel;
    private String type;
    private String category;
    private BookmarkManager originalBookmarkMgr;
    private BookmarkManager latestBookmarkMgr;
    private BookmarkManager myBookmarkMgr;
    private AddressSet conflictSet;
    private Hashtable<Address, ArrayList<BookmarkUid>> conflicts;
    private AddressSet resolvedSet;
    private int bookmarkChoice = 0;

    BookmarkMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.originalBookmarkMgr = this.originalPgm.getBookmarkManager();
        this.latestBookmarkMgr = this.latestPgm.getBookmarkManager();
        this.myBookmarkMgr = this.myPgm.getBookmarkManager();
        this.conflictSet = new AddressSet();
        this.resolvedSet = new AddressSet();
        this.conflicts = new Hashtable();
    }

    @Override
    public String getConflictType() {
        return "Bookmark";
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.bookmarkChoice = this.conflictOption;
        }
        return super.apply();
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging Bookmarks and determining conflicts.", progressMin, progressMax, monitor);
        AddressIterator iterator = this.listingMergeMgr.mySet.getAddresses(true);
        this.totalChanges = this.listingMergeMgr.mySet.getNumAddresses();
        while (iterator.hasNext()) {
            int i;
            Address addr = iterator.next();
            this.incrementProgress(1);
            Bookmark[] bookmarks = this.originalBookmarkMgr.getBookmarks(addr);
            for (i = 0; i < bookmarks.length; ++i) {
                this.checkOriginalBookmark(monitor, addr, bookmarks[i]);
            }
            bookmarks = this.myBookmarkMgr.getBookmarks(addr);
            for (i = 0; i < bookmarks.length; ++i) {
                this.checkAddedBookmark(monitor, addr, bookmarks[i]);
            }
        }
        this.updateProgress(100, "Done auto-merging Bookmarks and determining conflicts.");
    }

    private void checkOriginalBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        if (currentBookmark.getTypeString() == "Note") {
            this.checkOriginalNoteBookmark(monitor, addr, currentBookmark);
        } else {
            this.checkOriginalNonNoteBookmark(monitor, addr, currentBookmark);
        }
    }

    private void checkOriginalNoteBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        String originalType = currentBookmark.getTypeString();
        String originalCategory = currentBookmark.getCategory();
        String originalComment = currentBookmark.getComment();
        Bookmark[] my = this.myBookmarkMgr.getBookmarks(addr, originalType);
        if (my.length > 1) {
            throw new AssertException("Error in CHECKED OUT program - Shouldn't be multiple notes at a single address. Address=" + addr.toString());
        }
        Bookmark[] latest = this.latestBookmarkMgr.getBookmarks(addr, originalType);
        if (latest.length > 1) {
            throw new AssertException("Error in LATEST checked in program - Shouldn't be multiple notes at a single address. Address=" + addr.toString());
        }
        if (my.length == 0) {
            if (latest.length == 1) {
                String latestCategory = latest[0].getCategory();
                String latestComment = latest[0].getComment();
                if (!originalCategory.equals(latestCategory) || !originalComment.equals(latestComment)) {
                    this.addConflict(addr, originalType, null);
                } else {
                    this.merge(addr, originalType, null, 4, monitor);
                }
            }
        } else if (my.length == 1) {
            String myCategory = my[0].getCategory();
            String myComment = my[0].getComment();
            if (!originalCategory.equals(myCategory) || !originalComment.equals(myComment)) {
                if (latest.length == 0) {
                    this.addConflict(addr, originalType, null);
                } else if (latest.length == 1) {
                    String latestCategory = latest[0].getCategory();
                    String latestComment = latest[0].getComment();
                    if (!(originalCategory.equals(latestCategory) && originalComment.equals(latestComment) || myCategory.equals(latestCategory) && myComment.equals(latestComment))) {
                        this.addConflict(addr, originalType, null);
                    } else {
                        this.merge(addr, originalType, null, 4, monitor);
                    }
                }
            }
        }
    }

    private void checkOriginalNonNoteBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        String originalType = currentBookmark.getTypeString();
        String originalCategory = currentBookmark.getCategory();
        String originalComment = currentBookmark.getComment();
        Bookmark my = this.myBookmarkMgr.getBookmark(addr, originalType, originalCategory);
        Bookmark latest = this.latestBookmarkMgr.getBookmark(addr, originalType, originalCategory);
        if (my == null) {
            if (latest != null) {
                String latestComment = latest.getComment();
                if (!originalComment.equals(latestComment)) {
                    this.addConflict(addr, originalType, originalCategory);
                } else {
                    this.merge(addr, originalType, originalCategory, 4, monitor);
                }
            }
        } else {
            String myComment = my.getComment();
            if (!originalComment.equals(myComment)) {
                if (latest == null) {
                    this.addConflict(addr, originalType, originalCategory);
                } else {
                    String latestComment = latest.getComment();
                    if (!originalComment.equals(latestComment) && !myComment.equals(latestComment)) {
                        this.addConflict(addr, originalType, originalCategory);
                    } else {
                        this.merge(addr, originalType, originalCategory, 4, monitor);
                    }
                }
            }
        }
    }

    private void checkAddedBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        if (currentBookmark.getTypeString().equals("Note")) {
            this.checkAddedNoteBookmark(monitor, addr, currentBookmark);
        } else {
            this.checkAddedNonNoteBookmark(monitor, addr, currentBookmark);
        }
    }

    private void checkAddedNoteBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        String myType = currentBookmark.getTypeString();
        String myCategory = currentBookmark.getCategory();
        String myComment = currentBookmark.getComment();
        Bookmark[] original = this.originalBookmarkMgr.getBookmarks(addr, myType);
        if (original.length > 1) {
            throw new AssertException("Error in CHECKED OUT program - Shouldn't be multiple notes at a single address. Address=" + addr.toString());
        }
        if (original.length == 0) {
            Bookmark[] latest = this.latestBookmarkMgr.getBookmarks(addr, myType);
            if (latest.length > 1) {
                throw new AssertException("Error in LATEST checked in program - Shouldn't be multiple notes at a single address. Address=" + addr.toString());
            }
            if (latest.length == 0) {
                this.merge(addr, myType, null, 4, monitor);
            } else if (latest.length == 1) {
                String latestCategory = latest[0].getCategory();
                String latestComment = latest[0].getComment();
                if (!myCategory.equals(latestCategory) || !myComment.equals(latestComment)) {
                    this.addConflict(addr, myType, null);
                }
            }
        }
    }

    private void checkAddedNonNoteBookmark(TaskMonitor monitor, Address addr, Bookmark currentBookmark) throws CancelledException {
        String myType = currentBookmark.getTypeString();
        String myCategory = currentBookmark.getCategory();
        String myComment = currentBookmark.getComment();
        Bookmark original = this.originalBookmarkMgr.getBookmark(addr, myType, myCategory);
        if (original == null) {
            Bookmark latest = this.latestBookmarkMgr.getBookmark(addr, myType, myCategory);
            if (latest == null) {
                this.merge(addr, myType, myCategory, 4, monitor);
            } else {
                String latestComment = latest.getComment();
                if (!myComment.equals(latestComment)) {
                    this.addConflict(addr, myType, myCategory);
                }
            }
        }
    }

    private void addConflict(Address address, String bookmarkType, String bookmarkCategory) {
        ArrayList<BookmarkUid> list = this.conflicts.get(address);
        if (list == null) {
            list = new ArrayList(1);
            this.conflicts.put(address, list);
        }
        list.add(new BookmarkUid(address, bookmarkType, bookmarkCategory));
        this.conflictSet.addRange(address, address);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictSet.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        ArrayList<BookmarkUid> list = this.conflicts.get(addr);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    VerticalChoicesPanel getConflictsPanel(Address address, String bookmarkType, String bookmarkCategory, ChangeListener changeListener) {
        Bookmark my;
        Bookmark latest;
        Bookmark original;
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
            this.conflictPanel.setTitle(this.getConflictType());
        } else {
            this.conflictPanel.clear();
        }
        if (bookmarkType.equals("Note")) {
            Bookmark[] originalMarks = this.originalBookmarkMgr.getBookmarks(address, bookmarkType);
            original = originalMarks.length > 0 ? originalMarks[0] : null;
            Bookmark[] latestMarks = this.latestBookmarkMgr.getBookmarks(address, bookmarkType);
            latest = latestMarks.length > 0 ? latestMarks[0] : null;
            Bookmark[] myMarks = this.myBookmarkMgr.getBookmarks(address, bookmarkType);
            my = myMarks.length > 0 ? myMarks[0] : null;
        } else {
            original = this.originalBookmarkMgr.getBookmark(address, bookmarkType, bookmarkCategory);
            latest = this.latestBookmarkMgr.getBookmark(address, bookmarkType, bookmarkCategory);
            my = this.myBookmarkMgr.getBookmark(address, bookmarkType, bookmarkCategory);
        }
        String text = "Bookmark conflict @ address :" + ConflictUtility.getAddressString(address);
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getBookmarkInfo(-1, null));
        this.conflictPanel.addRadioButtonRow(this.getBookmarkInfo(1, latest), "LatestVersionRB", 2, changeListener);
        this.conflictPanel.addRadioButtonRow(this.getBookmarkInfo(2, my), "CheckedOutVersionRB", 4, changeListener);
        this.conflictPanel.addInfoRow(this.getBookmarkInfo(3, original));
        return this.conflictPanel;
    }

    private String[] getBookmarkInfo(int version, Bookmark bookmark) {
        String[] info = new String[]{"", "", "", ""};
        if (version == 1) {
            info[0] = this.getChoice("Latest", bookmark);
        } else if (version == 2) {
            info[0] = this.getChoice("Checked Out", bookmark);
        } else if (version == 3) {
            info[0] = " 'Original' version";
        } else {
            return new String[]{"Option", "Type", "Category", "Description"};
        }
        if (bookmark != null) {
            info[1] = bookmark.getTypeString();
            info[2] = bookmark.getCategory();
            info[3] = bookmark.getComment();
        }
        return info;
    }

    private String getChoice(String version, Bookmark bookmark) {
        if (bookmark == null) {
            return "Remove as in '" + version + "' version";
        }
        return "Keep '" + version + "' version";
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        monitor.setMessage("Resolving Bookmark conflicts.");
        if (!this.hasConflict(addr)) {
            return;
        }
        boolean askUser = chosenConflictOption == 0;
        ArrayList<BookmarkUid> list = this.conflicts.get(addr);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            BookmarkUid bmuid = list.get(i);
            if (this.bookmarkChoice == 0 && askUser && this.mergeManager != null) {
                this.showMergePanel(listingPanel, bmuid.address, bmuid.bookmarkType, bmuid.bookmarkCategory, monitor);
                monitor.checkCancelled();
                continue;
            }
            int optionToUse = this.bookmarkChoice == 0 ? chosenConflictOption : this.bookmarkChoice;
            this.merge(bmuid.address, bmuid.bookmarkType, bmuid.bookmarkCategory, optionToUse, monitor);
        }
        this.resolvedSet.addRange(addr, addr);
    }

    private void merge(Address address, String bookmarkType, String bookmarkCategory, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.mergeBookmark(address, bookmarkType, bookmarkCategory, monitor);
        } else if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.mergeBookmark(address, bookmarkType, bookmarkCategory, monitor);
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.mergeBookmark(address, bookmarkType, bookmarkCategory, monitor);
        }
    }

    private void showMergePanel(final ListingMergePanel listingPanel, Address addr, String bookmarkType, String bookmarkCategory, TaskMonitor monitor) {
        this.currentAddress = addr;
        this.type = bookmarkType;
        this.category = bookmarkCategory;
        this.currentMonitor = monitor;
        try {
            final BookmarkMergeChangeListener changeListener = new BookmarkMergeChangeListener();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VerticalChoicesPanel panel = BookmarkMerger.this.getConflictsPanel(BookmarkMerger.this.currentAddress, BookmarkMerger.this.type, BookmarkMerger.this.category, changeListener);
                    boolean useForAll = BookmarkMerger.this.bookmarkChoice != 0;
                    BookmarkMerger.this.conflictPanel.setUseForAll(useForAll);
                    BookmarkMerger.this.conflictPanel.setConflictType("Bookmark");
                    listingPanel.setBottomComponent(panel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Address addressToPaint = BookmarkMerger.this.currentAddress;
                    listingPanel.clearAllBackgrounds();
                    listingPanel.paintAllBackgrounds((AddressSetView)new AddressSet(addressToPaint, addressToPaint));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictSet;
    }

    private class BookmarkUid {
        Address address;
        String bookmarkType;
        String bookmarkCategory;

        BookmarkUid(Address addr, String bookmarkType, String bookmarkCategory) {
            this.address = addr;
            this.bookmarkType = bookmarkType;
            this.bookmarkCategory = bookmarkCategory;
        }
    }

    private final class BookmarkMergeChangeListener
    implements ChangeListener {
        private BookmarkMergeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            BookmarkMerger.this.conflictOption = BookmarkMerger.this.conflictPanel.getSelectedOptions();
            if (BookmarkMerger.this.conflictOption == 0) {
                if (BookmarkMerger.this.mergeManager != null) {
                    BookmarkMerger.this.mergeManager.setApplyEnabled(false);
                }
                return;
            }
            if (BookmarkMerger.this.mergeManager != null) {
                BookmarkMerger.this.mergeManager.clearStatusText();
            }
            try {
                BookmarkMerger.this.merge(BookmarkMerger.this.currentAddress, BookmarkMerger.this.type, BookmarkMerger.this.category, BookmarkMerger.this.conflictOption, BookmarkMerger.this.currentMonitor);
            }
            catch (CancelledException e1) {
                BookmarkMerger.this.cancel();
                return;
            }
            if (BookmarkMerger.this.mergeManager != null) {
                BookmarkMerger.this.mergeManager.setApplyEnabled(true);
            }
        }
    }
}

