/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;

public class ArchiveFileChooser
extends GhidraFileChooser {
    public ArchiveFileChooser(Component component) {
        super(component);
        this.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"gdt"}, "Ghidra Data Type Files"));
        this.setApproveButtonText("Save As");
        this.setApproveButtonToolTipText("Save As");
    }

    public File promptUserForFile(String suggestedFileName) {
        File projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
        String lastNewArchivePath = Preferences.getProperty((String)"LastOpenedArchiveDirectory", null, (boolean)true);
        if (lastNewArchivePath != null) {
            projectDirectory = new File(lastNewArchivePath);
        }
        this.setCurrentDirectory(projectDirectory);
        String suggestedName = suggestedFileName + ".gdt";
        this.setSelectedFile(new File(projectDirectory, suggestedName));
        File file = this.getSelectedFile();
        if (file == null) {
            return null;
        }
        file = this.fixFilenameSuffix(file);
        Preferences.setProperty((String)"LastOpenedArchiveDirectory", (String)file.getParent());
        Preferences.store();
        return file;
    }

    private File fixFilenameSuffix(File file) {
        Object filename = file.getName();
        if (((String)filename).endsWith(".gdt")) {
            return file;
        }
        filename = (String)filename + ".gdt";
        return new File(file.getParentFile(), (String)filename);
    }
}

