/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.UndoRedoKeeper;
import docking.widgets.OptionDialog;
import docking.widgets.button.GButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.app.plugin.core.function.editor.FunctionSignatureTextField;
import ghidra.app.plugin.core.function.editor.FunctionVariableData;
import ghidra.app.plugin.core.function.editor.ModelChangeListener;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.app.plugin.core.function.editor.ParameterDataTypeCellEditor;
import ghidra.app.plugin.core.function.editor.ParameterTableModel;
import ghidra.app.plugin.core.function.editor.StorageTableCellEditor;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.cparser.C.CParserUtils;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class FunctionEditorDialog
extends DialogComponentProvider
implements ModelChangeListener {
    private FunctionEditorModel model;
    private DocumentListener nameFieldDocumentListener;
    private GTable parameterTable;
    private JTextField nameField;
    private JCheckBox varArgsCheckBox;
    private DataTypeManagerService service;
    private JCheckBox inLineCheckBox;
    private JCheckBox noReturnCheckBox;
    private JComboBox<String> callFixupComboBox;
    private JComboBox<String> callingConventionComboBox;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private ParameterTableModel paramTableModel;
    private ListSelectionListener selectionListener;
    private JCheckBox storageCheckBox;
    private JScrollPane scroll;
    private JPanel previewPanel;
    private FunctionSignatureTextField signatureTextField;
    private UndoRedoKeeper signatureFieldUndoRedoKeeper;
    private MyGlassPane glassPane;
    private JPanel centerPanel;

    public FunctionEditorDialog(DataTypeManagerService service, Function function) {
        this(new FunctionEditorModel(service, function));
    }

    public FunctionEditorDialog(FunctionEditorModel model) {
        super(FunctionEditorDialog.createTitle(model.getFunction()));
        this.service = model.getDataTypeManagerService();
        this.setRememberLocation(true);
        this.setRememberSize(true);
        this.setHelpLocation(new HelpLocation("FunctionPlugin", "Edit_Function"));
        this.model = model;
        model.setModelChangeListener(this);
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.glassPane = new MyGlassPane();
        this.dataChanged();
    }

    private static String createTitle(Function function) {
        StringBuilder strBuilder = new StringBuilder();
        if (function.isExternal()) {
            strBuilder.append("Edit External Function");
            ExternalLocation extLoc = function.getExternalLocation();
            Address addr = extLoc.getAddress();
            if (addr != null) {
                strBuilder.append(" at ");
                strBuilder.append(addr.toString());
            }
        } else {
            Function thunkedFunction = function.getThunkedFunction(false);
            if (thunkedFunction != null) {
                strBuilder.append("Edit Thunk Function at ");
                strBuilder.append(function.getEntryPoint().toString());
            } else {
                strBuilder.append("Edit Function at ");
                strBuilder.append(function.getEntryPoint().toString());
            }
        }
        return strBuilder.toString();
    }

    protected void dialogShown() {
        this.signatureTextField.requestFocus();
        Swing.runLater(() -> {
            int start = this.model.getFunctionNameStartPosition();
            int end = this.model.getNameString().length();
            this.signatureTextField.setCaretPosition(end);
            this.signatureTextField.setSelectionStart(start);
            this.signatureTextField.setSelectionEnd(start + end);
            this.signatureFieldUndoRedoKeeper.clear();
        });
    }

    protected void okCallback() {
        if (this.model.isInParsingMode()) {
            try {
                this.model.parseSignatureFieldText();
            }
            catch (Exception e) {
                this.handleParseException(e);
                this.signatureTextField.requestFocus();
                return;
            }
        }
        if (this.model.apply()) {
            this.close();
        }
    }

    public void close() {
        this.model.dispose();
        super.close();
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.buildPreview(), "North");
        panel.add((Component)this.buildCenterPanel(), "Center");
        return panel;
    }

    private JComponent buildCenterPanel() {
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.centerPanel.add(this.buildAttributePanel(), "North");
        this.centerPanel.add(this.buildTable(), "Center");
        this.centerPanel.add(this.buildBottomPanel(), "South");
        return this.centerPanel;
    }

    private Component buildBottomPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        Border b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        JComponent callFixupField = this.createCallFixupComboPanel();
        callFixupField.setBorder(BorderFactory.createTitledBorder(b, "Call Fixup:"));
        panel.add((Component)callFixupField, "West");
        Function thunkedFunction = this.model.getFunction().getThunkedFunction(false);
        if (thunkedFunction != null) {
            JPanel thunkedPanel = this.createThunkedFunctionTextPanel(thunkedFunction);
            thunkedPanel.setBorder(BorderFactory.createTitledBorder(b, "Thunked Function:"));
            panel.add((Component)thunkedPanel, "Center");
        } else {
            panel.add((Component)new JPanel(), "Center");
        }
        return panel;
    }

    private JPanel createThunkedFunctionTextPanel(Function thunkedFunction) {
        JPanel thunkedPanel = new JPanel(new BorderLayout());
        JTextField thunkedText = new JTextField(thunkedFunction.getName(true));
        thunkedText.setEditable(false);
        DockingUtils.setTransparent((JComponent)thunkedText);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        thunkedText.setBorder(border);
        thunkedText.setForeground((Color)ListingColors.FunctionColors.THUNK);
        thunkedPanel.add(thunkedText);
        return thunkedPanel;
    }

    private JComponent buildPreview() {
        this.previewPanel = new JPanel(new BorderLayout());
        VerticalScrollablePanel verticalScrollPanel = new VerticalScrollablePanel();
        verticalScrollPanel.add(this.createSignatureTextPanel());
        this.scroll = new JScrollPane(verticalScrollPanel);
        this.scroll.setBorder(null);
        this.scroll.setOpaque(true);
        this.scroll.setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.scroll.getViewport().setBackground(GThemeDefaults.Colors.Palette.NO_COLOR);
        this.scroll.getViewport().setBackground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.previewPanel.add((Component)this.scroll, "Center");
        this.previewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.scroll.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FunctionEditorDialog.this.signatureTextField.setCaretPosition(FunctionEditorDialog.this.signatureTextField.getText().length());
                FunctionEditorDialog.this.signatureTextField.requestFocus();
            }
        });
        return this.previewPanel;
    }

    private JComponent createSignatureTextPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.signatureTextField = new FunctionSignatureTextField();
        this.signatureFieldUndoRedoKeeper = DockingUtils.installUndoRedo((JTextComponent)this.signatureTextField);
        Font font = this.signatureTextField.getFont();
        this.signatureTextField.setFont(font.deriveFont(18.0f));
        panel.add(this.signatureTextField);
        this.signatureTextField.setEscapeListener(e -> {
            if (!this.model.hasChanges()) {
                this.cancelCallback();
                return;
            }
            if (!this.promptToAbortChanges()) {
                return;
            }
            this.model.resetSignatureTextField();
        });
        this.signatureTextField.setActionListener(e -> {
            try {
                if (this.model.isInParsingMode()) {
                    this.model.parseSignatureFieldText();
                    return;
                }
            }
            catch (Exception ex) {
                this.handleParseException(ex);
                return;
            }
            if (this.model.isValid()) {
                this.okCallback();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        ActionListener tabListener = e -> {
            block2: {
                try {
                    this.model.parseSignatureFieldText();
                }
                catch (Exception ex) {
                    if (this.handleParseException(ex)) break block2;
                    return;
                }
            }
            this.nameField.requestFocus();
        };
        this.signatureTextField.setTabListener(tabListener);
        this.signatureTextField.setChangeListener(e -> this.model.setSignatureFieldText(this.signatureTextField.getText()));
        return panel;
    }

    protected boolean handleParseException(Exception exception) {
        String message = exception.getMessage();
        String details = CParserUtils.handleParseProblem(exception, this.signatureTextField.getText());
        if (details != null) {
            message = details;
        }
        if (this.doPromptToAbortChanges(message)) {
            this.model.resetSignatureTextField();
            return true;
        }
        return false;
    }

    private boolean promptToAbortChanges() {
        return this.doPromptToAbortChanges("");
    }

    private boolean doPromptToAbortChanges(String message) {
        int result;
        if (!StringUtils.isBlank((CharSequence)message)) {
            message = (String)message + "<BR><BR>";
        }
        return (result = OptionDialog.showOptionNoCancelDialog((Component)this.rootPanel, (String)"Invalid Function Signature", (String)(message = HTMLUtilities.wrapAsHTML((String)((String)message + "<CENTER><B>Do you want to continue editing or abort your changes?</B></CENTER>"))), (String)"Continue Editing", (String)"Abort Changes", (int)0)) == 2;
    }

    private Component buildAttributePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 15, 15));
        JPanel leftPanel = new JPanel((LayoutManager)new PairLayout(4, 8));
        leftPanel.add((Component)new GLabel("Function Name:"));
        leftPanel.add(this.createNameField());
        leftPanel.add((Component)new GLabel("Calling Convention"));
        leftPanel.add(this.createCallingConventionCombo());
        leftPanel.setBorder(BorderFactory.createEmptyBorder(14, 0, 0, 10));
        panel.add((Component)leftPanel, "Center");
        panel.add(this.buildTogglePanel(), "East");
        return panel;
    }

    private Component buildTogglePanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        this.varArgsCheckBox = new GCheckBox("Varargs");
        this.varArgsCheckBox.addItemListener(e -> this.model.setHasVarArgs(this.varArgsCheckBox.isSelected()));
        panel.add(this.varArgsCheckBox);
        this.inLineCheckBox = new GCheckBox("In Line");
        panel.add(this.inLineCheckBox);
        this.inLineCheckBox.addItemListener(e -> this.model.setIsInLine(this.inLineCheckBox.isSelected()));
        this.inLineCheckBox.setEnabled(this.model.isInlineAllowed());
        this.noReturnCheckBox = new GCheckBox("No Return");
        this.noReturnCheckBox.addItemListener(e -> this.model.setNoReturn(this.noReturnCheckBox.isSelected()));
        this.storageCheckBox = new GCheckBox("Use Custom Storage");
        this.storageCheckBox.addItemListener(e -> this.model.setUseCustomizeStorage(this.storageCheckBox.isSelected()));
        panel.add(this.noReturnCheckBox);
        panel.add(this.storageCheckBox);
        panel.setBorder(BorderFactory.createTitledBorder("Function Attributes:"));
        return panel;
    }

    private JComponent createCallingConventionCombo() {
        List<String> callingConventionNames = this.model.getCallingConventionNames();
        String[] names = new String[callingConventionNames.size()];
        this.callingConventionComboBox = new GComboBox((Object[])callingConventionNames.toArray(names));
        this.callingConventionComboBox.setSelectedItem(this.model.getCallingConventionName());
        this.callingConventionComboBox.addItemListener(e -> this.model.setCallingConventionName((String)this.callingConventionComboBox.getSelectedItem()));
        return this.callingConventionComboBox;
    }

    private JComponent createCallFixupComboPanel() {
        JPanel panel = new JPanel();
        this.callFixupComboBox = new GComboBox();
        String[] callFixupNames = this.model.getCallFixupNames();
        this.callFixupComboBox.addItem("-NONE-");
        if (callFixupNames.length != 0) {
            this.callFixupComboBox.setToolTipText("Select call-fixup as defined by compiler specification");
            for (String element : callFixupNames) {
                this.callFixupComboBox.addItem(element);
            }
            this.callFixupComboBox.addItemListener(e -> this.model.setCallFixupName((String)this.callFixupComboBox.getSelectedItem()));
        } else {
            this.callFixupComboBox.setToolTipText("No call-fixups defined by compiler specification");
            this.callFixupComboBox.setEnabled(false);
        }
        panel.add(this.callFixupComboBox);
        return panel;
    }

    private Component buildTable() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Function Variables"));
        this.paramTableModel = new ParameterTableModel(this.model);
        this.parameterTable = new ParameterTable(this.paramTableModel);
        this.selectionListener = e -> this.model.setSelectedParameterRow(this.parameterTable.getSelectedRows());
        JScrollPane tableScroll = new JScrollPane((Component)this.parameterTable);
        panel.add((Component)tableScroll, "Center");
        panel.add(this.buildButtonPanel(), "East");
        return panel;
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addButton = new GButton(Icons.ADD_ICON);
        this.removeButton = new GButton(Icons.DELETE_ICON);
        this.upButton = new GButton((Icon)new GIcon("icon.up"));
        this.downButton = new GButton((Icon)new GIcon("icon.down"));
        this.addButton.setToolTipText("Add parameter");
        this.removeButton.setToolTipText("Delete selected parameters");
        this.upButton.setToolTipText("Move selected parameter up");
        this.downButton.setToolTipText("Move selected parameter down");
        this.addButton.addActionListener(e -> this.model.addParameter());
        this.removeButton.addActionListener(e -> this.model.removeParameters());
        this.upButton.addActionListener(e -> this.model.moveSelectedParameterUp());
        this.downButton.addActionListener(e -> this.model.moveSelectedParameterDown());
        panel.add(this.addButton);
        panel.add(this.removeButton);
        panel.add(new JSeparator());
        panel.add(this.upButton);
        panel.add(this.downButton);
        return panel;
    }

    private JComponent createNameField() {
        this.nameField = new JTextField();
        this.nameFieldDocumentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FunctionEditorDialog.this.model.setName(FunctionEditorDialog.this.nameField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FunctionEditorDialog.this.model.setName(FunctionEditorDialog.this.nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FunctionEditorDialog.this.model.setName(FunctionEditorDialog.this.nameField.getText());
            }
        };
        this.nameField.getDocument().addDocumentListener(this.nameFieldDocumentListener);
        return this.nameField;
    }

    @Override
    public void dataChanged() {
        if (this.model.isInParsingMode()) {
            this.setGlassPane(this.glassPane);
            this.glassPane.setVisible(true);
            this.updateStatusText();
        } else {
            this.glassPane.setVisible(false);
            this.updateNameField();
            this.updateCallingConventionCombo();
            this.updatePreviewField();
            this.updageVarArgs();
            this.updateStatusText();
            this.updateInLineCheckbox();
            this.updateNoReturnCheckbox();
            this.updateCallFixupCombo();
            this.updateOkButton();
            this.updateParamTable();
            this.updateTableSelection();
            this.updateTableButtonEnablement();
            this.updateStorageEditingEnabled();
        }
    }

    private void updateStorageEditingEnabled() {
        boolean canCustomizeStorage = this.model.canCustomizeStorage();
        if (this.storageCheckBox.isSelected() != canCustomizeStorage) {
            this.storageCheckBox.setSelected(canCustomizeStorage);
        }
        this.paramTableModel.setAllowStorageEditing(canCustomizeStorage);
    }

    private void updateTableButtonEnablement() {
        this.removeButton.setEnabled(this.model.canRemoveParameters());
        this.upButton.setEnabled(this.model.canMoveParameterUp());
        this.downButton.setEnabled(this.model.canMoveParameterDown());
    }

    private void updateTableSelection() {
        int[] selectedRows = this.model.getSelectedParameterRows();
        if (!Arrays.equals(selectedRows, this.parameterTable.getSelectedRows())) {
            ListSelectionModel selectionModel = this.parameterTable.getSelectionModel();
            selectionModel.removeListSelectionListener(this.selectionListener);
            this.parameterTable.clearSelection();
            for (int i : selectedRows) {
                this.parameterTable.addRowSelectionInterval(i, i);
            }
            this.parameterTable.scrollToSelectedRow();
            selectionModel.addListSelectionListener(this.selectionListener);
        }
    }

    private void updateParamTable() {
        List<ParamInfo> parameterList = this.model.getParameters();
        ListSelectionModel selectionModel = this.parameterTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.selectionListener);
        this.paramTableModel.setParameters(parameterList, this.model.getFormalReturnType(), this.model.getReturnStorage());
        selectionModel.addListSelectionListener(this.selectionListener);
    }

    private void updateCallFixupCombo() {
        String callFixupName = this.model.getCallFixupName();
        if (!this.callFixupComboBox.getSelectedItem().equals(callFixupName)) {
            this.callFixupComboBox.setSelectedItem(callFixupName);
            if (!this.callFixupComboBox.getSelectedItem().equals(callFixupName)) {
                this.setStatusText("Invalid Call-Fixup '" + callFixupName + "' will be removed!");
            }
        }
    }

    private void updateCallingConventionCombo() {
        String callingConventionName = this.model.getCallingConventionName();
        if (!this.callingConventionComboBox.getSelectedItem().equals(callingConventionName)) {
            this.callingConventionComboBox.setSelectedItem(callingConventionName);
            if (!this.callingConventionComboBox.getSelectedItem().equals(callingConventionName)) {
                this.setStatusText("Invalid Callinging Convention '" + callingConventionName + "' ignored!");
            }
        }
    }

    private void updateInLineCheckbox() {
        boolean inLine = this.model.isInLine();
        if (this.inLineCheckBox.isSelected() != inLine) {
            this.inLineCheckBox.setSelected(inLine);
        }
    }

    private void updateNoReturnCheckbox() {
        boolean noReturn = this.model.isNoReturn();
        if (this.noReturnCheckBox.isSelected() != noReturn) {
            this.noReturnCheckBox.setSelected(noReturn);
        }
    }

    private void updateOkButton() {
        this.setOkEnabled(this.model.isValid());
    }

    private void updateStatusText() {
        MessageType messageType = this.model.isValid() ? MessageType.WARNING : MessageType.ERROR;
        messageType = this.model.isInParsingMode() ? MessageType.INFO : messageType;
        this.setStatusText(this.model.getStatusText(), messageType);
    }

    private void updageVarArgs() {
        if (this.varArgsCheckBox.isSelected() != this.model.hasVarArgs()) {
            this.varArgsCheckBox.setSelected(this.model.hasVarArgs());
        }
    }

    private void updateNameField() {
        this.nameField.getDocument().removeDocumentListener(this.nameFieldDocumentListener);
        int caretPosition = this.nameField.getCaretPosition();
        String name = this.model.getName();
        this.nameField.setText(name);
        if (caretPosition < name.length()) {
            this.nameField.setCaretPosition(caretPosition);
        }
        this.nameField.getDocument().addDocumentListener(this.nameFieldDocumentListener);
    }

    private void updatePreviewField() {
        String preview = this.model.getFunctionSignatureTextFromModel();
        int caretPosition = this.signatureTextField.getCaretPosition();
        String oldText = this.signatureTextField.getText();
        if (!preview.equals(oldText)) {
            this.signatureTextField.setText(preview);
        }
        if (!this.model.hasValidName()) {
            this.signatureTextField.setError(this.model.getFunctionNameStartPosition(), this.model.getNameString().length());
        }
        if (caretPosition < preview.length()) {
            this.signatureTextField.setCaretPosition(caretPosition);
        }
    }

    @Override
    public void tableRowsChanged() {
        TableCellEditor cellEditor = this.parameterTable.getCellEditor();
        if (cellEditor != null && !cellEditor.stopCellEditing()) {
            cellEditor.cancelCellEditing();
        }
    }

    private class MyGlassPane
    extends JComponent {
        MyGlassPane() {
            GlassPaneMouseListener listener = new GlassPaneMouseListener();
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.setVisible(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Rectangle bounds = FunctionEditorDialog.this.centerPanel.getBounds();
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), 0.4f);
            Composite originalComposite = g2d.getComposite();
            g2d.setComposite(alphaComposite);
            g.setColor((Color)GThemeDefaults.Colors.BACKGROUND);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g2d.setComposite(originalComposite);
            super.paintComponent(g);
        }
    }

    private class VerticalScrollablePanel
    extends JPanel
    implements Scrollable {
        public VerticalScrollablePanel() {
            super(new BorderLayout());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(10, 74);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class ParameterTable
    extends GTable {
        private FocusListener focusListener;

        ParameterTable(ParameterTableModel model) {
            super((TableModel)((Object)model));
            this.focusListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    Component component = e.getComponent();
                    Component opposite = e.getOppositeComponent();
                    if (opposite == null) {
                        return;
                    }
                    if (!SwingUtilities.isDescendingFrom(opposite, component)) {
                        component.removeFocusListener(this);
                        if (ParameterTable.this.cellEditor != null) {
                            ParameterTable.this.cellEditor.stopCellEditing();
                        }
                    } else {
                        opposite.removeFocusListener(this);
                        opposite.addFocusListener(this);
                    }
                }
            };
        }

        public void setUI(TableUI ui) {
            super.setUI(ui);
            this.getSelectionModel().addListSelectionListener(FunctionEditorDialog.this.selectionListener);
            this.setPreferredScrollableViewportSize(new Dimension(600, 100));
            this.setDefaultEditor(DataType.class, new ParameterDataTypeCellEditor(FunctionEditorDialog.this, FunctionEditorDialog.this.service));
            this.setDefaultRenderer(DataType.class, (TableCellRenderer)((Object)new ParameterDataTypeCellRenderer()));
            this.setDefaultEditor(VariableStorage.class, new StorageTableCellEditor(FunctionEditorDialog.this.model));
            this.setDefaultRenderer(VariableStorage.class, (TableCellRenderer)((Object)new VariableStorageCellRenderer()));
            this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new VariableStringCellRenderer()));
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component component = super.prepareEditor(editor, row, column);
            if (component != null && !"Storage".equals(this.getColumnName(column))) {
                component.removeFocusListener(this.focusListener);
                component.addFocusListener(this.focusListener);
            }
            return component;
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            if (row < 0 || row >= this.getRowCount() || column < 1 || column >= this.getColumnCount()) {
                return false;
            }
            boolean isEditable = super.editCellAt(row, column, e);
            if (!isEditable && (e instanceof KeyEvent || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 2)) {
                FunctionVariableData rowData = (FunctionVariableData)FunctionEditorDialog.this.paramTableModel.getRowObject(row);
                if (rowData.getStorage().isAutoStorage()) {
                    FunctionEditorDialog.this.setStatusText("Auto-parameters may not be modified");
                } else if (row == 0 && "Name".equals(this.getColumnName(column))) {
                    FunctionEditorDialog.this.setStatusText("Return name may not be modified");
                } else if ("Storage".equals(this.getColumnName(column))) {
                    boolean blockVoidStorageEdit;
                    boolean bl = blockVoidStorageEdit = rowData.getIndex() == null && VoidDataType.isVoidDataType((DataType)rowData.getFormalDataType());
                    if (!blockVoidStorageEdit) {
                        FunctionEditorDialog.this.setStatusText("Enable 'Use Custom Storage' to allow editing of Parameter and Return Storage");
                    } else {
                        FunctionEditorDialog.this.setStatusText("Void return storage may not be modified");
                    }
                }
            }
            return isEditable;
        }
    }

    private class GlassPaneMouseListener
    implements MouseListener,
    MouseMotionListener {
        private GlassPaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.processEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.processEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.processEvent(e)) {
                try {
                    FunctionEditorDialog.this.model.parseSignatureFieldText();
                }
                catch (Exception ex) {
                    FunctionEditorDialog.this.handleParseException(ex);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private boolean processEvent(MouseEvent e) {
            JDialog window = (JDialog)WindowUtilities.windowForComponent((Component)e.getComponent());
            Component comp = SwingUtilities.getDeepestComponentAt(window.getContentPane(), e.getX(), e.getY());
            if (comp == FunctionEditorDialog.this.signatureTextField || comp == FunctionEditorDialog.this.cancelButton || comp == FunctionEditorDialog.this.okButton) {
                MouseEvent convertedMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, comp);
                comp.dispatchEvent(convertedMouseEvent);
                return true;
            }
            return comp == FunctionEditorDialog.this.scroll.getViewport();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.processEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.processEvent(e);
        }
    }

    private class VariableStringCellRenderer
    extends GTableCellRenderer {
        private VariableStringCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            boolean isSelected = data.isSelected();
            String name = (String)value;
            ParameterTableModel tableModel = (ParameterTableModel)((Object)table.getModel());
            if (!tableModel.isCellEditable(row, column)) {
                this.setForeground(this.getUneditableForegroundColor(isSelected));
            } else if (isSelected) {
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForegroundColor(table, table.getModel(), value);
            }
            this.setText(name);
            return this;
        }
    }

    private class VariableStorageCellRenderer
    extends GTableCellRenderer {
        private VariableStorageCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            boolean isSelected = data.isSelected();
            VariableStorage storage = (VariableStorage)value;
            if (storage != null) {
                boolean isInvalidStorage;
                ParameterTableModel tableModel = (ParameterTableModel)((Object)table.getModel());
                FunctionVariableData rowData = (FunctionVariableData)tableModel.getRowObject(row);
                boolean bl = isInvalidStorage = !storage.isValid() || rowData.getFormalDataType().getLength() != storage.size();
                if (isInvalidStorage) {
                    this.setForeground(this.getErrorForegroundColor(isSelected));
                    this.setToolTipText("Invalid Parameter Storage");
                } else {
                    this.setForeground(isSelected ? table.getSelectionForeground() : GThemeDefaults.Colors.FOREGROUND);
                    this.setToolTipText("");
                }
                this.setText(storage.toString());
            } else {
                this.setForeground(isSelected ? table.getSelectionForeground() : GThemeDefaults.Colors.FOREGROUND);
                this.setText("");
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class ParameterDataTypeCellRenderer
    extends GTableCellRenderer {
        private ParameterDataTypeCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Color color;
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            boolean isSelected = data.isSelected();
            ParameterTableModel tableModel = (ParameterTableModel)((Object)table.getModel());
            DataType dataType = (DataType)value;
            Color color2 = color = isSelected ? table.getSelectionForeground() : table.getForeground();
            if (!tableModel.isCellEditable(row, column)) {
                color = this.getUneditableForegroundColor(isSelected);
            }
            if (dataType != null) {
                this.setText(dataType.getName());
                if (dataType.isNotYetDefined()) {
                    color = this.getErrorForegroundColor(isSelected);
                }
                String toolTipText = ToolTipUtils.getToolTipText(dataType);
                String headerText = "<HTML><b>" + HTMLUtilities.friendlyEncodeHTML((String)dataType.getPathName()) + "</b><BR>";
                toolTipText = toolTipText.replace("<HTML>", headerText);
                this.setToolTipText(toolTipText);
            } else {
                this.setText("");
                this.setToolTipText(null);
            }
            this.setForeground(color);
            return this;
        }
    }
}

