/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFUtil;
import ghidra.app.util.bin.format.dwarf4.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf4.next.DIEAMonitoredIterator;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeImporter;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFNameInfo;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf4.next.DataTypeGraphComparator;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utility.function.Dummy;

public class DWARFDataTypeManager {
    private final DataTypeManager dataTypeManager;
    private final DataTypeManager builtInDTM;
    private final DWARFProgram prog;
    private final DWARFImportSummary importSummary;
    private final DWARFImportOptions importOptions;
    private Map<Long, DataTypePath> offsetToDTP = new HashMap<Long, DataTypePath>();
    private Map<DataTypePath, DWARFSourceInfo> dtpToSourceInfo = new HashMap<DataTypePath, DWARFSourceInfo>();
    private Map<String, DataType> baseDataTypes = new HashMap<String, DataType>();
    private static final String BASETYPE_MANGLE_PREFIX = "__MANGLE__";
    private DataType baseDataTypeVoid;
    private DataType baseDataTypeNullPtr;
    private DataType baseDataTypeBool;
    private DataType baseDataTypeChar;
    private DataType baseDataTypeUchar;
    private DataType[] baseDataTypeUntyped;
    private DataType[] baseDataTypeChars;
    private DataType baseDataTypeUndefined1;
    private static final Pattern FIXED_SIZED_TYPE_NAME_PATTERN = Pattern.compile("\\D+(8|16|32|64|128)\\D*");

    public DWARFDataTypeManager(DWARFProgram prog, DataTypeManager dataTypeManager) {
        this.prog = prog;
        this.dataTypeManager = dataTypeManager;
        this.builtInDTM = BuiltInDataTypeManager.getDataTypeManager();
        this.importSummary = prog.getImportSummary();
        this.importOptions = prog.getImportOptions();
        this.initBaseDataTypes();
    }

    public DataType doGetDataType(DIEAggregate diea) throws IOException, DWARFExpressionException {
        Swing.runNow((Runnable)Dummy.runnable());
        DWARFDataTypeImporter ddtImporter = new DWARFDataTypeImporter(this.prog, this);
        DWARFDataTypeImporter.DWARFDataType pre = ddtImporter.getDataType(diea, null);
        if (pre == null) {
            return null;
        }
        DataType post = this.dataTypeManager.resolve(pre.dataType, (DataTypeConflictHandler)DWARFDataTypeConflictHandler.INSTANCE);
        DataTypeGraphComparator.compare(pre.dataType, post, (dt1, dt2) -> {
            DWARFDataTypeImporter.DWARFDataType currentDDT = ddtImporter.getDDTByInstance(dt1);
            if (currentDDT != null) {
                if (currentDDT.dataType == dt1) {
                    for (Long offset : currentDDT.offsets) {
                        this.cacheOffsetToDataTypeMapping(offset, dt2);
                    }
                }
                this.saveDWARFSourceInfo(dt2, currentDDT.dsi);
            }
            return true;
        });
        this.cacheOffsetToDataTypeMapping(diea.getOffset(), post);
        this.saveDWARFSourceInfo(post, pre.dsi);
        return post;
    }

    public void addDataType(long offset, DataType dataType, DWARFSourceInfo dsi) {
        this.cacheOffsetToDataTypeMapping(offset, dataType);
        this.saveDWARFSourceInfo(dataType, dsi);
    }

    private void saveDWARFSourceInfo(DataType dt, DWARFSourceInfo dsi) {
        if (dsi != null && this.isGoodDWARFSourceInfo(dsi) && !this.dtpToSourceInfo.containsKey(dt.getDataTypePath())) {
            this.dtpToSourceInfo.put(dt.getDataTypePath(), dsi);
        }
    }

    public List<DataTypePath> getImportedTypes() {
        return new ArrayList<DataTypePath>(this.dtpToSourceInfo.keySet());
    }

    public DWARFSourceInfo getSourceInfo(DataType dataType) {
        return this.dtpToSourceInfo.get(dataType.getDataTypePath());
    }

    private boolean isGoodDWARFSourceInfo(DWARFSourceInfo dsi) {
        return dsi.getFilename() != null && !dsi.getFilename().isEmpty() && !dsi.getFilename().contains("built-in");
    }

    private void cacheOffsetToDataTypeMapping(long dieOffset, DataType dt) {
        DataTypePath dtp = dt.getDataTypePath();
        DataTypePath prevDTP = this.offsetToDTP.get(dieOffset);
        if (prevDTP != null) {
            if (prevDTP.equals((Object)dtp)) {
                return;
            }
            this.importSummary.typeRemappings.add(prevDTP + " -> " + dtp);
        }
        this.offsetToDTP.put(dieOffset, dtp);
    }

    public DataType getDataType(DIEAggregate diea, DataType defaultValue) {
        if (diea == null) {
            return defaultValue;
        }
        DataType result = null;
        DataTypePath dtp = this.offsetToDTP.get(diea.getOffset());
        if (dtp != null) {
            result = this.dataTypeManager.getDataType(dtp);
        }
        if (result == null) {
            try {
                result = this.doGetDataType(diea);
            }
            catch (DWARFExpressionException | IOException e) {
                Msg.error((Object)this, (Object)("Problem while retrieving data type in DIE " + diea.getOffset()), (Throwable)e);
                Msg.error((Object)this, (Object)("DIE info: " + diea.toString()));
            }
        }
        return result != null ? result : defaultValue;
    }

    public DataType getDataType(long dieOffset, DataType defaultValue) {
        DataTypePath dtp = this.offsetToDTP.get(dieOffset);
        DataType result = dtp != null ? this.dataTypeManager.getDataType(dtp) : null;
        return result != null ? result : defaultValue;
    }

    public <T extends DataType> T getSpecificDataType(DIEAggregate diea, Class<T> dataTypeClazz) {
        DataType dt = this.getDataType(diea, null);
        if (dt != null && dataTypeClazz != null && dataTypeClazz.isInstance(dt)) {
            return (T)((DataType)dataTypeClazz.cast(dt));
        }
        return null;
    }

    public DataType getDataTypeForVariable(DIEAggregate diea) {
        DataType type = this.getDataType(diea, this.getVoidType());
        if (type instanceof FunctionDefinition) {
            type = this.getPtrTo(type);
        }
        return type;
    }

    public DataType getPtrTo(DataType dt) {
        return this.dataTypeManager.getPointer(dt);
    }

    public DataType getPtrTo(DataType dt, int ptrSize) {
        return this.dataTypeManager.getPointer(dt, ptrSize);
    }

    public Iterable<DataType> forAllConflicts(DataTypePath dtp) {
        Category cat = this.dataTypeManager.getCategory(dtp.getCategoryPath());
        List list = cat != null ? cat.getDataTypesByBaseName(dtp.getDataTypeName()) : List.of();
        return list;
    }

    private DataType findGhidraType(String name) {
        DataType dt = this.dataTypeManager.getDataType(CategoryPath.ROOT, name);
        if (dt == null && (dt = this.builtInDTM.getDataType(CategoryPath.ROOT, name)) != null) {
            dt = dt.clone(this.dataTypeManager);
        }
        return dt;
    }

    private DataType findMatchingDataTypeBySize(DataType[] dtList, int size) {
        for (DataType dt : dtList) {
            if (dt.getLength() != size) continue;
            return dt;
        }
        return null;
    }

    public DataType getOffsetType(int size) {
        return this.findMatchingDataTypeBySize(this.baseDataTypeUntyped, size);
    }

    public DataType getVoidType() {
        return this.baseDataTypeVoid;
    }

    public DataType getUndefined1Type() {
        return this.baseDataTypeUndefined1;
    }

    public DataType getBaseType(String name) {
        DataType dt = this.baseDataTypes.get(name);
        return dt;
    }

    private boolean isEncodingCompatible(int requestedDwarfEncoding, DataType dt) {
        AbstractIntegerDataType aidt = dt instanceof AbstractIntegerDataType ? (AbstractIntegerDataType)dt : null;
        switch (requestedDwarfEncoding) {
            case 5: {
                return aidt == null || aidt.isSigned();
            }
            case 7: {
                return aidt == null || !aidt.isSigned();
            }
        }
        return true;
    }

    public DataType getBaseType(String name, int dwarfSize, int dwarfEncoding, boolean isBigEndian, boolean isExplictSize) {
        DataType dt = null;
        String mangledName = null;
        if (name != null) {
            dt = this.baseDataTypes.get(name);
            if (dt != null && dt.getAlignedLength() == dwarfSize && this.isEncodingCompatible(dwarfEncoding, dt)) {
                return dt;
            }
            mangledName = name + this.mangleDataTypeInfo(dwarfSize, dwarfEncoding);
            dt = this.baseDataTypes.get(mangledName);
            if (dt != null) {
                return dt;
            }
        }
        switch (dwarfEncoding) {
            case 1: {
                DataType dataType = this.baseDataTypeVoid;
                break;
            }
            case 2: {
                DataType dataType;
                if (dwarfSize == 1) {
                    dataType = this.baseDataTypeBool;
                    break;
                }
                dataType = null;
                break;
            }
            case 4: {
                DataType dataType = AbstractFloatDataType.getFloatDataType((int)dwarfSize, (DataTypeManager)this.getCorrectDTMForFixedLengthTypes(name, dwarfSize, isExplictSize));
                break;
            }
            case 5: {
                DataType dataType = AbstractIntegerDataType.getSignedDataType((int)dwarfSize, (DataTypeManager)this.getCorrectDTMForFixedLengthTypes(name, dwarfSize, isExplictSize));
                break;
            }
            case 7: {
                DataType dataType = AbstractIntegerDataType.getUnsignedDataType((int)dwarfSize, (DataTypeManager)this.getCorrectDTMForFixedLengthTypes(name, dwarfSize, isExplictSize));
                break;
            }
            case 6: {
                DataType dataType = this.baseDataTypeChar;
                break;
            }
            case 8: {
                DataType dataType = this.baseDataTypeUchar;
                break;
            }
            case 16: {
                DataType dataType = this.findMatchingDataTypeBySize(this.baseDataTypeChars, dwarfSize);
                break;
            }
            default: {
                DataType dataType = dt = null;
            }
        }
        if (dt == null) {
            dt = this.findMatchingDataTypeBySize(this.baseDataTypeUntyped, dwarfSize);
        }
        if (dt == null) {
            dt = new ArrayDataType(DataType.DEFAULT, dwarfSize, -1, this.dataTypeManager);
        }
        if (name != null) {
            dt = new TypedefDataType(this.prog.getRootDNI().asCategoryPath(), name, dt, this.dataTypeManager);
            dt = this.dataTypeManager.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.baseDataTypes.put(mangledName, dt);
        }
        return dt;
    }

    private DataTypeManager getCorrectDTMForFixedLengthTypes(String name, int dwarfSize, boolean predeterminedHasExplictSize) {
        int typenameExplicitSize;
        boolean usedFixedSizeType = predeterminedHasExplictSize || this.importOptions.isSpecialCaseSizedBaseTypes() && (typenameExplicitSize = this.getExplicitSizeFromTypeName(name)) != -1 && typenameExplicitSize / 8 == dwarfSize;
        return usedFixedSizeType ? null : this.dataTypeManager;
    }

    private String mangleDataTypeInfo(int dwarfLength, int dwarfEncoding) {
        return String.format("%s_%d_%d", BASETYPE_MANGLE_PREFIX, dwarfLength, dwarfEncoding);
    }

    private void initBaseDataTypes() {
        this.baseDataTypeVoid = this.findGhidraType("void");
        this.baseDataTypes.put("void", this.baseDataTypeVoid);
        this.baseDataTypeUndefined1 = this.findGhidraType("undefined1");
        this.baseDataTypes.put("undefined1", this.baseDataTypeUndefined1);
        this.baseDataTypeNullPtr = this.dataTypeManager.resolve((DataType)new PointerDataType(this.baseDataTypeVoid, this.dataTypeManager), DataTypeConflictHandler.DEFAULT_HANDLER);
        this.baseDataTypes.put("nullptr", this.baseDataTypeNullPtr);
        this.baseDataTypes.put("decltype(nullptr)", this.baseDataTypeNullPtr);
        DataType byteDT = this.findGhidraType("byte");
        DataType wordDT = this.findGhidraType("word");
        DataType dwordDT = this.findGhidraType("dword");
        DataType qwordDT = this.findGhidraType("qword");
        this.baseDataTypeUntyped = new DataType[]{this.baseDataTypeVoid, byteDT, wordDT, dwordDT, qwordDT};
        this.baseDataTypeChar = this.findGhidraType("char");
        this.baseDataTypeUchar = this.findGhidraType("uchar");
        this.baseDataTypes.put("char", this.baseDataTypeChar);
        this.baseDataTypes.put("signed char", this.baseDataTypeChar);
        this.baseDataTypes.put("unsigned char", this.baseDataTypeUchar);
        this.baseDataTypeChars = new DataType[]{this.baseDataTypeChar, this.findGhidraType(WideChar16DataType.dataType.getName()), this.findGhidraType(WideChar32DataType.dataType.getName())};
        DataType shortDT = this.findGhidraType("short");
        DataType ushortDT = this.findGhidraType("ushort");
        DataType intDT = this.findGhidraType("int");
        DataType uintDT = this.findGhidraType("uint");
        DataType longDT = this.findGhidraType("long");
        DataType ulongDT = this.findGhidraType("ulong");
        DataType longlongDT = this.findGhidraType("longlong");
        DataType ulonglongDT = this.findGhidraType("ulonglong");
        this.baseDataTypes.put("short", shortDT);
        this.baseDataTypes.put("short int", shortDT);
        this.baseDataTypes.put("signed short int", shortDT);
        this.baseDataTypes.put("unsigned short int", ushortDT);
        this.baseDataTypes.put("short unsigned int", ushortDT);
        this.baseDataTypes.put("int", intDT);
        this.baseDataTypes.put("signed int", intDT);
        this.baseDataTypes.put("unsigned int", uintDT);
        this.baseDataTypes.put("long", longDT);
        this.baseDataTypes.put("long int", longDT);
        this.baseDataTypes.put("signed long int", longDT);
        this.baseDataTypes.put("unsigned long int", ulongDT);
        this.baseDataTypes.put("long unsigned int", ulongDT);
        this.baseDataTypes.put("long long", longlongDT);
        this.baseDataTypes.put("long long int", longlongDT);
        this.baseDataTypes.put("signed long long int", longlongDT);
        this.baseDataTypes.put("unsigned long long int", ulonglongDT);
        this.baseDataTypes.put("long long unsigned int", ulonglongDT);
        DataType floatDT = this.findGhidraType("float");
        DataType doubleDT = this.findGhidraType("double");
        DataType ldoubleDT = this.findGhidraType("longdouble");
        this.baseDataTypes.put("double", doubleDT);
        this.baseDataTypes.put("long double", ldoubleDT);
        this.baseDataTypes.put("float", floatDT);
        this.baseDataTypeBool = this.findGhidraType("bool");
        this.baseDataTypes.put("bool", this.baseDataTypeBool);
        this.baseDataTypes.put("wchar_t", this.findGhidraType("wchar_t"));
    }

    public void importAllDataTypes(TaskMonitor monitor) throws IOException, DWARFException, CancelledException {
        int dtCountBefore = this.dataTypeManager.getDataTypeCount(true);
        for (DIEAggregate diea : DIEAMonitoredIterator.iterable(this.prog, "DWARF Import Types", monitor)) {
            monitor.checkCancelled();
            try {
                if (!this.isDataType(diea)) continue;
                this.doGetDataType(diea);
            }
            catch (IllegalArgumentException iae) {
                Msg.error((Object)this, (Object)("Failed to process DWARF DIE " + diea.getHexOffset() + ": " + iae.getMessage()));
            }
            catch (OutOfMemoryError oom) {
                throw oom;
            }
            catch (Throwable th) {
                Msg.error((Object)this, (Object)("Error when processing DWARF information for DIE " + diea.getHexOffset()), (Throwable)th);
                Msg.info((Object)this, (Object)("DIE info:\n" + diea.toString()));
            }
        }
        int dtCountAfter = this.dataTypeManager.getDataTypeCount(true);
        this.importSummary.dataTypesAdded = dtCountAfter - dtCountBefore;
        if (this.prog.getImportOptions().isCreateFuncSignatures()) {
            this.importFuncSignatures(monitor);
        }
    }

    private DIEAggregate getFuncDIEA(DIEAggregate diea) {
        switch (diea.getTag()) {
            case 29: 
            case 72: 
            case 16649: {
                diea = DIEAggregate.createSkipHead(diea);
            }
            case 46: {
                return diea;
            }
        }
        return null;
    }

    public FunctionDefinition getFunctionSignature(DIEAggregate diea) {
        if ((diea = this.getFuncDIEA(diea)) != null) {
            DWARFNameInfo dni = this.prog.getName(diea);
            return this.createFunctionDefinitionDataType(diea, dni);
        }
        return null;
    }

    private void importFuncSignatures(TaskMonitor monitor) throws CancelledException {
        int dtCountBefore = this.dataTypeManager.getDataTypeCount(true);
        for (DIEAggregate diea : DIEAMonitoredIterator.iterable(this.prog, "DWARF Import Function Signatures", monitor)) {
            monitor.checkCancelled();
            try {
                DWARFNameInfo dni;
                FunctionDefinitionDataType funcDefDT;
                if ((diea = this.getFuncDIEA(diea)) == null || (funcDefDT = this.createFunctionDefinitionDataType(diea, dni = this.prog.getName(diea))) == null) continue;
                funcDefDT = this.dataTypeManager.addDataType((DataType)funcDefDT, DataTypeConflictHandler.DEFAULT_HANDLER);
                this.addDataType(diea.getOffset(), (DataType)funcDefDT, DWARFSourceInfo.getSourceInfoWithFallbackToParent(diea));
                Swing.runNow((Runnable)Dummy.runnable());
            }
            catch (OutOfMemoryError oom) {
                throw oom;
            }
            catch (Throwable th) {
                Msg.error((Object)this, (Object)("Error when processing DWARF information for DIE " + diea.getHexOffset()), (Throwable)th);
                Msg.info((Object)this, (Object)("DIE info:\n" + diea.toString()));
            }
        }
        int dtCountAfter = this.dataTypeManager.getDataTypeCount(true);
        this.importSummary.funcSignaturesAdded = dtCountAfter - dtCountBefore;
    }

    private boolean isDataType(DIEAggregate diea) {
        switch (diea.getTag()) {
            case 1: 
            case 2: 
            case 4: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 36: 
            case 38: 
            case 53: 
            case 56: 
            case 59: 
            case 66: {
                return true;
            }
        }
        return false;
    }

    private FunctionDefinitionDataType createFunctionDefinitionDataType(DIEAggregate diea, DWARFNameInfo dni) {
        DataType returnDataType = this.getDataTypeForVariable(diea.getTypeRef());
        boolean foundThisParam = false;
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        for (DIEAggregate paramDIEA : diea.getFunctionParamList()) {
            String paramName = paramDIEA.getName();
            DataType paramDT = this.getDataTypeForVariable(paramDIEA.getTypeRef());
            if (paramDT == null || paramDT.getLength() <= 0) {
                Msg.error((Object)this, (Object)("Bad function parameter type for function " + dni.asCategoryPath() + ", param " + params.size() + " : " + paramDT + ", func die " + diea.getHexOffset() + ", param type die: " + paramDIEA.getTypeRef().getHexOffset()));
                return null;
            }
            ParameterDefinitionImpl pd = new ParameterDefinitionImpl(paramName, paramDT, null);
            params.add(pd);
            foundThisParam |= DWARFUtil.isThisParam(paramDIEA);
        }
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(dni.getParentCP(), dni.getName(), this.dataTypeManager);
        funcDef.setReturnType(returnDataType);
        funcDef.setNoReturn(diea.getBool(135, false));
        funcDef.setArguments(params.toArray(new ParameterDefinition[params.size()]));
        if (!diea.getHeadFragment().getChildren(24).isEmpty()) {
            funcDef.setVarArgs(true);
        }
        if (foundThisParam) {
            try {
                funcDef.setCallingConvention("__thiscall");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)"Unexpected calling convention error", (Throwable)e);
            }
        }
        return funcDef;
    }

    private int getExplicitSizeFromTypeName(String name) {
        if (name == null) {
            return -1;
        }
        Matcher m = FIXED_SIZED_TYPE_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            try {
                return Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

