/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.util.Msg;
import java.util.HashSet;
import java.util.Set;

public class DWARFImportSummary {
    long dataTypeElapsedMS;
    long funcsElapsedMS;
    long totalElapsedMS;
    int dataTypesAdded;
    int funcsAdded;
    int funcsUpdated;
    int funcSignaturesAdded;
    int globalVarsAdded;
    Set<Integer> unknownRegistersEncountered = new HashSet<Integer>();
    Set<String> relocationErrorVarDefs = new HashSet<String>();
    int varFitError;
    int varDynamicRegisterError;
    int varDWARFExpressionValue;
    int exprReadError;
    Set<String> typeRemappings = new HashSet<String>();

    public void logSummaryResults() {
        if (this.totalElapsedMS > 0L) {
            Msg.info((Object)this, (Object)String.format("DWARF import - total elapsed: %dms", this.totalElapsedMS));
        }
        if (this.dataTypeElapsedMS > 0L) {
            Msg.info((Object)this, (Object)String.format("DWARF data type import - elapsed: %dms", this.dataTypeElapsedMS));
        }
        if (this.funcsElapsedMS > 0L) {
            Msg.info((Object)this, (Object)String.format("DWARF func & symbol import - elapsed: %dms", this.funcsElapsedMS));
        }
        if (this.dataTypesAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF types imported: %d", this.dataTypesAdded));
        }
        if (this.funcsAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF funcs added: %d", this.funcsAdded));
        }
        if (this.funcSignaturesAdded > 0) {
            Msg.info((Object)this, (Object)String.format("DWARF function signatures added: %d", this.funcSignaturesAdded));
        }
        if (!this.typeRemappings.isEmpty()) {
            Msg.error((Object)this, (Object)"DWARF data type remappings (DWARF data type definitions that changed meaning in different compile units):");
            Msg.error((Object)this, (Object)"  Data type -> changed to -> Data Type");
            int x = 0;
            for (String s : this.typeRemappings) {
                Msg.error((Object)this, (Object)("  " + s));
                if (x++ <= 1000) continue;
                Msg.error((Object)this, (Object)("...omitting " + (this.typeRemappings.size() - 1000) + " additional type remapping warnings."));
                break;
            }
        }
        if (!this.relocationErrorVarDefs.isEmpty()) {
            Msg.error((Object)this, (Object)"DWARF static variables with missing address info:");
            Msg.error((Object)this, (Object)"  [Variable symbolic name  : variable data type]");
            for (String varDef : this.relocationErrorVarDefs) {
                Msg.error((Object)this, (Object)("  " + varDef));
            }
        }
        if (this.varFitError > 0) {
            Msg.error((Object)this, (Object)("DWARF variable definitions that failed because the data type was too large for the defined register location: " + this.varFitError));
        }
        if (this.varDynamicRegisterError > 0) {
            Msg.error((Object)this, (Object)("DWARF variable definitions that failed because they depended on the dynamic value of a register: " + this.varDynamicRegisterError));
        }
        if (this.varDWARFExpressionValue > 0) {
            Msg.error((Object)this, (Object)("DWARF variable definitions that failed because they are computed pseudo variables: " + this.varDWARFExpressionValue));
        }
        if (this.exprReadError > 0) {
            Msg.error((Object)this, (Object)("DWARF expression failed to read: " + this.exprReadError));
        }
    }
}

