/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class NameDeduper {
    private final Set<String> usedNames = new HashSet<String>();
    private final Set<String> reservedNames = new HashSet<String>();

    public void addUsedNames(Collection<String> alreadyUsedNames) {
        this.usedNames.addAll(alreadyUsedNames);
    }

    public void addReservedNames(Collection<String> additionalReservedNames) {
        this.reservedNames.addAll(additionalReservedNames);
    }

    public boolean isUniqueName(String name) {
        return name == null || !this.usedNames.contains(name);
    }

    public String getUniqueName(String name) {
        if (name == null || this.usedNames.add(name)) {
            return null;
        }
        String original = name;
        int tryNum = 0;
        while (this.usedNames.contains(name) || this.reservedNames.contains(name)) {
            name = String.format("%s_%d", original, ++tryNum);
        }
        this.usedNames.add(name);
        return name;
    }
}

