/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import java.io.IOException;

@StructureMapping(structureName="runtime.structfield")
public class GoStructField {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoStructField> context;
    @FieldMapping
    @MarkupReference
    @EOLComment(value="nameString")
    private long name;
    @FieldMapping
    @MarkupReference(value="type")
    private long typ;
    @FieldMapping(fieldName="offsetAnon")
    private long offset;

    @Markup
    public GoName getName() throws IOException {
        return this.name != 0L ? this.context.getDataTypeMapper().readStructure(GoName.class, this.name) : null;
    }

    @Markup
    public GoType getType() throws IOException {
        return this.programContext.getGoType(this.typ);
    }

    public long getOffset() {
        return this.offset >> 1;
    }

    public boolean isEmbedded() {
        return (this.offset & 1L) != 0L;
    }

    public String getNameString() throws IOException {
        GoName n = this.getName();
        return n != null ? n.getName() : null;
    }
}

