/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheSlideInfo3
extends DyldCacheSlideInfoCommon {
    private static final int DYLD_CACHE_SLIDE_V3_PAGE_ATTR_NO_REBASE = 65535;
    private int page_size;
    private int page_starts_count;
    private long auth_value_add;
    private short[] page_starts;

    public int getPageSize() {
        return this.page_size;
    }

    public int getPageStartsCount() {
        return this.page_starts_count;
    }

    public long getAuthValueAdd() {
        return this.auth_value_add;
    }

    public short[] getPageStarts() {
        return this.page_starts;
    }

    public DyldCacheSlideInfo3(BinaryReader reader) throws IOException {
        super(reader);
        this.page_size = reader.readNextInt();
        this.page_starts_count = reader.readNextInt();
        int pad = reader.readNextInt();
        this.auth_value_add = reader.readNextLong();
        this.page_starts = reader.readNextShortArray(this.page_starts_count);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info3", 0);
        struct.add(DWORD, "version", "");
        struct.add(DWORD, "page_size", "");
        struct.add(DWORD, "page_starts_count", "");
        struct.add(DWORD, "pad", "");
        struct.add(QWORD, "auth_value_add", "");
        struct.add((DataType)new ArrayDataType(WORD, this.page_starts_count, 1), "page_starts", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void fixPageChains(Program program, DyldCacheHeader dyldCacheHeader, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        long fixedAddressCount = 0L;
        List<DyldCacheMappingAndSlideInfo> mappingInfos = dyldCacheHeader.getCacheMappingAndSlideInfos();
        if (mappingInfos.size() <= 1) {
            return;
        }
        DyldCacheMappingAndSlideInfo dyldCacheMappingInfo = mappingInfos.get(1);
        for (DyldCacheMappingAndSlideInfo cacheSlideInfo : mappingInfos) {
            if (cacheSlideInfo.getSlideInfoFileOffset() != this.getSlideInfoOffset()) continue;
            dyldCacheMappingInfo = cacheSlideInfo;
            break;
        }
        long dataPageStart = dyldCacheMappingInfo.getAddress();
        long pageSize = this.getPageSize();
        long pageStartsCount = this.getPageStartsCount();
        long authValueAdd = this.getAuthValueAdd();
        short[] pageStarts = this.getPageStarts();
        monitor.setMessage("Fixing V3 chained data page pointers...");
        monitor.setMaximum(pageStartsCount);
        int index = 0;
        while ((long)index < pageStartsCount) {
            monitor.checkCancelled();
            long page = dataPageStart + pageSize * (long)index;
            monitor.setProgress((long)index);
            int pageEntry = pageStarts[index] & 0xFFFF;
            if (pageEntry != 65535) {
                long pageOffset = pageEntry / 8 * 8;
                List<Address> unchainedLocList = this.processPointerChain3(program, page, pageOffset, authValueAdd, addRelocations, monitor);
                fixedAddressCount += (long)unchainedLocList.size();
                this.createChainPointers(program, unchainedLocList, monitor);
            }
            ++index;
        }
        log.appendMsg("Fixed " + fixedAddressCount + " chained pointers.");
        monitor.setMessage("Created " + fixedAddressCount + " chained pointers");
    }

    private List<Address> processPointerChain3(Program program, long page, long nextOff, long auth_value_add, boolean addRelocation, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Address chainStart = program.getLanguage().getDefaultSpace().getAddress(page);
        Memory memory = program.getMemory();
        ArrayList<Address> unchainedLocList = new ArrayList<Address>(1024);
        long delta = -1L;
        while (delta != 0L) {
            monitor.checkCancelled();
            Address chainLoc = chainStart.add(nextOff);
            long chainValue = memory.getLong(chainLoc);
            boolean isAuthenticated = chainValue >>> 63 != 0L;
            delta = (chainValue & 0x3FF8000000000000L) >> 51;
            if (isAuthenticated) {
                long offsetFromSharedCacheBase = chainValue & 0xFFFFFFFFL;
                chainValue = offsetFromSharedCacheBase + auth_value_add;
            } else {
                long top8Bits = chainValue & 0x7F80000000000L;
                long bottom43Bits = chainValue & 0x7FFFFFFFFFFL;
                chainValue = top8Bits << 13 | bottom43Bits;
            }
            if (addRelocation) {
                this.addRelocationTableEntry(program, chainLoc, 3 * (isAuthenticated ? -1 : 1), chainValue, 8, null);
            }
            memory.setLong(chainLoc, chainValue);
            unchainedLocList.add(chainLoc);
            nextOff += delta * 8L;
        }
        return unchainedLocList;
    }
}

