/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadStateX86;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Conv;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStateX86_32
extends ThreadStateX86 {
    public int eax;
    public int ebx;
    public int ecx;
    public int edx;
    public int edi;
    public int esi;
    public int ebp;
    public int esp;
    public int ss;
    public int eflags;
    public int eip;
    public int cs;
    public int ds;
    public int es;
    public int fs;
    public int gs;

    ThreadStateX86_32(BinaryReader reader) throws IOException {
        this.eax = reader.readNextInt();
        this.ebx = reader.readNextInt();
        this.ecx = reader.readNextInt();
        this.edx = reader.readNextInt();
        this.edi = reader.readNextInt();
        this.esi = reader.readNextInt();
        this.ebp = reader.readNextInt();
        this.esp = reader.readNextInt();
        this.ss = reader.readNextInt();
        this.eflags = reader.readNextInt();
        this.eip = reader.readNextInt();
        this.cs = reader.readNextInt();
        this.ds = reader.readNextInt();
        this.es = reader.readNextInt();
        this.fs = reader.readNextInt();
        this.gs = reader.readNextInt();
    }

    @Override
    public long getInstructionPointer() {
        return Conv.intToLong((int)this.eip);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("x86_THREAD_STATE32", 0);
        struct.add(DWORD, "eax", null);
        struct.add(DWORD, "ebx", null);
        struct.add(DWORD, "ecx", null);
        struct.add(DWORD, "edx", null);
        struct.add(DWORD, "edi", null);
        struct.add(DWORD, "esi", null);
        struct.add(DWORD, "ebp", null);
        struct.add(DWORD, "esp", null);
        struct.add(DWORD, "ss", null);
        struct.add(DWORD, "eflags", null);
        struct.add(DWORD, "eip", null);
        struct.add(DWORD, "cs", null);
        struct.add(DWORD, "ds", null);
        struct.add(DWORD, "es", null);
        struct.add(DWORD, "fs", null);
        struct.add(DWORD, "gs", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

