/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class OmfCommentRecord
extends OmfRecord {
    public static final byte COMMENT_CLASS_TRANSLATOR = 0;
    public static final byte COMMENT_CLASS_LIBMOD = -93;
    public static final byte COMMENT_CLASS_DEFAULT_LIBRARY = -97;
    public static final byte COMMENT_CLASS_WATCOM_SETTINGS = -101;
    public static final byte COMMENT_CLASS_MICROSOFT_SETTINGS = -99;
    private byte commentType;
    private byte commentClass;
    private String value;

    public OmfCommentRecord(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        this.commentType = reader.readNextByte();
        this.commentClass = reader.readNextByte();
        switch (this.commentClass) {
            case -97: 
            case 0: {
                byte[] bytes = reader.readNextByteArray(this.getRecordLength() - 3);
                this.value = new String(bytes, StandardCharsets.US_ASCII);
                break;
            }
            case -93: {
                this.value = OmfCommentRecord.readString(reader);
                break;
            }
            default: {
                reader.setPointerIndex(reader.getPointerIndex() + (long)this.getRecordLength() - 3L);
            }
        }
        this.readCheckSumByte(reader);
    }

    public byte getCommentType() {
        return this.commentType;
    }

    public byte getCommentClass() {
        return this.commentClass;
    }

    public String getValue() {
        return this.value;
    }
}

