/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.CompletelyDifferentHTMLDataTypeRepresentationWrapper;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.TextLine;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;

public class DefaultDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    protected TextLine header;
    protected TextLine footer;

    private DefaultDataTypeHTMLRepresentation(TextLine header, TextLine footer) {
        this.header = header;
        this.footer = footer;
        this.originalHTMLData = DefaultDataTypeHTMLRepresentation.buildHTMLText(header, footer);
    }

    public DefaultDataTypeHTMLRepresentation(DataType dataType) {
        this.header = this.buildHeader(dataType);
        this.footer = this.buildFooter(dataType);
        this.originalHTMLData = DefaultDataTypeHTMLRepresentation.buildHTMLText(this.header, this.footer);
    }

    private TextLine buildHeader(DataType dataType) {
        if (dataType instanceof Array) {
            Array array = (Array)dataType;
            return new TextLine(this.getArrayDescription(array));
        }
        String description = dataType.getDescription();
        if (description == null || description.length() == 0) {
            return new TextLine(dataType.getName());
        }
        return new TextLine(description);
    }

    private String getArrayDescription(Array array) {
        DataType baseDataType = array.getDataType();
        if (baseDataType instanceof Array) {
            return this.getArrayDescription((Array)baseDataType);
        }
        return "Array of " + baseDataType.getName();
    }

    private TextLine buildFooter(DataType dataType) {
        int length = dataType.getLength();
        if (length >= 0) {
            return new TextLine(Integer.toString(length));
        }
        return new TextLine(" <i>Unsized</i>");
    }

    private static String buildHTMLText(TextLine header, TextLine footer) {
        StringBuilder buffer = new StringBuilder();
        String headerText = header.getText();
        String encodedHeaderText = HTMLUtilities.escapeHTML((String)headerText);
        headerText = DefaultDataTypeHTMLRepresentation.wrapStringInColor(encodedHeaderText, header.getTextColor());
        buffer.append(headerText);
        String footerText = footer.getText();
        footerText = DefaultDataTypeHTMLRepresentation.wrapStringInColor(footerText, footer.getTextColor());
        DefaultDataTypeHTMLRepresentation.addDataTypeLength(footerText, buffer);
        return buffer.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof DefaultDataTypeHTMLRepresentation)) {
            return new HTMLDataTypeRepresentation[]{new CompletelyDifferentHTMLDataTypeRepresentationWrapper(this), new CompletelyDifferentHTMLDataTypeRepresentationWrapper(otherRepresentation)};
        }
        DefaultDataTypeHTMLRepresentation defaultRepresentation = (DefaultDataTypeHTMLRepresentation)otherRepresentation;
        TextLine diffHeader = new TextLine(this.header.getText());
        TextLine diffFooter = new TextLine(this.footer.getText());
        TextLine otherDiffHeader = new TextLine(defaultRepresentation.header.getText());
        TextLine otherDiffFooter = new TextLine(defaultRepresentation.footer.getText());
        this.diffTextLine(diffHeader, otherDiffHeader);
        this.diffTextLine(diffFooter, otherDiffFooter);
        return new HTMLDataTypeRepresentation[]{new DefaultDataTypeHTMLRepresentation(diffHeader, diffFooter), new DefaultDataTypeHTMLRepresentation(otherDiffHeader, otherDiffFooter)};
    }
}

