/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.SaveState;

public class FileOffsetFieldOptionsWrappedOption
implements CustomOption {
    private static final String SHOW_FILENAME = "ShowFilename";
    private static final String USE_HEX = "UseHex";
    private static final boolean DEFAULT_SHOW_FILENAME = false;
    private static final boolean DEFAULT_USE_HEX = true;
    private boolean showFilename = false;
    private boolean useHex = true;

    public boolean showFilename() {
        return this.showFilename;
    }

    public void setShowFilename(boolean showFilename) {
        this.showFilename = showFilename;
    }

    public boolean useHex() {
        return this.useHex;
    }

    public void setUseHex(boolean useHex) {
        this.useHex = useHex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileOffsetFieldOptionsWrappedOption)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileOffsetFieldOptionsWrappedOption otherOption = (FileOffsetFieldOptionsWrappedOption)obj;
        return this.showFilename == otherOption.showFilename && this.useHex == otherOption.useHex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.showFilename ? 1 : 0);
        result = prime * result + (this.useHex ? 1 : 0);
        return result;
    }

    public void readState(SaveState saveState) {
        this.showFilename = saveState.getBoolean(SHOW_FILENAME, this.showFilename);
        this.useHex = saveState.getBoolean(USE_HEX, this.useHex);
    }

    public void writeState(SaveState saveState) {
        saveState.putBoolean(SHOW_FILENAME, this.showFilename);
        saveState.putBoolean(USE_HEX, this.useHex);
    }
}

