/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.InstructionMaskValueFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.StringUtilities;
import java.awt.Color;
import java.math.BigInteger;

public class InstructionMaskValueFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Instr Mask/Value";

    public InstructionMaskValueFieldFactory() {
        super(FIELD_NAME);
    }

    private InstructionMaskValueFieldFactory(FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        InstructionPrototype proto = instr.getPrototype();
        int operandCount = proto.getNumOperands();
        Mask instructionMask = proto.getInstructionMask();
        if (instructionMask == null) {
            return null;
        }
        Mask[] operandMasks = new Mask[operandCount];
        for (int i = 0; i < operandCount; ++i) {
            operandMasks[i] = proto.getOperandValueMask(i);
            if (operandMasks[i] != null) continue;
            operandCount = 0;
            break;
        }
        try {
            FieldElement[] fieldElements = new FieldElement[2 * (operandCount + 1)];
            fieldElements[0] = this.getLine("M[m]: ", instructionMask.getBytes(), (Color)ListingColors.MaskColors.BITS, proxy, varWidth);
            fieldElements[1] = this.getLine("V[m]: ", instructionMask.applyMask((MemBuffer)instr), (Color)ListingColors.MaskColors.VALUE, proxy, varWidth);
            for (int i = 0; i < operandCount; ++i) {
                fieldElements[2 * (i + 1)] = this.getLine("M[" + i + "]: ", operandMasks[i].getBytes(), (Color)ListingColors.MaskColors.BITS, proxy, varWidth);
                fieldElements[2 * (i + 1) + 1] = this.getLine("V[" + i + "]: ", operandMasks[i].applyMask((MemBuffer)instr), (Color)ListingColors.MaskColors.VALUE, proxy, varWidth);
            }
            return ListingTextField.createMultilineTextField(this, proxy, fieldElements, this.startX + varWidth, this.width, fieldElements.length, this.hlProvider);
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    private FieldElement getLine(String label, byte[] value, Color valueColor, ProxyObj<?> proxy, int varWidth) {
        FieldElement[] fieldElements = new FieldElement[2];
        AttributedString as = new AttributedString(label, (Color)ListingColors.MaskColors.LABEL, this.getMetrics(), false, (Color)ListingColors.UNDERLINE);
        fieldElements[0] = new TextFieldElement(as, 0, 0);
        as = new AttributedString(this.getFormattedBytes(value), valueColor, this.getMetrics(), false, (Color)ListingColors.UNDERLINE);
        fieldElements[1] = new TextFieldElement(as, 0, 0);
        return new CompositeFieldElement(fieldElements);
    }

    private String getFormattedBytes(byte[] value) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            String byteStr = StringUtilities.pad((String)Integer.toBinaryString(value[i] & 0xFF), (char)'0', (int)8);
            buf.append(byteStr);
            if (i >= value.length - 1) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Instruction)) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        return new InstructionMaskValueFieldLocation(instr.getProgram(), instr.getMinAddress(), row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof InstructionMaskValueFieldLocation) {
            InstructionMaskValueFieldLocation maskValueLoc = (InstructionMaskValueFieldLocation)programLoc;
            return new FieldLocation(index, fieldNum, maskValueLoc.getRow(), maskValueLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 4;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider hsProvider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new InstructionMaskValueFieldFactory(formatModel, hsProvider, (Options)toolOptions, (Options)fieldOptions);
    }
}

