/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import generic.theme.GThemeDefaults;
import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import java.awt.Color;

public class InvalidAnnotatedStringHandler
implements AnnotatedStringHandler {
    private final String errorText;

    public InvalidAnnotatedStringHandler() {
        this.errorText = "Invalid Annotation";
    }

    public InvalidAnnotatedStringHandler(String errorText) {
        this.errorText = errorText;
    }

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) throws AnnotationException {
        return new AttributedString(this.errorText, (Color)GThemeDefaults.Colors.Messages.ERROR, prototypeString.getFontMetrics(0));
    }

    @Override
    public String[] getSupportedAnnotations() {
        return new String[0];
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable navigatable, ServiceProvider serviceProvider) {
        return false;
    }

    @Override
    public String getDisplayString() {
        return "Invalid";
    }

    @Override
    public String getPrototypeString() {
        return "";
    }
}

