/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ExternalLibXmlMgr {
    private MessageLog log;
    private ExternalManager extManager;

    ExternalLibXmlMgr(Program program, MessageLog log) {
        this.log = log;
        this.extManager = program.getExternalManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(XmlPullParser parser, TaskMonitor monitor) throws CancelledException {
        XmlElement start = parser.start(new String[]{"EXT_LIBRARY_TABLE"});
        while (parser.peek().isStart()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            XmlElement element = parser.start(new String[]{"EXT_LIBRARY"});
            try {
                this.processExternalLib(element, parser);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
            finally {
                parser.end(element);
            }
        }
        parser.end(start);
    }

    void write(XmlWriter writer, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing EXTERNAL LIBRARIES ...");
        writer.startElement("EXT_LIBRARY_TABLE");
        String[] externalNames = this.extManager.getExternalLibraryNames();
        for (int i = 0; i < externalNames.length; ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            String path = this.extManager.getExternalLibraryPath(externalNames[i]);
            if (path == null) {
                path = "";
            }
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", externalNames[i]);
            attrs.addAttribute("PATH", path);
            writer.startElement("EXT_LIBRARY", attrs);
            writer.endElement("EXT_LIBRARY");
        }
        writer.endElement("EXT_LIBRARY_TABLE");
    }

    private void processExternalLib(XmlElement element, XmlPullParser parser) throws InvalidInputException {
        String progName = element.getAttribute("NAME");
        String progPath = element.getAttribute("PATH");
        String currPath = this.extManager.getExternalLibraryPath(progName);
        if (progPath == null || progPath.isEmpty()) {
            return;
        }
        if (currPath != null && !currPath.isEmpty()) {
            return;
        }
        this.extManager.setExternalPath(progName, progPath, true);
    }
}

