/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.LabelString;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.OperandRepresentationList;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.MemReferenceImpl;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.MathUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeUnitFormat {
    protected static final String PLUS = "+";
    protected static final String UNDERSCORE = "_";
    public static String EXTENDED_REFERENCE_DELIMITER = "=>";
    public static String EXTENDED_INDIRECT_REFERENCE_DELIMITER = "->";
    private static final int[] SHIFT_CASES = new int[]{1, 2, 8, 16, 32};
    private static final long[] MASK_CASES = new long[]{255L, 65535L, -1L};
    public static CodeUnitFormat DEFAULT = new CodeUnitFormat(CodeUnitFormatOptions.ShowBlockName.NEVER, CodeUnitFormatOptions.ShowNamespace.NEVER);
    protected CodeUnitFormatOptions options;

    protected CodeUnitFormat() {
        this(new CodeUnitFormatOptions());
    }

    public CodeUnitFormat(CodeUnitFormatOptions.ShowBlockName showBlockName, CodeUnitFormatOptions.ShowNamespace showNamespace) {
        this(new CodeUnitFormatOptions(showBlockName, showNamespace));
    }

    public CodeUnitFormat(CodeUnitFormatOptions options) {
        this.options = options;
    }

    public String getRepresentationString(CodeUnit cu) {
        return this.getRepresentationString(cu, false);
    }

    public String getRepresentationString(CodeUnit cu, boolean includeEOLcomment) {
        String eolComment;
        StringBuffer stringBuffer = new StringBuffer(this.getMnemonicRepresentation(cu));
        if (cu instanceof Instruction) {
            Instruction instr = (Instruction)cu;
            int n = instr.getNumOperands();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    stringBuffer.append(" ");
                } else {
                    String separator = instr.getSeparator(i);
                    if (separator != null && separator.length() != 0) {
                        stringBuffer.append(separator);
                    }
                }
                stringBuffer.append(this.getOperandRepresentationString(cu, i));
            }
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(this.getOperandRepresentationString(cu, 0));
        }
        if (includeEOLcomment && (eolComment = cu.getComment(0)) != null) {
            eolComment = CommentUtils.getDisplayString(eolComment, cu.getProgram());
            stringBuffer.append("  // ");
            stringBuffer.append(eolComment);
        }
        return stringBuffer.toString();
    }

    public String getMnemonicRepresentation(CodeUnit cu) {
        StringBuffer stringBuffer = new StringBuffer();
        String mnemonic = cu.getMnemonicString();
        if (this.options.showDataMutability && cu instanceof Data && mnemonic != null) {
            Data d = (Data)cu;
            if (d.isConstant()) {
                stringBuffer.append("const ");
            } else if (d.isVolatile()) {
                stringBuffer.append("volatile ");
            }
        }
        stringBuffer.append(mnemonic);
        return stringBuffer.toString();
    }

    public String getOperandRepresentationString(CodeUnit cu, int opIndex) {
        OperandRepresentationList list = this.getOperandRepresentationList(cu, opIndex);
        if (list == null) {
            return "<UNSUPPORTED>";
        }
        return list.toString();
    }

    public OperandRepresentationList getOperandRepresentationList(CodeUnit cu, int opIndex) {
        if (cu instanceof Data) {
            if (opIndex == 0) {
                return this.getDataValueRepresentation((Data)cu);
            }
            return null;
        }
        Program program = cu.getProgram();
        Instruction instr = (Instruction)cu;
        if (!program.getLanguage().supportsPcode()) {
            return null;
        }
        List representationList = instr.getDefaultOperandRepresentationList(opIndex);
        if (representationList == null) {
            return new OperandRepresentationList("<BAD-Instruction>");
        }
        HashMap<Register, Integer> regIndexMap = this.getRegisterIndexMap(representationList);
        Address address = instr.getMinAddress();
        Function func = instr.getProgram().getFunctionManager().getFunctionContaining(address);
        Reference primaryRef = cu.getPrimaryReference(opIndex);
        Variable referencedVariable = null;
        if (primaryRef != null && func != null) {
            referencedVariable = program.getReferenceManager().getReferencedVariable(primaryRef);
        }
        if (this.performAddressMarkup(instr, opIndex, func, primaryRef, representationList)) {
            primaryRef = null;
            referencedVariable = null;
        }
        if (this.performScalarMarkup(instr, opIndex, func, primaryRef, referencedVariable, regIndexMap, representationList)) {
            primaryRef = null;
            referencedVariable = null;
        }
        if (this.performRegisterMarkup(instr, opIndex, func, primaryRef, referencedVariable, regIndexMap, representationList)) {
            primaryRef = null;
            referencedVariable = null;
        }
        if (this.performExtendedMarkup(instr, primaryRef, referencedVariable, representationList)) {
            primaryRef = null;
            referencedVariable = null;
        }
        return new OperandRepresentationList(representationList, primaryRef != null);
    }

    private boolean performRegisterMarkup(Instruction instr, int opIndex, Function func, Reference primaryRef, Variable referencedVariable, HashMap<Register, Integer> regIndexMap, List<Object> representationList) {
        if (func == null || !this.options.doRegVariableMarkup) {
            return false;
        }
        Program program = instr.getProgram();
        Register referencedRegister = null;
        if (referencedVariable != null && referencedVariable.isRegisterVariable()) {
            referencedRegister = referencedVariable.getRegister();
        } else {
            ReferenceManager refMgr = program.getReferenceManager();
            for (Reference ref : instr.getReferencesFrom()) {
                if (ref.getOperandIndex() != -1 || !ref.getReferenceType().isWrite() || (referencedVariable = refMgr.getReferencedVariable(ref)) == null || !referencedVariable.isRegisterVariable()) continue;
                primaryRef = ref;
                referencedRegister = referencedVariable.getRegister();
                break;
            }
        }
        for (Register reg : regIndexMap.keySet()) {
            VariableOffset varOff = null;
            if (this.registersOverlap(referencedRegister, reg)) {
                varOff = new VariableOffset(primaryRef, referencedVariable);
                primaryRef = null;
                referencedVariable = null;
            } else if (this.options.includeInferredVariableMarkup) {
                boolean isRead = this.isRead(reg, instr);
                Variable regVar = program.getFunctionManager().getReferencedVariable(instr.getMinAddress(), reg.getAddress(), reg.getMinimumByteSize(), isRead);
                if (regVar != null) {
                    Variable regWriteVar;
                    if (isRead && this.isWritten(reg, instr) && !this.hasRegisterWriteReference(instr, reg) && instr.getRegister(opIndex) != null && (regWriteVar = program.getFunctionManager().getReferencedVariable(instr.getMinAddress(), reg.getAddress(), reg.getMinimumByteSize(), false)) != regVar) continue;
                    long offset = 0L;
                    varOff = new VariableOffset(regVar, offset, instr.getRegister(opIndex) == null, true);
                }
            }
            if (varOff == null) continue;
            varOff.setReplacedElement(reg);
            representationList.set(regIndexMap.get(reg), varOff);
        }
        return primaryRef == null;
    }

    private boolean registersOverlap(Register reg1, Register reg2) {
        if (reg1 == null || reg2 == null) {
            return false;
        }
        Address reg1MinAddr = reg1.getAddress();
        Address reg2MinAddr = reg2.getAddress();
        Address reg1MaxAddr = reg1MinAddr;
        int size = reg1.getMinimumByteSize();
        if (size > 1) {
            reg1MaxAddr = reg1MinAddr.add((long)(size - 1));
        }
        if (reg2MinAddr.compareTo((Object)reg1MaxAddr) > 0) {
            return false;
        }
        if (reg1MaxAddr.compareTo((Object)reg2MinAddr) < 0) {
            return false;
        }
        Address reg2MaxAddr = reg2MinAddr;
        size = reg1.getMinimumByteSize();
        if (size > 1) {
            reg2MaxAddr = reg2MinAddr.add((long)(size - 1));
        }
        if (reg1MinAddr.compareTo((Object)reg2MaxAddr) > 0) {
            return false;
        }
        return reg2MaxAddr.compareTo((Object)reg1MinAddr) >= 0;
    }

    private boolean hasRegisterWriteReference(Instruction instr, Register reg) {
        for (Reference ref : instr.getReferencesFrom()) {
            if (!ref.getReferenceType().isWrite() || !ref.getToAddress().equals((Object)reg.getAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean performExtendedMarkup(Instruction instr, Reference primaryRef, Variable referencedVariable, List<Object> representationList) {
        if (!this.options.alwaysShowPrimaryReference) {
            return false;
        }
        if (primaryRef == null) {
            return false;
        }
        if (representationList.size() == 0) {
            return false;
        }
        Object refRep = this.getReferenceRepresentation((CodeUnit)instr, primaryRef, referencedVariable);
        if (refRep == null) {
            return false;
        }
        OperandRepresentationList compoundList = new OperandRepresentationList();
        int index = representationList.size() - 1;
        compoundList.add(representationList.get(index));
        compoundList.add((Object)EXTENDED_REFERENCE_DELIMITER);
        compoundList.add(refRep);
        representationList.set(index, compoundList);
        return true;
    }

    private boolean performAddressMarkup(Instruction instr, int opIndex, Function func, Reference primaryRef, List<Object> representationList) {
        if (primaryRef == null || !primaryRef.isMemoryReference()) {
            return false;
        }
        Address refAddr = primaryRef.getToAddress();
        int size = representationList.size();
        for (int i = 0; i < size; ++i) {
            Object obj = representationList.get(i);
            if (!(obj instanceof Address)) continue;
            Address addr = (Address)obj;
            if (!refAddr.getPhysicalAddress().equals((Object)addr.getPhysicalAddress())) continue;
            representationList.set(i, this.getMemoryReferenceLabel((CodeUnit)instr, primaryRef));
            return true;
        }
        return false;
    }

    private boolean performScalarMarkup(Instruction inst, int opIndex, Function function, Reference primaryRef, Variable referencedVariable, Map<Register, Integer> regIndexMap, List<Object> representations) {
        InstructionScalarInfo info = new InstructionScalarInfo(representations, primaryRef);
        if (info.hasSingleAddressWithNoScalars()) {
            int addressIndex = info.getAddressIndex();
            return this.markupAddressAsRegister(inst, primaryRef, representations, addressIndex) || this.markupAddressAsScalar(inst, primaryRef, representations, addressIndex);
        }
        if (info.hasNoScalars()) {
            return false;
        }
        Program program = inst.getProgram();
        List equates = null;
        PcodeOp[] pcode = null;
        int size = representations.size();
        for (int i = 0; i < size; ++i) {
            Register operandRegister;
            Scalar scalar = info.getScalar(i);
            if (scalar == null) continue;
            if (pcode == null) {
                pcode = inst.getPcode(opIndex);
            }
            if ((operandRegister = this.findAssociatedOperandRegister(scalar, regIndexMap, pcode)) == null) {
                if (this.markupScalarWithMemoryReference(inst, scalar, i, primaryRef, representations)) {
                    primaryRef = null;
                    referencedVariable = null;
                    continue;
                }
            } else {
                if (primaryRef != null && primaryRef.isStackReference()) {
                    if (this.markupScalarWithStackReference(scalar, i, primaryRef, referencedVariable, representations)) {
                        regIndexMap.remove(operandRegister);
                        return true;
                    }
                    return false;
                }
                if (this.isRegisterAssociatedWithReferencedVariable(referencedVariable, operandRegister)) {
                    if (this.markupScalarWithReferencedRegisterVariable(scalar, i, primaryRef, referencedVariable, representations)) {
                        primaryRef = null;
                        referencedVariable = null;
                        regIndexMap.remove(operandRegister);
                        continue;
                    }
                } else {
                    if (this.markupScalarWithMemoryReference(inst, scalar, i, primaryRef, representations)) {
                        primaryRef = null;
                        referencedVariable = null;
                        continue;
                    }
                    if (this.markupScalarWithImpliedRegisterVariable(inst, function, scalar, i, operandRegister, representations)) {
                        regIndexMap.remove(operandRegister);
                        continue;
                    }
                }
            }
            if (equates == null) {
                equates = program.getEquateTable().getEquates(inst.getMinAddress(), opIndex);
            }
            this.markupScalarWithEquate(scalar, i, equates, representations);
        }
        return primaryRef == null;
    }

    private boolean markupAddressAsRegister(Instruction instr, Reference primaryRef, List<Object> representationList, int addressIndex) {
        if (primaryRef != null) {
            return false;
        }
        Address addr = (Address)representationList.get(addressIndex);
        Register reg = instr.getProgram().getRegister(addr);
        if (reg != null) {
            representationList.set(addressIndex, reg.getName());
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean markupAddressAsScalar(Instruction instr, Reference primaryRef, List<Object> representationList, int addressIndex) {
        Address addr = (Address)representationList.get(addressIndex);
        AddressSpace space = addr.getAddressSpace();
        long offset = addr.getOffset();
        int unitSize = space.getAddressableUnitSize();
        if (unitSize != 1) {
            if (MathUtilities.unsignedModulo((long)offset, (long)unitSize) != 0L) return false;
            offset = MathUtilities.unsignedDivide((long)offset, (long)unitSize);
        } else {
            offset = MathUtilities.unsignedDivide((long)offset, (long)unitSize);
        }
        Scalar scalar = new Scalar(space.getSize(), offset, false);
        if (this.markupScalarWithMemoryReference(instr, scalar, addressIndex, primaryRef, representationList)) {
            return true;
        }
        if (primaryRef != null) return false;
        return true;
    }

    private boolean markupScalarWithImpliedRegisterVariable(Instruction instr, Function func, Scalar scalarToReplace, int scalarIndex, Register associatedRegister, List<Object> representationList) {
        if (func == null || !this.options.doRegVariableMarkup || !this.options.includeInferredVariableMarkup) {
            return false;
        }
        long scalarValue = scalarToReplace.getValue();
        if (scalarToReplace.isSigned() && scalarValue <= 0L) {
            return false;
        }
        Variable regVar = instr.getProgram().getFunctionManager().getReferencedVariable(instr.getMinAddress(), associatedRegister.getAddress(), associatedRegister.getMinimumByteSize(), true);
        if (regVar == null) {
            return false;
        }
        DataType dt = this.removeTypeDefs(regVar.getDataType());
        if (!(dt instanceof Pointer)) {
            return false;
        }
        dt = ((Pointer)dt).getDataType();
        if ((dt = this.removeTypeDefs(dt)) == null || !(dt instanceof Composite) || scalarValue > (long)dt.getLength()) {
            return false;
        }
        VariableOffset variableOffset = new VariableOffset(regVar, scalarValue, true, true);
        variableOffset.setReplacedElement(scalarToReplace, this.options.includeScalarReferenceAdjustment);
        representationList.set(scalarIndex, variableOffset);
        return true;
    }

    private DataType removeTypeDefs(DataType dt) {
        if (dt instanceof TypeDef) {
            return ((TypeDef)dt).getBaseDataType();
        }
        return dt;
    }

    private boolean markupScalarWithEquate(Scalar scalarToReplace, int scalarIndex, List<Equate> equates, List<Object> representationList) {
        Equate equate;
        if (!equates.isEmpty() && (equate = this.findEquate(scalarToReplace, equates)) != null) {
            representationList.set(scalarIndex, equate);
            return true;
        }
        return false;
    }

    private boolean markupScalarWithMemoryReference(Instruction instr, Scalar scalarToReplace, int scalarIndex, Reference primaryRef, List<Object> representationList) {
        Object repObj;
        if (primaryRef != null && primaryRef.isMemoryReference() && (repObj = this.addScalarAdjustment(this.getMemoryReferenceLabel((CodeUnit)instr, primaryRef), primaryRef.getToAddress(), scalarToReplace, representationList.size() == 1)) != null) {
            representationList.set(scalarIndex, repObj);
            return true;
        }
        return false;
    }

    private boolean markupScalarWithStackReference(Scalar scalarToReplace, int scalarIndex, Reference primaryRef, Variable referencedVariable, List<Object> representationList) {
        if (this.options.doStackVariableMarkup) {
            Object varRep = this.getVariableReferenceRepresentation(primaryRef, referencedVariable, scalarToReplace);
            representationList.set(scalarIndex, varRep);
            return true;
        }
        return false;
    }

    private boolean markupScalarWithReferencedRegisterVariable(Scalar scalarToReplace, int scalarIndex, Reference primaryReference, Variable referencedVariable, List<Object> representationList) {
        if (this.options.doRegVariableMarkup) {
            Object variableRepresentation = this.getVariableReferenceRepresentation(primaryReference, referencedVariable, scalarToReplace);
            representationList.set(scalarIndex, variableRepresentation);
            return true;
        }
        return false;
    }

    private boolean isRegisterAssociatedWithReferencedVariable(Variable variable, Register register) {
        if (variable == null || !variable.isRegisterVariable()) {
            return false;
        }
        return register == variable.getRegister();
    }

    private HashMap<Register, Integer> getRegisterIndexMap(List<Object> rawRepresentationList) {
        HashMap<Register, Integer> regIndexMap = new HashMap<Register, Integer>();
        int size = rawRepresentationList.size();
        for (int i = 0; i < size; ++i) {
            Register reg;
            Object obj = rawRepresentationList.get(i);
            if (!(obj instanceof Register) || regIndexMap.remove(reg = (Register)obj) != null) continue;
            regIndexMap.put(reg, i);
        }
        return regIndexMap;
    }

    private Object addScalarAdjustment(Object opObj, Address addr, Scalar originalScalar, boolean scalarOperand) {
        long addrOffset;
        if (originalScalar == null) {
            return opObj;
        }
        long originalValue = addr.isStackAddress() && originalScalar.bitLength() == addr.getAddressSpace().getSize() ? originalScalar.getSignedValue() : originalScalar.getUnsignedValue();
        if (originalValue == (addrOffset = addr instanceof SegmentedAddress ? (long)((SegmentedAddress)addr).getSegmentOffset() : addr.getAddressableWordOffset()) || originalValue == addr.getOffset()) {
            return opObj;
        }
        OperandRepresentationList list = new OperandRepresentationList();
        if (addr.isMemoryAddress()) {
            list.add((Object)"offset ");
            for (int element : SHIFT_CASES) {
                if (addrOffset >>> element != originalValue || originalValue == 0L) continue;
                list.add(opObj);
                if (this.options.includeScalarReferenceAdjustment) {
                    list.add((Object)" >>");
                    list.add((Object)Integer.toString(element));
                }
                return list;
            }
            for (long element : MASK_CASES) {
                if ((addrOffset & element) != originalValue) continue;
                list.add(opObj);
                if (this.options.includeScalarReferenceAdjustment) {
                    list.add((Object)" &");
                    list.add((Object)("0x" + Long.toHexString(element)));
                }
                return list;
            }
            if (!scalarOperand) {
                return null;
            }
        }
        list.add(opObj);
        if (this.options.includeScalarReferenceAdjustment) {
            long l = originalValue - addrOffset;
            if (l < 0L) {
                list.add((Object)Character.valueOf('-'));
                l = -l;
            } else {
                list.add((Object)Character.valueOf('+'));
            }
            list.add((Object)new Scalar(addr.getSize(), l));
        }
        return list;
    }

    private boolean isRead(Register register, Instruction instruction) {
        for (Object obj : instruction.getInputObjects()) {
            if (obj != register) continue;
            return true;
        }
        return false;
    }

    private boolean isWritten(Register register, Instruction instruction) {
        for (Object obj : instruction.getResultObjects()) {
            if (obj != register) continue;
            return true;
        }
        return false;
    }

    private Register getRegister(Address addr, Map<Register, Integer> regIndexMap) {
        for (Register reg : regIndexMap.keySet()) {
            if (!reg.getAddress().equals((Object)addr)) continue;
            return reg;
        }
        return null;
    }

    private Register findRegister(Varnode v, Map<Register, Integer> regIndexMap) {
        Register reg;
        if (v.isRegister() && (reg = this.getRegister(v.getAddress(), regIndexMap)) != null) {
            return reg;
        }
        return null;
    }

    private boolean equals(Varnode v, Scalar value) {
        Scalar s = new Scalar(v.getSize() * 8, v.getOffset(), value.isSigned());
        return s.getValue() == value.getValue();
    }

    private Register findAssociatedOperandRegister(Scalar scalar, Map<Register, Integer> regIndexMap, PcodeOp[] pcode) {
        if (regIndexMap.isEmpty() || pcode == null) {
            return null;
        }
        for (PcodeOp op : pcode) {
            if (op.getOpcode() != 19) continue;
            Varnode[] inputs = op.getInputs();
            Register reg = null;
            if (inputs[0].isConstant() && this.equals(inputs[0], scalar)) {
                reg = this.findRegister(inputs[1], regIndexMap);
            } else if (inputs[1].isConstant() && this.equals(inputs[1], scalar)) {
                reg = this.findRegister(inputs[0], regIndexMap);
            }
            if (reg == null) continue;
            return reg;
        }
        return null;
    }

    private Equate findEquate(Scalar scalar, List<Equate> equates) {
        for (Equate equate : equates) {
            if (equate.getValue() != scalar.getSignedValue() && equate.getValue() != scalar.getValue()) continue;
            return equate;
        }
        return null;
    }

    public OperandRepresentationList getDataValueRepresentation(Data data) {
        int preferredLength;
        EquateTable equTable;
        Equate equate;
        Reference ref = data.getPrimaryReference(0);
        OperandRepresentationList representationList = new OperandRepresentationList();
        DataType dataType = data.getDataType();
        int length = data.getLength();
        if (!(length == 0 && dataType.isZeroLength() || dataType.getLength() <= length)) {
            representationList.add((Object)("Data type \"" + dataType.getDisplayName() + "\" is too big for available space. Size = " + dataType.getLength() + " bytes, available = " + length + " bytes"));
            representationList.setHasError(true);
            representationList.setPrimaryReferenceHidden(ref != null);
            return representationList;
        }
        Object dataValue = data.getValue();
        DataType baseDataType = data.getBaseDataType();
        if (ref != null && !(baseDataType instanceof Composite) && !(baseDataType instanceof Array)) {
            Object refRep;
            boolean parentIsUnion;
            Data parent = data.getParent();
            boolean bl = parentIsUnion = parent != null && parent.getBaseDataType() instanceof Union;
            if ((!parentIsUnion || baseDataType instanceof Pointer || dataValue instanceof Address) && (refRep = this.getReferenceRepresentation((CodeUnit)data, ref, null)) != null) {
                representationList.add(refRep);
                return representationList;
            }
        }
        if (dataValue instanceof Scalar && (equate = (equTable = data.getProgram().getEquateTable()).getEquate(data.getMinAddress(), 0, ((Scalar)dataValue).getValue())) != null) {
            representationList.add((Object)equate);
            representationList.setPrimaryReferenceHidden(ref != null);
            return representationList;
        }
        if (dataType instanceof Dynamic && ((Dynamic)dataType).canSpecifyLength() && (preferredLength = ((Dynamic)dataType).getLength((MemBuffer)data, length)) > length) {
            representationList.setHasError(true);
        }
        representationList.setPrimaryReferenceHidden(ref != null);
        if (data.isDefined() && dataValue == null) {
            DataType baseDt = dataType;
            if (baseDt instanceof TypeDef) {
                baseDt = ((TypeDef)dataType).getBaseDataType();
            }
            if (baseDt instanceof Pointer) {
                PointerDataType.getAddressValue((MemBuffer)data, (int)baseDt.getLength(), (Settings)data, m -> representationList.add(m));
            }
            representationList.setHasError(true);
        }
        if (representationList.isEmpty()) {
            representationList.add((Object)dataType.getRepresentation((MemBuffer)data, (Settings)data, length));
        }
        if (dataValue instanceof Address && ref == null && data.getProgram().getMemory().getBlock((Address)dataValue) == null) {
            representationList.setHasError(true);
        }
        return representationList;
    }

    public String getDataValueRepresentationString(Data data) {
        return this.getDataValueRepresentation(data).toString();
    }

    private Object getVariableReferenceRepresentation(Reference ref, Variable var, Scalar replacedScalar) {
        if (var != null) {
            VariableOffset varOffset = new VariableOffset(ref, var);
            varOffset.setReplacedElement(replacedScalar, this.options.includeScalarReferenceAdjustment);
            return varOffset;
        }
        if (ref.isStackReference()) {
            OperandRepresentationList compoundList = new OperandRepresentationList();
            compoundList.add((Object)"Stack");
            compoundList.add((Object)Character.valueOf('['));
            compoundList.add((Object)new Scalar(32, (long)((StackReference)ref).getStackOffset(), true));
            compoundList.add((Object)Character.valueOf(']'));
            return this.addScalarAdjustment(compoundList, ref.getToAddress(), replacedScalar, false);
        }
        return null;
    }

    public String getReferenceRepresentationString(CodeUnit fromCodeUnit, Reference ref) {
        Variable refVar = fromCodeUnit.getProgram().getFunctionManager().getReferencedVariable(fromCodeUnit.getMinAddress(), ref.getToAddress(), 0, false);
        Object repObj = this.getReferenceRepresentation(fromCodeUnit, ref, refVar);
        return repObj != null ? repObj.toString() : null;
    }

    private Object getReferenceRepresentation(CodeUnit cu, Reference ref, Variable var) {
        if (ref == null) {
            return null;
        }
        if (!ref.isExternalReference() && (var != null || ref.isStackReference() || ref.isRegisterReference())) {
            return this.getVariableReferenceRepresentation(ref, var, null);
        }
        if (ref.isMemoryReference() && ref instanceof OffsetReference) {
            return this.getOffsetReferenceRepresentation(cu, (OffsetReference)ref);
        }
        if (ref.isMemoryReference() || ref.isExternalReference()) {
            return this.getMemoryReferenceLabel(cu, ref);
        }
        return null;
    }

    private Object getOffsetReferenceRepresentation(CodeUnit cu, OffsetReference offsetRef) {
        MemReferenceImpl baseRef = new MemReferenceImpl(offsetRef.getFromAddress(), offsetRef.getBaseAddress(), RefType.DATA, offsetRef.getSource(), offsetRef.getOperandIndex(), offsetRef.isPrimary());
        Object baseRefObj = this.getMemoryReferenceLabel(cu, (Reference)baseRef);
        long offset = offsetRef.getOffset();
        String sign = PLUS;
        if (offset < 0L) {
            sign = "";
        }
        Scalar offsetScalar = new Scalar(64, offset, true);
        OperandRepresentationList list = new OperandRepresentationList();
        list.add(baseRefObj);
        list.add((Object)sign);
        list.add((Object)offsetScalar);
        return list;
    }

    private Object getMemoryReferenceLabel(CodeUnit fromCodeUnit, Reference ref) {
        LabelString extLabel;
        Symbol toSymbol;
        Program program = fromCodeUnit.getProgram();
        Address toAddress = ref.getToAddress();
        boolean withBlockName = false;
        MemoryBlock refBlock = null;
        if (toAddress.isMemoryAddress()) {
            Memory mem = program.getMemory();
            refBlock = mem.getBlock(toAddress);
            if (this.options.showBlockName == CodeUnitFormatOptions.ShowBlockName.ALWAYS) {
                withBlockName = true;
            } else if (this.options.showBlockName == CodeUnitFormatOptions.ShowBlockName.NON_LOCAL) {
                MemoryBlock block = mem.getBlock(fromCodeUnit.getMinAddress());
                withBlockName = block != refBlock;
            }
        }
        String result = (toSymbol = program.getSymbolTable().getSymbol(ref)) != null ? this.getSymbolLabelString(program, toSymbol, fromCodeUnit.getMinAddress()) : toAddress.toString();
        result = this.addBlockName(program, toAddress, result, refBlock, withBlockName);
        LabelString.LabelType labelType = toSymbol != null && toSymbol.isExternal() ? LabelString.EXTERNAL : LabelString.CODE_LABEL;
        LabelString label = new LabelString(result, labelType);
        RefType referenceType = ref.getReferenceType();
        if (this.options.followReferencedPointers && (referenceType.isIndirect() || ref.getReferenceType() == RefType.READ) && (extLabel = this.getExtendedPointerReferenceMarkup(program, ref)) != null) {
            OperandRepresentationList list = new OperandRepresentationList();
            list.add((Object)EXTENDED_INDIRECT_REFERENCE_DELIMITER);
            list.add((Object)extLabel);
            return list;
        }
        return label;
    }

    private LabelString getExtendedPointerReferenceMarkup(Program program, Reference ref) {
        Address toAddress = ref.getToAddress();
        Listing listing = program.getListing();
        if (listing.getDefinedDataAt(toAddress) == null) {
            return null;
        }
        ReferenceManager referenceManager = program.getReferenceManager();
        Reference[] referencesFrom = referenceManager.getReferencesFrom(toAddress);
        if (referencesFrom.length != 1 || referencesFrom[0].getReferenceType() != RefType.DATA) {
            return null;
        }
        Symbol symbol = program.getSymbolTable().getSymbol(referencesFrom[0]);
        if (symbol != null && !symbol.isDynamic()) {
            String result = this.getSymbolLabelString(program, symbol, ref.getFromAddress());
            return new LabelString(result, symbol.isExternal() ? LabelString.EXTERNAL : LabelString.CODE_LABEL);
        }
        return null;
    }

    private String addBlockName(Program program, Address toAddress, String name, MemoryBlock refBlock, boolean withBlockName) {
        if (withBlockName && refBlock != null) {
            return refBlock.getName() + ":" + name;
        }
        return name;
    }

    private String addNamespace(Program program, Namespace parentNamespace, String name, Address markupAddress) {
        if (parentNamespace == null) {
            return name;
        }
        if (this.options.showNamespace == CodeUnitFormatOptions.ShowNamespace.NEVER) {
            return name;
        }
        if (parentNamespace.getID() == 0L) {
            return name;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace toNamespace = symbolTable.getNamespace(markupAddress);
        boolean isLocal = parentNamespace.equals(toNamespace);
        if (isLocal && this.options.showNamespace == CodeUnitFormatOptions.ShowNamespace.NON_LOCAL) {
            return name;
        }
        if (!isLocal && this.options.showNamespace == CodeUnitFormatOptions.ShowNamespace.LOCAL) {
            return name;
        }
        Object namespaceName = null;
        if (isLocal) {
            namespaceName = this.options.localPrefixOverride;
        }
        if (namespaceName == null) {
            namespaceName = !this.options.showLibraryInNamespace ? NamespaceUtils.getNamespacePathWithoutLibrary((Namespace)parentNamespace) : parentNamespace.getName(true);
        }
        if (((String)namespaceName).length() != 0 && !((String)namespaceName).endsWith("::")) {
            namespaceName = (String)namespaceName + "::";
        }
        return (String)namespaceName + name;
    }

    private String getSymbolLabelString(Program program, Symbol symbol, Address markupAddress) {
        Address symbolAddress = symbol.getAddress();
        if (symbolAddress.isMemoryAddress()) {
            CodeUnit cu = program.getListing().getCodeUnitContaining(symbolAddress);
            if (this.isOffcut(symbolAddress, cu)) {
                return this.getOffcutLabelString(symbolAddress, cu);
            }
            if (this.isStringData(cu)) {
                return this.getLabelStringForStringData((Data)cu, symbol);
            }
        }
        String name = symbol.getName();
        String displayName = this.addNamespace(program, symbol.getParentNamespace(), name, markupAddress);
        return this.simplifyTemplate(displayName);
    }

    private String simplifyTemplate(String name) {
        return this.options.simplifyTemplate(name);
    }

    private boolean isStringData(CodeUnit cu) {
        if (cu instanceof Data) {
            return ((Data)cu).hasStringValue();
        }
        return false;
    }

    private String getLabelStringForStringData(Data data, Symbol symbol) {
        if (!symbol.isDynamic()) {
            return this.options.simplifyTemplate(symbol.getName());
        }
        DataType dataType = data.getBaseDataType();
        String prefix = dataType.getDefaultLabelPrefix((MemBuffer)data, (Settings)data, data.getLength(), this.options.displayOptions);
        if (prefix == null) {
            return symbol.getName();
        }
        return prefix + UNDERSCORE + SymbolUtilities.getAddressString((Address)symbol.getAddress());
    }

    public String getOffcutLabelString(Address offcutAddress, CodeUnit cu) {
        if (cu instanceof Instruction) {
            return this.getOffcutLabelStringForInstruction(offcutAddress, (Instruction)cu);
        }
        return this.getOffcutDataString(offcutAddress, (Data)cu);
    }

    private boolean isOffcut(Address address, CodeUnit cu) {
        if (cu == null) {
            return false;
        }
        return !cu.getMinAddress().equals((Object)address);
    }

    protected String getOffcutDataString(Address offcutAddress, Data data) {
        Program program = data.getProgram();
        Symbol offcutSymbol = program.getSymbolTable().getPrimarySymbol(offcutAddress);
        Address dataAddress = data.getMinAddress();
        int diff = (int)offcutAddress.subtract(dataAddress);
        if (!offcutSymbol.isDynamic()) {
            return this.getDefaultOffcutString(offcutSymbol, (CodeUnit)data, diff, false);
        }
        DataType dt = data.getBaseDataType();
        String prefix = this.getPrefixForStringData(data, dataAddress, diff, dt);
        if (prefix != null) {
            String addressString = SymbolUtilities.getAddressString((Address)dataAddress);
            return this.addOffcutInformation(prefix, addressString, diff, this.options.showOffcutInfo);
        }
        return this.getDefaultOffcutString(offcutSymbol, (CodeUnit)data, diff, false);
    }

    protected String getOffcutLabelStringForInstruction(Address offcutAddress, Instruction instruction) {
        Program program = instruction.getProgram();
        Symbol offsym = program.getSymbolTable().getPrimarySymbol(offcutAddress);
        Address instructionAddress = instruction.getMinAddress();
        long diff = offcutAddress.subtract(instructionAddress);
        if (!offsym.isDynamic()) {
            return this.getDefaultOffcutString(offsym, (CodeUnit)instruction, diff, false);
        }
        Symbol containingSymbol = program.getSymbolTable().getPrimarySymbol(instructionAddress);
        if (containingSymbol != null) {
            return this.options.simplifyTemplate(containingSymbol.getName()) + PLUS + diff;
        }
        return this.getDefaultOffcutString(offsym, (CodeUnit)instruction, diff, false);
    }

    protected String addOffcutInformation(String prefix, String addressString, int diff, boolean decorate) {
        if (!decorate) {
            return prefix;
        }
        return prefix + UNDERSCORE + addressString + PLUS + diff;
    }

    protected String getPrefixForStringData(Data data, Address dataAddress, int diff, DataType dt) {
        if (data.hasStringValue()) {
            int len = data.getLength();
            return dt.getDefaultOffcutLabelPrefix((MemBuffer)data, (Settings)data, len, this.options.displayOptions, diff);
        }
        return null;
    }

    protected String getDefaultOffcutString(Symbol symbol, CodeUnit cu, long diff, boolean decorate) {
        String name = this.options.simplifyTemplate(symbol.getName());
        if (decorate) {
            return name + " (" + cu.getMinAddress() + PLUS + diff + ")";
        }
        return name;
    }

    public CodeUnitFormatOptions.ShowBlockName getShowBlockName() {
        return this.options.showBlockName;
    }

    private class InstructionScalarInfo {
        boolean processZeroScalar = false;
        int scalarCount = 0;
        int addressCount = 0;
        int lastAddressIndex = -1;
        private List<Object> representationList;

        InstructionScalarInfo(List<Object> representationList, Reference primaryRef) {
            this.representationList = representationList;
            boolean hasZeroScalar = false;
            int size = representationList.size();
            for (int i = 0; i < size; ++i) {
                Object obj = representationList.get(i);
                if (obj instanceof Scalar) {
                    if (((Scalar)obj).getUnsignedValue() == 0L) {
                        hasZeroScalar = true;
                        continue;
                    }
                    ++this.scalarCount;
                    this.addressCount = 0;
                    continue;
                }
                if (!(obj instanceof Address) || this.scalarCount != 0) continue;
                ++this.addressCount;
                this.lastAddressIndex = i;
            }
            if (hasZeroScalar && this.scalarCount == 0 && this.addressCount == 0 && primaryRef == null) {
                ++this.scalarCount;
                this.processZeroScalar = true;
            }
        }

        Scalar getScalar(int index) {
            Object obj = this.representationList.get(index);
            if (!(obj instanceof Scalar)) {
                return null;
            }
            Scalar scalar = (Scalar)obj;
            if (scalar.getUnsignedValue() == 0L) {
                return this.processZeroScalar ? scalar : null;
            }
            return scalar;
        }

        boolean hasSingleAddressWithNoScalars() {
            return this.scalarCount == 0 && this.addressCount == 1;
        }

        int getAddressIndex() {
            return this.lastAddressIndex;
        }

        boolean hasNoScalars() {
            return this.scalarCount == 0;
        }
    }
}

