/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetMapping;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.AssertException;

public class MemoryAddressSetCharSequence
implements CharSequence {
    private final Memory memory;
    private final AddressSetView set;
    private final AddressSetMapping mapping;

    public MemoryAddressSetCharSequence(Memory memory, AddressSetView addressSet) throws MemoryAccessException {
        this.memory = memory;
        this.set = addressSet;
        if (addressSet.getNumAddresses() > Integer.MAX_VALUE) {
            throw new AssertException("The MemAddressSetCharSequence class only supports address sets of size <= 0x7ffffffff byte addresses.");
        }
        if (!memory.getAllInitializedAddressSet().contains(addressSet)) {
            throw new MemoryAccessException("Not all addresses in given address set are in memory!");
        }
        this.mapping = new AddressSetMapping(addressSet);
    }

    public MemoryAddressSetCharSequence(Memory memory, Address start, Address end) throws MemoryAccessException {
        this(memory, (AddressSetView)new AddressSet(start, end));
    }

    public Address getAddressAtIndex(int index) {
        return this.mapping.getAddress(index);
    }

    @Override
    public int length() {
        return (int)this.set.getNumAddresses();
    }

    @Override
    public char charAt(int index) {
        Address address = this.getAddressAtIndex(index);
        try {
            byte b = this.memory.getByte(address);
            return (char)(b & 0xFF);
        }
        catch (MemoryAccessException e) {
            throw new AssertException("Can't happen since we already checked in constructor");
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start >= this.length() || end < 0 || end >= this.length()) {
            throw new IndexOutOfBoundsException("Start and end must be in [0, " + (this.length() - 1));
        }
        Address startAddress = this.getAddressAtIndex(start);
        Address endAddress = this.getAddressAtIndex(end);
        AddressSet intersectSet = this.set.intersectRange(startAddress, endAddress);
        try {
            return new MemoryAddressSetCharSequence(this.memory, (AddressSetView)intersectSet);
        }
        catch (MemoryAccessException e) {
            throw new AssertException("Can't happen since we already checked");
        }
    }
}

