/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.AsyncUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class AsyncTimer {
    public static final AsyncTimer DEFAULT_TIMER = new AsyncTimer();
    protected ExecutorService thread = Executors.newSingleThreadExecutor();

    public CompletableFuture<Void> atSystemTime(long timeMillis) {
        if (timeMillis - System.currentTimeMillis() <= 0L) {
            return AsyncUtils.NIL;
        }
        long delta = timeMillis - System.currentTimeMillis();
        Executor executor = delta <= 0L ? this.thread : CompletableFuture.delayedExecutor(delta, TimeUnit.MILLISECONDS);
        return CompletableFuture.runAsync(() -> {}, executor);
    }

    public Mark mark() {
        return new Mark(System.currentTimeMillis());
    }

    public class Mark {
        protected final long mark;

        protected Mark(long mark) {
            this.mark = mark;
        }

        public CompletableFuture<Void> after(long intervalMillis) {
            return AsyncTimer.this.atSystemTime(this.mark + intervalMillis);
        }

        public <T> CompletableFuture<T> timeOut(CompletableFuture<T> future, long millis, Supplier<T> valueIfLate) {
            return CompletableFuture.anyOf(future, this.after(millis)).thenApply(v -> {
                if (future.isDone()) {
                    return future.getNow(null);
                }
                return valueIfLate.get();
            });
        }
    }
}

